/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.servlet;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

public class TableMoverServlet
extends HttpServlet {
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            DataSource source = (DataSource)new InitialContext().lookup("jdbc/SybaseOldDS");
            DataSource destination = (DataSource)new InitialContext().lookup("jdbc/SybaseDS");
            this.moveSubscriptions(source.getConnection(), destination.getConnection());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void move(Connection fromConnection, Connection toConnection) throws Throwable {
        toConnection.setAutoCommit(false);
        ResultSet from = fromConnection.createStatement().executeQuery("select * from MailingListMessage");
        PreparedStatement statement = toConnection.prepareStatement("insert into MailingListMessage (id, list, submitter, parent, subject, body, _date) values (?, ?, ?, ?, ?, ?, ?)");
        while (from.next()) {
            statement.setInt(1, from.getInt("id"));
            statement.setString(2, from.getString("list"));
            statement.setString(3, from.getString("submitter"));
            statement.setInt(4, from.getInt("parent"));
            statement.setString(5, from.getString("subject"));
            statement.setString(6, from.getString("body"));
            statement.setTimestamp(7, from.getTimestamp("_date"));
            statement.executeUpdate();
        }
        from.close();
        fromConnection.close();
        toConnection.commit();
        toConnection.close();
    }

    protected void moveSubscriptions(Connection fromConnection, Connection toConnection) throws Throwable {
        toConnection.setAutoCommit(false);
        ResultSet from = fromConnection.createStatement().executeQuery("select * from MailingListSubscription");
        PreparedStatement statement = toConnection.prepareStatement("insert into MailingListSubscription (list, address, _username) values (?, ?, ?)");
        while (from.next()) {
            statement.setString(1, from.getString("list"));
            statement.setString(2, from.getString("address"));
            statement.setString(3, from.getString("_username"));
            statement.executeUpdate();
        }
        from.close();
        fromConnection.close();
        toConnection.commit();
        toConnection.close();
    }
}

