/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpFileFetcherServlet
extends HttpServlet {
    ServletContext context;
    static final int MAXIMUM_CACHE_SIZE = 102400;
    private HashMap cachedFiles = new HashMap();

    public void init(ServletConfig config) throws ServletException {
        this.context = config.getServletContext();
        super.init(config);
    }

    public long getLastModified(HttpServletRequest request) {
        return new File(this.context.getRealPath(request.getRequestURI())).lastModified();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            byte[] cache;
            FileInformation info = null;
            String requestedPath = request.getRequestURI();
            HttpFileFetcherServlet httpFileFetcherServlet = this;
            synchronized (httpFileFetcherServlet) {
                info = (FileInformation)this.cachedFiles.get(requestedPath);
            }
            if (info == null || info.file.lastModified() != info.modifiedDate) {
                String realPath = this.context.getRealPath(requestedPath);
                File requestedFile = new File(realPath);
                FileInputStream fileIn = new FileInputStream(requestedFile);
                int fileLength = (int)requestedFile.length();
                if (fileLength > 102400) {
                    response.setContentLength(fileLength);
                    ServletOutputStream out = response.getOutputStream();
                    byte[] cache2 = new byte[102400];
                    while (fileLength > 102400) {
                        fileIn.read(cache2);
                        out.write(cache2);
                        fileLength -= 102400;
                    }
                    fileIn.read(cache2, 0, fileLength);
                    out.write(cache2, 0, fileLength);
                    fileIn.close();
                    out.close();
                    return;
                }
                cache = new byte[fileLength];
                fileIn.read(cache);
                fileIn.close();
                HttpFileFetcherServlet httpFileFetcherServlet2 = this;
                synchronized (httpFileFetcherServlet2) {
                    this.cachedFiles.put(requestedPath, new FileInformation(requestedFile, requestedFile.lastModified(), cache));
                }
            } else {
                cache = info.data;
                info.used = true;
            }
            response.setContentLength(cache.length);
            ServletOutputStream out = response.getOutputStream();
            out.write(cache);
            out.close();
        }
        catch (FileNotFoundException e) {
            response.sendError(404);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUnusedCacheFiles() {
        HttpFileFetcherServlet httpFileFetcherServlet = this;
        synchronized (httpFileFetcherServlet) {
            Iterator iterator = this.cachedFiles.values().iterator();
            while (iterator.hasNext()) {
                FileInformation info = (FileInformation)iterator.next();
                if (!info.used) {
                    iterator.remove();
                }
                info.used = false;
            }
        }
    }

    private class FileInformation {
        public File file;
        public long modifiedDate;
        public byte[] data;
        public boolean used = true;

        public FileInformation(File file, long modifiedDate, byte[] data) {
            this.file = file;
            this.modifiedDate = modifiedDate;
            this.data = data;
        }
    }
}

