/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.net.AccessRegionSet;
import com.evermind.server.ApplicationServer;
import com.evermind.server.OC4JServer;
import com.evermind.server.XMLApplicationServerConfig;
import com.evermind.server.XMLServerConfig;
import com.evermind.server.rmi.RMIServerConfig;
import com.evermind.server.rmi.RMIServerInfo;
import com.evermind.ssl.SSLConfig;
import com.evermind.util.RMIProperties;
import com.evermind.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.oc4j.security.SSLMessages;
import oracle.oc4j.security.SSLUtils;
import org.w3c.dom.Node;

public class XMLRMIServerConfig
extends XMLServerConfig
implements RMIServerConfig {
    static final int DEFAULT_MAX_SOCKETS = 500;
    public static String islandId;
    private List nodes;
    private SSLConfig sslConfig;
    private int sslPort = -1;
    private int maxSockets = 500;
    private boolean serializeCalls = false;
    private AccessRegionSet accessRegionSet;
    private AccessRegionSet subjectPropagationAccessRegionSet;
    private int _serverConnectionTimeout = 0;
    public static final String DEFAULT_RMI_MULTICAST_GROUP = "230.230.0.1";
    public static final Logger m_logger;

    protected void reset() {
        super.reset();
        this.nodes = null;
        this.accessRegionSet = null;
        this.serializeCalls = false;
    }

    public XMLRMIServerConfig(XMLApplicationServerConfig parent) {
        super(parent);
    }

    protected void verifyDocumentType(String type) throws InstantiationException {
        if (!type.equals("rmi-server")) {
            throw new InstantiationException("rmi-server document type expected");
        }
    }

    protected void parseDeploymentRootNodeValue(String name, String value) throws InstantiationException {
        if (name.equals("serialize-connection-calls")) {
            this.serializeCalls = "true".equalsIgnoreCase(value);
        } else if (name.equals("ssl-port")) {
            try {
                this.setSslPort(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                throw new InstantiationException("Illegal port value (not a number between 0 and 65535): '" + value + "'");
            }
        } else if (name.equals("max-server-sockets")) {
            this.setMaxServerSockets(Integer.parseInt(value));
        } else {
            super.parseDeploymentRootNodeValue(name, value);
        }
    }

    public void parseDeploymentMainNode(Node node) throws InstantiationException {
        String name = node.getNodeName();
        if (name.equals("server")) {
            this.addNode(new RMIServerInfo(node));
        } else if (name.equals("cluster")) {
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "<cluster> not supported in <rmi-server> configuration.");
            }
        } else if (name.equals("ssl-config")) {
            this.warnIfExistingSslConfig();
            this.setSslConfig(new SSLConfig(node, this.getURL()));
        } else if (name.equals("access-mask")) {
            try {
                this.accessRegionSet = AccessRegionSet.getSet(node);
            }
            catch (Exception e) {
                throw new InstantiationException("Error initializing AccessRegionSet: " + e.getMessage());
            }
        } else if (name.equals("subject-propagation-mask")) {
            try {
                this.subjectPropagationAccessRegionSet = AccessRegionSet.getSet(node);
            }
            catch (Exception e) {
                throw new InstantiationException("Error initializing SubjectPropagationAccessRegionSet: " + e.getMessage());
            }
        } else if (name.equals("server-connection")) {
            try {
                this._serverConnectionTimeout = Integer.parseInt(XMLUtils.getNodeAttribute(node, "connection-timeout"));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            super.parseDeploymentMainNode(node);
        }
    }

    public void addNode(RMIServerInfo info) {
        if (this.nodes == null) {
            this.nodes = new ArrayList();
        }
        this.nodes.add(info);
    }

    protected void assignDefaultPort() {
        if (-1 != this.port) {
            super.assignDefaultPort();
        }
    }

    protected int getDefaultPort() {
        return 23791;
    }

    public int getPort() {
        if (-1 == this.port && this.getSslPort() >= 0) {
            return -1;
        }
        return super.getPort();
    }

    public void setSslPort(int sslPort) {
        this.sslPort = sslPort;
    }

    public int getSslPort() {
        return this.sslPort;
    }

    public void setMaxServerSockets(int maxSockets) {
        this.maxSockets = maxSockets;
    }

    public int getMaxServerSockets() {
        return this.maxSockets;
    }

    public List getNodes() {
        if (this.nodes == null) {
            return Collections.EMPTY_LIST;
        }
        return this.nodes;
    }

    public AccessRegionSet getAccessRegionSet() {
        return this.accessRegionSet;
    }

    public void setAccessRegionSet(AccessRegionSet ars) {
        this.accessRegionSet = null == ars ? null : new AccessRegionSet(ars);
    }

    public AccessRegionSet getSubjectPropagationAccessRegionSet() {
        return this.subjectPropagationAccessRegionSet;
    }

    public void setSubjectPropagationAccessRegionSet(AccessRegionSet ars) {
        this.subjectPropagationAccessRegionSet = null == ars ? null : new AccessRegionSet(ars);
    }

    public SSLConfig getSslConfig() {
        if (null != this.sslConfig) {
            return this.sslConfig;
        }
        if (null != this.getParent()) {
            return ((XMLApplicationServerConfig)this.getParent()).getSslConfig();
        }
        return null;
    }

    public void setSslConfig(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    public void warnIfExistingSslConfig() {
        if (null != this.sslConfig) {
            SSLMessages.logMultipleSslConfigurations();
        }
    }

    protected void writeConfig(PrintWriter out) throws IOException {
        out.println("<?xml version=\"1.0\"?>");
        out.println();
        this.writeXML(out, "");
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.print(indention + "<rmi-server xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"http://xmlns.oracle.com/oracleas/schema/rmi-server-10_0.xsd\"   ");
        out.print(" host=\"" + XMLUtils.encode(this.getAddress().getHostName()) + "\"");
        if (this.getPort() != 23791) {
            out.print(" port=\"" + this.getPort() + "\"");
        }
        if (this.getSslPort() > 0) {
            out.print(" ssl-port=\"" + this.getSslPort() + "\"");
        }
        if (this.serializeCalls) {
            out.print(" serialize-connection-calls=\"" + this.serializeCalls + "\"");
        }
        if (this.getTaskManagerInterval() > 0L) {
            out.println(" taskmanager-interval=\"" + this.getTaskManagerInterval() + "\"");
        }
        if (this.getMaxServerSockets() > 0 && this.getMaxServerSockets() != 500) {
            out.println(" max-server-sockets=\"" + this.getMaxServerSockets() + "\"");
        }
        out.println(" schema-major-version=\"10\" schema-minor-version=\"0\">");
        if (this.nodes != null) {
            XMLUtils.writeAll(this.nodes, out, indention + "\t");
        }
        if (this.accessRegionSet != null) {
            this.accessRegionSet.writeXML(out, indention + "\t");
        }
        if (this.subjectPropagationAccessRegionSet != null) {
            this.subjectPropagationAccessRegionSet.writeXML(out, indention + "\t", "subject-propagation-mask");
        }
        if (null != this.sslConfig) {
            this.sslConfig.writeXML(out, indention + " ");
        }
        if (this._serverConnectionTimeout > 0) {
            out.println(indention + "<server-connection connection-timeout=\"" + this._serverConnectionTimeout + "\" />");
        }
        out.println(indention + "</rmi-server>");
    }

    public boolean getSerializeCalls() {
        return this.serializeCalls;
    }

    public int getServerConnectionTimeout() {
        return this._serverConnectionTimeout;
    }

    public void init(URL url) throws InstantiationException, IOException {
        int rmisPort;
        super.init(url);
        int rmiPort = this.getRmiOpmnPort();
        if (rmiPort > 0) {
            this.port = rmiPort;
        }
        if ((rmisPort = this.getRmisOpmnPort()) > 0) {
            this.setSslPort(rmisPort);
            this.initOpmnSslConfig();
        }
    }

    public int getRmiOpmnPort() {
        return RMIProperties.getPortRmi();
    }

    public int getRmisOpmnPort() {
        return RMIProperties.getPortRmis();
    }

    private void initOpmnSslConfig() throws IOException {
        SSLUtils.Values defaultConfigValues = SSLUtils.getDefaultValues("rmi");
        if (defaultConfigValues.isSpecified() || null == this.getSslConfig()) {
            this.setSslConfig(new SSLConfig(null, defaultConfigValues));
        }
    }

    protected void createDMSState(String dmsStr) {
        ApplicationServer.stateFactory().create(OC4JServer.getOpmnNoun(), "rmi_log", "", "RMI log file path", (Object)dmsStr);
    }

    static {
        m_logger = Logger.getLogger(XMLRMIServerConfig.class.getName());
    }
}

