/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.net.AddressContainer;
import com.evermind.server.ThreadState;
import com.evermind.server.rmi.RMIInterceptorException;
import com.evermind.server.rmi.RMIOutputStream;
import com.evermind.server.rmi.RMIServerConnection;
import com.evermind.server.rmi.ServerRmiMessageHandler;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.LoggingUtils;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.rmi.ApplicationStoppedException;
import oracle.oc4j.rmi.OracleRemoteException;

public class RmiMethodCall
implements Runnable {
    private static Logger m_logger = TraceLogger.getLogger(RmiMethodCall.class);
    private ServerRmiMessageHandler m_messageHandler;
    private AddressContainer m_addressContainer;
    private int m_callId;
    private RMIOutputStream m_out;
    private RMIServerConnection m_connection;
    private Method m_method;
    private Object m_object;
    private Object[] m_args;

    public RmiMethodCall(ServerRmiMessageHandler messageHandler, AddressContainer addressContainer, int callId, RMIOutputStream out, RMIServerConnection connection, Method method, Object object, Object[] args) {
        this.m_messageHandler = messageHandler;
        this.m_addressContainer = addressContainer;
        this.m_callId = callId;
        this.m_out = out;
        this.m_connection = connection;
        this.m_method = method;
        this.m_object = object;
        this.m_args = args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        ThreadState state = ThreadState.getCurrentState();
        if (this.m_connection != null) {
            this.m_connection.incrementActiveThreadCount();
        }
        try {
            try {
                this.m_messageHandler.establishCallingContext(state, this.m_addressContainer);
                try {
                    state.setCallerIsORMI();
                    this.m_messageHandler.getProtocol().getInterceptorManager().fireReceiveRequestInterceptor(this.m_messageHandler.m_serverInterceptors, this.m_callId, this.m_messageHandler.createInterceptorContext(this.m_addressContainer));
                    if (m_logger.isLoggable(Level.FINE)) {
                        m_logger.log(Level.FINE, "invoked object:{0} method:{1}", new Object[]{this.m_object, this.m_method});
                    }
                    this.m_messageHandler.returnMethodInvocationResponse(this.m_out, this.m_callId, this.m_method, this.m_method.invoke(this.m_object, this.m_args));
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof ApplicationStoppedException) {
                        this.m_messageHandler.returnException(this.m_out, this.m_callId, true, new OracleRemoteException("Application was stopped"));
                    } else {
                        this.m_messageHandler.returnException(this.m_out, this.m_callId, false, e.getCause());
                    }
                    Object var5_6 = null;
                    if (this.m_connection != null) {
                        this.m_connection.decrementActiveThreadCount();
                    }
                    if (state != null) {
                        state.reset();
                    }
                    return;
                }
                catch (RMIInterceptorException e) {
                    this.m_messageHandler.returnException(this.m_out, this.m_callId, true, new OracleRemoteException("Enountered error during interceptor processing", e.getCause()));
                    Object var5_7 = null;
                    if (this.m_connection != null) {
                        this.m_connection.decrementActiveThreadCount();
                    }
                    if (state != null) {
                        state.reset();
                    }
                    return;
                }
                catch (Throwable t) {
                    this.m_messageHandler.returnException(this.m_out, this.m_callId, true, t);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    state.resetCallerIsORMI();
                    Object var5_8 = null;
                    if (this.m_connection != null) {
                        this.m_connection.decrementActiveThreadCount();
                    }
                    if (state != null) {
                        state.reset();
                    }
                    return;
                }
                finally {
                    state.resetCallerIsORMI();
                }
                Object var5_9 = null;
                if (this.m_connection != null) {
                    this.m_connection.decrementActiveThreadCount();
                }
                if (state != null) {
                    state.reset();
                }
            }
            catch (IOException e) {
                LoggingUtils.logWarningStackTrace(m_logger, e);
                Object var5_10 = null;
                if (this.m_connection != null) {
                    this.m_connection.decrementActiveThreadCount();
                }
                if (state != null) {
                    state.reset();
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            if (this.m_connection != null) {
                this.m_connection.decrementActiveThreadCount();
            }
            if (state != null) {
                state.reset();
            }
            throw throwable;
        }
    }
}

