/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.reflect.InvocationHandler;
import com.evermind.reflect.UndeclaredExceptionTypeException;
import com.evermind.server.rmi.EvermindRemote;
import com.evermind.server.rmi.ObjectInfo;
import com.evermind.server.rmi.RMIClient;
import com.evermind.server.rmi.RMIClientConnection;
import com.evermind.server.rmi.RMIClientContext;
import com.evermind.server.rmi.RMIConnection;
import com.evermind.server.rmi.RMIConnectionException;
import com.evermind.server.rmi.RMIContext;
import com.evermind.server.rmi.RMIInterfaceType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import oracle.oc4j.rmi.ClientRmiTransport;
import oracle.oc4j.rmi.OracleRemoteException;

public class RemoteInvocationHandler
implements InvocationHandler {
    public static final Class COM_EVERMIND_SERVER_RMI_EVERMINDREMOTE = EvermindRemote.class;
    private ClientRmiTransport m_transport;
    private int currentConnectionID;
    protected RMIClientContext context;
    protected transient RMIClientConnection connection;
    private static final Method JAVA_LANG_OBJECT_HASHCODE = RemoteInvocationHandler.getMethod(Object.class, "hashCode", new Class[0]);
    private static Logger m_logger = Logger.getLogger(RemoteInvocationHandler.class.getName());
    private long m_id;
    private long m_checksum;
    private RMIInterfaceType m_interfaceType;
    private Object m_object;
    private RMIConnectionException m_previousException;

    private static Method getMethod(Class type, String name, Class[] args) {
        try {
            return type.getMethod(name, args);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public RemoteInvocationHandler(RMIClientConnection connection, RMIContext context) {
        this.connection = connection;
        this.m_transport = connection.getRmiTransport().cloneTransport();
        this.context = (RMIClientContext)context;
        this.currentConnectionID = connection.currentConnectionID;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == COM_EVERMIND_SERVER_RMI_EVERMINDREMOTE) {
            return this;
        }
        try {
            if (this.connection == null) {
                this.connection = RMIClient.getInstance().getConnection(this.m_transport, null, null, this.context);
                if (this.connection == null) {
                    throw new OracleRemoteException("Connection lost");
                }
            }
            if (this.connection.currentConnectionID != this.currentConnectionID) {
                throw new RMIConnectionException(this.getObjectNotAvailableReason(), 1);
            }
            Object object = this.connection.invokeMethod(this.context, this.m_id, this.m_checksum, method, args);
            return object;
        }
        catch (RMIConnectionException e) {
            if (this.m_previousException != null) {
                e.setPreviousException(this.m_previousException);
            }
            throw e;
        }
        finally {
            this.m_previousException = null;
        }
    }

    private String getObjectNotAvailableReason() {
        if (this.connection.getTransport().isConnected()) {
            return "Object reference no longer valid (disconnected)";
        }
        return this.connection.getTransport().getDisconnectMessage();
    }

    protected void finalize() {
        m_logger.finest("<<< FINALIZED >>>");
        if (this.connection != null && this.currentConnectionID == this.connection.currentConnectionID) {
            this.connection.releaseObject(this.m_id);
            this.connection = null;
        }
    }

    public boolean isActive() {
        return this.currentConnectionID == this.connection.currentConnectionID;
    }

    public RMIConnection getConnection() {
        return this.connection;
    }

    public int hashCode() {
        try {
            return ((Number)this.invoke(this, JAVA_LANG_OBJECT_HASHCODE, null)).intValue();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new UndeclaredExceptionTypeException(t.getClass().getName(), t);
        }
    }

    void setHandlerInfo(ObjectInfo info, RMIInterfaceType interfaceType) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        this.m_id = info.id;
        this.m_checksum = info.checksum;
        this.m_interfaceType = interfaceType;
        this.m_object = this.m_interfaceType.getProxyConstructor().newInstance(this);
    }

    long getId() {
        return this.m_id;
    }

    Object getObject() {
        return this.m_object;
    }

    void setPreviousException(RMIConnectionException e) {
        this.m_previousException = e;
    }
}

