/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.reflect.Proxy;
import com.evermind.server.rmi.EvermindRemote;
import com.evermind.server.rmi.RMIClientConnection;
import com.evermind.server.rmi.RMIConnectionException;
import com.evermind.server.rmi.RMIContext;
import com.evermind.server.rmi.RMIRecoveryFailureException;
import com.evermind.server.rmi.RemoteInvocationHandler;
import com.evermind.util.RMIProperties;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.rmi.OracleRemoteException;

public abstract class RecoverableRemoteInvocationHandler
extends RemoteInvocationHandler {
    private static Logger m_logger = TraceLogger.getLogger(RecoverableRemoteInvocationHandler.class);
    private static int rmiClientRecoverTimeout = RMIProperties.getRmiClientRecoveryTimeout();

    public RecoverableRemoteInvocationHandler(RMIClientConnection connection, RMIContext context) {
        super(connection, context);
    }

    public Object invoke(Object object, Method method, Object[] args) throws Throwable {
        try {
            return super.invoke(object, method, args);
        }
        catch (RMIConnectionException e) {
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Failure to invoke a method: " + method, e);
            }
            return this.handleRecovery(e, object, method, args);
        }
    }

    protected Object handleRecovery(RMIConnectionException e, Object object, Method method, Object[] args) throws Throwable {
        if (this.context.getRecoveryRetryCount() >= e.getStage()) {
            this.context.establishRemoteConnections();
            long timeLimit = System.currentTimeMillis() + (long)rmiClientRecoverTimeout;
            EvermindRemote freshObject = this.getReplacementObject(timeLimit, e);
            Proxy proxy = (Proxy)object;
            RemoteInvocationHandler handler = freshObject.getInvocationHandler();
            proxy.setInvocationHandler(handler);
            this.connection = null;
            handler.setPreviousException(e);
            return handler.invoke(proxy, method, args);
        }
        return this.handlePostInitialRecovery(e, object, method, args);
    }

    EvermindRemote getReplacementObject(long timeLimit, RMIConnectionException e) throws Throwable {
        EvermindRemote freshObject = null;
        do {
            try {
                if (m_logger.isLoggable(Level.FINE)) {
                    m_logger.log(Level.FINE, "Start to seek new object from {0}", this.connection.getRmiTransport().getLocation());
                }
                freshObject = this.getFreshObject();
            }
            catch (IOException ie) {
                Thread.sleep(3000L);
            }
            catch (NamingException namingException) {
                throw new OracleRemoteException("Unable to failover", namingException);
            }
        } while (freshObject == null && System.currentTimeMillis() < timeLimit);
        if (freshObject == null) {
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Failed to seek new object from {0}", this.connection.getRmiTransport().getLocation());
            }
            throw e;
        }
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Succeed to seek new object from {0}", this.connection.getRmiTransport().getLocation());
        }
        return freshObject;
    }

    protected Object handlePostInitialRecovery(RMIConnectionException e, Object object, Method method, Object[] args) throws Throwable {
        RMIConnectionException previousException;
        int maxRetryCount = this.context.getRecoveryRetryCount();
        for (int i = 0; i < maxRetryCount && (previousException = e.getPreviousException()) != null; ++i) {
            e = previousException;
        }
        throw new RMIRecoveryFailureException("RMI connection recovery failure", e);
    }

    protected abstract EvermindRemote getFreshObject() throws Throwable;
}

