/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.io.ClassLoaderObjectInputStream;
import com.evermind.io.IOUtils;
import com.evermind.reflect.Proxy;
import com.evermind.server.administration.RemoteData;
import com.evermind.server.cluster.ServerIdentification;
import com.evermind.server.rmi.ObjectInfo;
import com.evermind.server.rmi.RMICall;
import com.evermind.server.rmi.RMIClassLoader;
import com.evermind.server.rmi.RMIClient;
import com.evermind.server.rmi.RMIClientContext;
import com.evermind.server.rmi.RMIConnection;
import com.evermind.server.rmi.RMIConnectionException;
import com.evermind.server.rmi.RMIContext;
import com.evermind.server.rmi.RMIInterceptorException;
import com.evermind.server.rmi.RMIInterfaceType;
import com.evermind.server.rmi.RMILoginFailedException;
import com.evermind.server.rmi.RemoteInvocationHandler;
import com.evermind.server.rmi.RmiCallQueue;
import com.evermind.util.LongHashMap;
import com.evermind.util.RMIProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.UnmarshalException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import oracle.j2ee.rmi.RMIMessages;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.rmi.ClientRmiMethodCache;
import oracle.oc4j.rmi.ClientRmiTransport;
import oracle.oc4j.rmi.ClientRmiTypeCache;
import oracle.oc4j.rmi.OracleRemoteException;
import oracle.oc4j.rmi.RmiCommandSource;
import oracle.oc4j.rmi.RmiServerResetException;
import oracle.oc4j.rmi.RmiTransport;
import oracle.oc4j.security.OC4JSSLSocketFactory;
import oracle.oc4j.security.OC4JSecurity;

public class RMIClientConnection
extends RMIConnection {
    private static Logger m_logger = TraceLogger.getLogger(RMIClientConnection.class);
    static int GLOBAL_TIMEOUT = RMIProperties.getRmiClientConnectionTimeout();
    private static int MAX_WAIT_TIME_FOR_THREAD_TERMINATION = 60;
    public static final Object RMI_NULL_BINDING = new Object();
    private String username;
    private String password;
    private WeakHashMap m_associatedContexts = new WeakHashMap();
    RMIClientContext m_context;
    int currentConnectionID;
    private ClientRmiMethodCache m_methodCache = new ClientRmiMethodCache();
    private ArrayList releaseQueue = new ArrayList();
    private ClientRmiTypeCache m_typeCache = new ClientRmiTypeCache();
    private RmiCallQueue m_callQueue = new RmiCallQueue();
    private int currentCommandID;
    private boolean inCallIdTransaction;
    private int lockedRemoteObjects;
    private ClientRmiTransport m_transport;
    private WeakHashMap m_rmiClassLoaders = new WeakHashMap();
    private RMIClientConnection m_classLoaderConnection;
    private boolean m_managedConnection = true;
    private LongHashMap m_clientInterceptors = new LongHashMap();

    RMIClientConnection(RMIClient server, ClientRmiTransport transport, String username, String password, RMIClientContext initialContext) {
        this(server, transport, username, password, initialContext, true);
    }

    RMIClientConnection(RMIClient server, ClientRmiTransport transport, String username, String password, RMIClientContext initialContext, boolean managedConnection) {
        super(server);
        this.m_transport = transport;
        this.username = username;
        this.password = password;
        this.m_context = server.createContext(initialContext.getName(), initialContext.environment);
        this.m_managedConnection = managedConnection;
        this.addAssociatedContext(initialContext);
        this.m_transport.setTimeout(1000 * RMIClientConnection.getTimeoutSettingInSeconds(initialContext));
    }

    private RMIClientConnection(RMIClientConnection other) {
        super(other);
        this.m_transport = other.m_transport.cloneTransport();
        this.username = other.username;
        this.password = other.password;
        this.m_context = other.m_context;
        this.m_managedConnection = false;
    }

    ClientRmiTransport getRmiTransport() {
        return this.m_transport;
    }

    private static int getTimeoutSettingInSeconds(RMIContext context) {
        try {
            return Integer.parseInt((String)context.getEnvironment().get("rmi.client.connection.timeout"));
        }
        catch (NumberFormatException e) {
            return Math.max(0, GLOBAL_TIMEOUT);
        }
        catch (NamingException e) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetState(String disconnectMessage) {
        super.resetState(disconnectMessage);
        this.m_methodCache.reset();
        this.lockedRemoteObjects = 0;
        this.currentCommandID = 0;
        this.m_typeCache.clear();
        if (this.m_classLoaderConnection != null) {
            this.m_classLoaderConnection.disconnect(disconnectMessage, false);
        }
        this.m_classLoaderConnection = null;
        Object object = Proxy.class;
        synchronized (object) {
            Set keySet = this.m_rmiClassLoaders.keySet();
            Iterator iterator = keySet.iterator();
            while (iterator.hasNext()) {
                ClassLoader loader = (ClassLoader)iterator.next();
                if (loader == null) continue;
                Proxy.cleanupProxyClasses(loader);
            }
        }
        object = this.m_associatedContexts;
        synchronized (object) {
            Iterator iterator = this.m_associatedContexts.keySet().iterator();
            while (iterator.hasNext()) {
                RMIContext ctx = (RMIContext)iterator.next();
                if (ctx == null) continue;
                ctx.unbindAll(this);
            }
        }
        this.m_rmiClassLoaders.clear();
        ++this.currentConnectionID;
        this.notifyQueuedThreads(disconnectMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addAssociatedContext(RMIClientContext clientContext) {
        WeakHashMap weakHashMap = this.m_associatedContexts;
        synchronized (weakHashMap) {
            if (!this.m_managedConnection) {
                return false;
            }
            this.m_associatedContexts.put(clientContext, "");
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAssociatedContext(RMIClientContext clientContext) {
        boolean removeConnection = false;
        WeakHashMap weakHashMap = this.m_associatedContexts;
        synchronized (weakHashMap) {
            this.m_associatedContexts.remove(clientContext);
            if (this.m_associatedContexts.isEmpty() && !this.getTransport().isConnected() && this.m_managedConnection) {
                removeConnection = true;
                this.m_managedConnection = false;
            }
        }
        if (removeConnection) {
            this.getServer().removeConnection(this);
        }
        clientContext.unbindAll(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveDisconnect(String message) {
        super.receiveDisconnect(message);
        boolean removeConnection = false;
        WeakHashMap weakHashMap = this.m_associatedContexts;
        synchronized (weakHashMap) {
            if (this.m_associatedContexts.isEmpty() && this.m_managedConnection) {
                removeConnection = true;
                this.m_managedConnection = false;
            }
        }
        if (removeConnection) {
            this.getServer().removeConnection(this);
        }
    }

    boolean isManagedConnection() {
        return this.m_managedConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAssociatedContext(RMIClientContext context) {
        WeakHashMap weakHashMap = this.m_associatedContexts;
        synchronized (weakHashMap) {
            return this.m_associatedContexts.containsKey(context);
        }
    }

    private void notifyQueuedThreads(String message) {
        this.m_callQueue.notifyQueuedThreads(message);
        this.currentCommandID = 0;
    }

    Object lookup(RMIContext context, String name) throws IOException, NamingException {
        RMICall call;
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "User {0} is looking up {1} in {2}", new Object[]{this.username, name, context});
        }
        try {
            call = this.sendLookupRequest(context, name);
        }
        catch (RmiServerResetException e) {
            this.disconnect("forced by server reset", false);
            call = this.sendLookupRequest(context, name);
        }
        this.waitForJndiResponse(call);
        if (call.response == null && !this.getRmiTransport().isConnected()) {
            throw new OracleRemoteException("Disconnected: " + this.getRmiTransport().getDisconnectMessage());
        }
        return call.response;
    }

    private synchronized RMICall sendLookupRequest(RMIContext context, String name) throws IOException, NamingException {
        this.connect();
        this.assertContextHandled(context);
        RMICall call = null;
        try {
            RmiTransport.MessageOut messageOut = this.getProtocol().createRequest(this.m_transport, this);
            ObjectOutputStream out = messageOut.getOutputStream();
            call = this.writeRequest(out, 3);
            out.writeUTF(name);
            out.writeBoolean(context.getOpmnFlag());
            messageOut.send();
        }
        catch (RmiServerResetException e) {
            this.rollbackCommandIDTransaction();
            throw e;
        }
        catch (IOException e) {
            this.rollbackCommandIDTransaction();
            this.fireReceiveException(call, e);
            throw e;
        }
        catch (RuntimeException e) {
            this.rollbackCommandIDTransaction();
            this.fireReceiveException(call, e);
            throw e;
        }
        catch (RMIInterceptorException e) {
            this.rollbackCommandIDTransaction();
            this.fireReceiveException(call, e);
            NamingException ne = new NamingException();
            ne.initCause(e);
            throw ne;
        }
        finally {
            this.commitCommandIDTransaction();
        }
        return call;
    }

    public void processReceivedCommand(int command, ClassLoaderObjectInputStream in) throws IOException {
        if (this.isCommand(command)) {
            this.handleOrmiCommand(command, in);
        } else {
            this.dispatchResponse(command, in);
        }
    }

    private void dispatchResponse(int command, ClassLoaderObjectInputStream in) throws IOException {
        RMICall call = this.getProtocol().readQueuedCall(command, this.m_callQueue, in);
        try {
            call.systemExceptionOccurred = this.getProtocol().getInterceptorManager().fireReadReplyInterceptor(this.m_clientInterceptors, in, call.id);
            this.handleOrmiCommandResponse(in, command, call);
        }
        catch (IOException e) {
            call.recordClientException(e);
            throw e;
        }
        catch (Throwable e) {
            call.recordClientException(e);
            IOException ioe = new IOException(e.toString());
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            this.notifyCall(call);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCall(RMICall call) {
        RMICall rMICall = call;
        synchronized (rMICall) {
            call.responded = true;
            call.notify();
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "The responding object is gotten and the waiting thread is notified. : call object : " + call);
            }
        }
    }

    private RMICall getQueuedCall(int id) throws IOException {
        return this.m_callQueue.getQueuedClass(id);
    }

    private void handleOrmiCommandResponse(ClassLoaderObjectInputStream in, int command, RMICall call) throws IOException {
        int status = this.readStatus(command, in);
        switch (command) {
            case 15: 
            case 18: {
                this.handleJndiVoidResponse(status, call, in);
                break;
            }
            case 39: {
                this.handleListContextResponse(status, call, in);
                break;
            }
            case 9: {
                this.handleLookupResponse(status, call, in);
                break;
            }
            case 10: {
                this.handleMethodInvocationResponse(status, in, call);
                break;
            }
            case 41: {
                this.handleGetClassDataResponse(status, in, call);
                break;
            }
            case 52: {
                this.handleReleaseObjectResponse(status, in, call);
                break;
            }
            case 53: {
                this.handleFailoverResponse(status, call, in);
                break;
            }
            default: {
                throw new IOException("Unknown command: " + command);
            }
        }
    }

    protected void initializeConnectionThread() {
    }

    protected boolean mayStartConnectionThread() {
        return true;
    }

    protected String getConnectionThreadName(Thread thread) {
        return "RMIClientConnectionThread-" + thread.getName();
    }

    protected void receiveDomainSetting(String domain) {
    }

    Map list(RMIContext context, String name, boolean isIncludeBindings) throws NamingException, IOException {
        this.assertContextHandled(context);
        this.connect();
        RMICall call = this.sendListRequest(name, isIncludeBindings);
        this.waitForJndiResponse(call);
        return (Map)call.response;
    }

    private synchronized RMICall sendListRequest(String name, boolean isIncludeBindings) throws IOException, NamingException {
        RMICall call = null;
        try {
            RmiTransport.MessageOut messageOut = this.getProtocol().createRequest(this.m_transport, this);
            ObjectOutputStream out = messageOut.getOutputStream();
            call = this.writeRequest(out, 30);
            out.writeUTF(name);
            out.writeBoolean(isIncludeBindings);
            messageOut.send();
        }
        catch (IOException e) {
            this.rollbackCommandIDTransaction();
            this.fireReceiveException(call, e);
            throw e;
        }
        catch (RuntimeException e) {
            this.rollbackCommandIDTransaction();
            this.fireReceiveException(call, e);
            throw e;
        }
        catch (RMIInterceptorException e) {
            this.rollbackCommandIDTransaction();
            this.fireReceiveException(call, e);
            NamingException ne = new NamingException();
            ne.initCause(e);
            throw ne;
        }
        finally {
            this.commitCommandIDTransaction();
        }
        return call;
    }

    private void assertContextHandled(RMIContext context) {
        if (!this.handlesContext(context)) {
            throw new IllegalArgumentException("Domain '" + context.getName() + "' is not handled by this connection");
        }
    }

    private void waitForJndiResponse(RMICall call) throws IOException, NamingException {
        try {
            this.waitForResponseFromServer(call);
            call.throwRecordedException();
        }
        catch (RMIInterceptorException e) {
            throw new OracleRemoteException("Error processing client interceptors", e.getCause());
        }
    }

    void bind(RMIContext context, String name, Object value) throws IOException, NamingException {
        this.assertContextHandled(context);
        this.connect();
        RMICall call = this.sendBindRequest(name, value);
        this.waitForJndiResponse(call);
    }

    private synchronized RMICall sendBindRequest(String name, Object value) throws IOException, NamingException {
        RMICall call = null;
        try {
            RmiTransport.MessageOut messageOut = this.getProtocol().createRequest(this.m_transport, this);
            ObjectOutputStream out = messageOut.getOutputStream();
            call = this.writeRequest(out, 14);
            out.writeUTF(name);
            out.writeObject(value);
            messageOut.send();
        }
        catch (NotSerializableException e) {
            this.rollbackCommandIDTransaction();
            this.fireReceiveException(call, e);
            throw e;
        }
        catch (IOException e) {
            this.rollbackCommandIDTransaction();
            this.fireReceiveException(call, e);
            this.disconnect("RMIConnection.bind IO Error: " + e.getMessage(), true);
            throw new OracleRemoteException("IO Error: " + e.getMessage(), e);
        }
        catch (RuntimeException e) {
            this.rollbackCommandIDTransaction();
            this.fireReceiveException(call, e);
            throw e;
        }
        catch (RMIInterceptorException e) {
            this.rollbackCommandIDTransaction();
            this.fireReceiveException(call, e);
            NamingException ne = new NamingException();
            ne.initCause(e);
            throw ne;
        }
        finally {
            this.commitCommandIDTransaction();
        }
        return call;
    }

    void unbind(RMIContext context, String name) throws IOException, NamingException {
        this.assertContextHandled(context);
        this.connect();
        RMICall call = this.sendUnbindRequest(name);
        this.waitForJndiResponse(call);
    }

    private synchronized RMICall sendUnbindRequest(String name) throws IOException, NamingException {
        RMICall call = null;
        try {
            RmiTransport.MessageOut messageOut = this.getProtocol().createRequest(this.m_transport, this);
            ObjectOutputStream out = messageOut.getOutputStream();
            call = this.writeRequest(out, 17);
            out.writeUTF(name);
            messageOut.send();
        }
        catch (NotSerializableException e) {
            this.rollbackCommandIDTransaction();
            this.fireReceiveException(call, e);
            throw e;
        }
        catch (IOException e) {
            this.rollbackCommandIDTransaction();
            this.fireReceiveException(call, e);
            this.disconnect("RMIConnection.unbind IO Error: " + e.getMessage(), true);
            throw new OracleRemoteException("IO Error: " + e.getMessage(), e);
        }
        catch (RuntimeException e) {
            this.rollbackCommandIDTransaction();
            this.fireReceiveException(call, e);
            throw e;
        }
        catch (RMIInterceptorException e) {
            this.rollbackCommandIDTransaction();
            this.fireReceiveException(call, e);
            NamingException ne = new NamingException();
            ne.initCause(e);
            throw ne;
        }
        finally {
            this.commitCommandIDTransaction();
        }
        return call;
    }

    Object invokeMethod(RMIContext context, long id, long checksum, Method method, Object[] args) throws Throwable {
        this.assertContextHandled(context);
        if (!this.getRmiTransport().isConnected()) {
            throw new RMIConnectionException("Disconnected: " + this.getRmiTransport().getDisconnectMessage(), 1);
        }
        RMICall call = this.sendMethodInvocationRequest(method, id, checksum, args);
        return this.obtainRemoteMethodResponse(call, method);
    }

    private synchronized RMICall sendMethodInvocationRequest(Method method, long id, long checksum, Object[] args) throws Throwable {
        RMICall call = null;
        try {
            RmiTransport.MessageOut messageOut = this.getProtocol().createRequest(this.m_transport, this);
            ObjectOutputStream out = messageOut.getOutputStream();
            call = this.writeRequest(out, 4);
            call.type = method.getReturnType();
            call.objectId = new Long(id);
            out.writeLong(id);
            out.writeLong(checksum);
            this.m_methodCache.writeMethod(method, out);
            this.writeArguments(out, method, args);
            messageOut.send();
        }
        catch (NotSerializableException e) {
            this.rollbackCommandIDTransaction();
            RMIMessages.finerThrowable(e);
            this.fireReceiveException(call, e);
            throw new OracleRemoteException("Error marshalling objects, Not Serializable: " + e, e);
        }
        catch (RmiServerResetException e) {
            this.rollbackCommandIDTransaction();
            this.disconnect(e.getMessage(), false);
            this.fireReceiveException(call, e);
            throw e;
        }
        catch (IOException e) {
            this.rollbackCommandIDTransaction();
            RMIMessages.finerThrowable(e);
            this.fireReceiveException(call, e);
            throw new RMIConnectionException(e.getMessage(), e, 1);
        }
        catch (RMIInterceptorException e) {
            this.rollbackCommandIDTransaction();
            RMIMessages.finerThrowable(e);
            this.fireReceiveException(call, e.getCause());
            throw new OracleRemoteException("Error sending method invocation request", e.getCause());
        }
        catch (Throwable t) {
            this.rollbackCommandIDTransaction();
            RMIMessages.finerThrowable(t);
            this.fireReceiveException(call, t);
            throw t;
        }
        finally {
            this.commitCommandIDTransaction();
        }
        return call;
    }

    private void fireReceiveException(RMICall call, Throwable exception) throws IOException {
        if (call != null) {
            call.recordClientException(exception);
            this.getProtocol().getInterceptorManager().fireReceiveExceptionInterceptor(this.m_clientInterceptors, call.id, call.getException());
        }
    }

    private Object obtainRemoteMethodResponse(RMICall call, Method method) throws Throwable {
        try {
            this.waitForResponseFromServer(call);
            call.throwRecordedException(method);
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Returning value " + call.response + " for method " + method.getName());
            }
            return call.response;
        }
        catch (RMIInterceptorException e) {
            throw new OracleRemoteException("Error processing client interceptors", e.getCause());
        }
    }

    private void writeArguments(ObjectOutputStream out, Method method, Object[] args) throws IOException {
        if (args == null) {
            IOUtils.writeCompressedInt(out, 0);
        } else {
            IOUtils.writeCompressedInt(out, args.length);
            Class<?>[] types = method.getParameterTypes();
            for (int i = 0; i < args.length; ++i) {
                this.getProtocol().writeValue(types[i], out, args[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseObject(long id) {
        ArrayList arrayList = this.releaseQueue;
        synchronized (arrayList) {
            this.releaseQueue.add(new Long(id));
            if (this.releaseQueue.size() > 10) {
                this.sendQueuedReleaseRequests();
            }
        }
    }

    synchronized RMICall sendQueuedReleaseRequests() {
        if (!this.getRmiTransport().isConnected() || this.releaseQueue.size() == 0) {
            return null;
        }
        RMICall rmiCall = null;
        try {
            Long[] releaseIDs = this.releaseQueue.toArray(new Long[this.releaseQueue.size()]);
            for (int i = 0; i < releaseIDs.length; ++i) {
                try {
                    RmiTransport.MessageOut clientMessageOut = this.getProtocol().createRequest(this.m_transport, this);
                    ObjectOutputStream out = clientMessageOut.getOutputStream();
                    rmiCall = this.writeRequest(out, 8);
                    out.writeLong(releaseIDs[i]);
                    clientMessageOut.send();
                    continue;
                }
                catch (IOException e) {
                    this.rollbackCommandIDTransaction();
                    throw e;
                }
                finally {
                    this.commitCommandIDTransaction();
                }
            }
            this.lockedRemoteObjects -= this.releaseQueue.size();
            this.releaseQueue.clear();
            return rmiCall;
        }
        catch (IOException e) {
            this.disconnect("Error while releasing objects: " + e.getMessage(), true);
            return null;
        }
        catch (RMIInterceptorException e) {
            RMIMessages.finerThrowable(e);
            return null;
        }
    }

    boolean hasCredentials(String username, String password) {
        return (username != null ? username.equals(this.username) : this.username == null || this.username.equals("")) && (password != null ? password.equals(this.password) : this.password == null || this.password.equals(""));
    }

    public String toString() {
        return "RMIClientConnection [username=" + this.username + " location = " + this.getRmiTransport().getLocation() + ", domain = " + this.m_context.getName() + "]";
    }

    RemoteData getServerClass(RMIClientContext domain, String name, long lastModified) throws IOException, NamingException {
        this.assertContextHandled(domain);
        this.connect();
        try {
            RMICall call = this.sendClassDataRequest(name, lastModified);
            this.waitForResponseFromServer(call);
            return (RemoteData)call.response;
        }
        catch (RMIInterceptorException e) {
            NamingException ne = new NamingException();
            ne.initCause(e);
            throw ne;
        }
    }

    private synchronized RMICall sendClassDataRequest(String name, long lastModified) throws IOException, RMIInterceptorException {
        RMICall call;
        try {
            RmiTransport.MessageOut messageOut = this.getProtocol().createRequest(this.m_transport, this);
            ObjectOutputStream out = messageOut.getOutputStream();
            call = this.writeRequest(out, 40);
            out.writeUTF(name);
            out.writeLong(lastModified);
            messageOut.send();
        }
        catch (IOException e) {
            this.rollbackCommandIDTransaction();
            this.disconnect("RMIConnection.getServerClass IO error: " + e, true);
            throw e;
        }
        finally {
            this.commitCommandIDTransaction();
        }
        return call;
    }

    private RMICall writeRequest(ObjectOutputStream out, int command) throws IOException, RMIInterceptorException {
        this.writeCommandByte(out, command);
        RMICall callInfo = this.getProtocol().isCallIdRequired(command) ? this.createQueuedCall() : new RMICall(false, -1, -1);
        this.getProtocol().getInterceptorManager().fireSendRequestInterceptor(this.m_clientInterceptors, out, command, callInfo.id);
        return callInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RMICall createQueuedCall() {
        this.beginCommandIDTransaction();
        RmiCallQueue rmiCallQueue = this.m_callQueue;
        synchronized (rmiCallQueue) {
            return this.m_callQueue.createCall(this.currentCommandID);
        }
    }

    synchronized boolean connect() throws IOException, AuthenticationException {
        boolean newConnection;
        boolean bl = newConnection = !this.m_transport.isConnected();
        if (newConnection) {
            m_logger.log(Level.FINE, "The transport object is not connected.");
            try {
                int count = 0;
                while (this.isAlive()) {
                    m_logger.log(Level.FINE, "waiting for RMI listener thread termination. count : " + count);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (++count < MAX_WAIT_TIME_FOR_THREAD_TERMINATION) continue;
                    throw new IOException("RMI listener thread is not terminated.");
                }
                m_logger.log(Level.FINE, "connecting to the server.");
                this.m_transport.connectToServer(this, this.getProtocol(), this.username, this.password, this.m_context.domain);
            }
            catch (AuthenticationException e) {
                this.disconnect("Login failed " + e.getMessage(), true);
                throw e;
            }
            catch (RMILoginFailedException e) {
                this.disconnect("", true);
                throw new IOException(e.getMessage());
            }
            catch (IOException e) {
                this.disconnect("Exception caught during connectToServer(); " + e, true);
                throw e;
            }
            m_logger.log(Level.FINE, "launching new connection thread.");
            this.getServer().getConnectionThreadPool().launch(this);
        }
        return newConnection;
    }

    private static void closeSocket(Socket socket) throws IOException {
        if (null != socket) {
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "closing socket {0}", socket.toString());
            }
            socket.close();
        }
    }

    public static Socket createSocket(InetAddress address, int port, boolean isPortSsl) throws IOException {
        Socket socket;
        OC4JSecurity.assertIsSafe();
        if (isPortSsl) {
            socket = RMIClientConnection.createSecureSocket(address, port);
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "createSocket created secure socket {0}", socket.toString());
            }
        } else {
            socket = new Socket(address, port);
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "createSocket created socket {0}", socket.toString());
            }
        }
        if (socket != null) {
            socket.setTcpNoDelay(true);
        }
        return socket;
    }

    private static Socket createSecureSocket(InetAddress address, int port) throws IOException {
        OC4JSSLSocketFactory factory = OC4JSSLSocketFactory.getDefault("rmi");
        try {
            Socket clientSocket = factory.createSocket(address, port);
            clientSocket.setTcpNoDelay(true);
            return clientSocket;
        }
        catch (Exception e) {
            m_logger.throwing(RMIConnection.class.toString(), "createSecureSocket", e);
            throw new IOException(e.getMessage());
        }
    }

    static ServerIdentification[] getServers(String host, int port, boolean isPortSsl, String application) throws IOException {
        OC4JSecurity.assertIsSafe();
        ServerIdentification[] identifications = null;
        Socket socket = null;
        try {
            socket = RMIClientConnection.createSocket(InetAddress.getByName(host), port, isPortSsl);
            OutputStream out = socket.getOutputStream();
            out.write(228);
            IOUtils.writeUTF(out, "");
            IOUtils.writeUTF(out, application == null ? "" : application);
            out.flush();
            InputStream in = socket.getInputStream();
            in.skip(5L);
            IOUtils.readShort(in);
            IOUtils.readShort(in);
            int count = IOUtils.readCompressedInt(in);
            identifications = new ServerIdentification[count];
            for (int i = 0; i < count; ++i) {
                identifications[i] = ServerIdentification.read(in);
            }
        }
        catch (Exception e) {
            try {
                m_logger.throwing(RMIConnection.class.toString(), "getServers", e);
                throw new IOException(e.getMessage());
            }
            catch (Throwable throwable) {
                RMIClientConnection.closeSocket(socket);
                throw throwable;
            }
        }
        RMIClientConnection.closeSocket(socket);
        return identifications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForResponseFromServer(RMICall call) throws IOException, RMIInterceptorException {
        try {
            RMICall rMICall = call;
            synchronized (rMICall) {
                if (!call.responded) {
                    if (m_logger.isLoggable(Level.FINEST)) {
                        m_logger.log(Level.FINEST, "going to wait notifications from a server. : call object : " + call);
                    }
                    call.wait();
                }
            }
            this.makeInterceptorReplyNotifications(call);
        }
        catch (InterruptedException e) {
            this.disconnect("Interrupted: " + e.getMessage(), true);
            throw new IOException("Disconnected: " + this.getRmiTransport().getDisconnectMessage());
        }
    }

    private void makeInterceptorReplyNotifications(RMICall call) throws IOException, RMIInterceptorException {
        if (call.systemExceptionOccurred) {
            this.getProtocol().getInterceptorManager().fireReceiveExceptionInterceptor(this.m_clientInterceptors, call.id, call.getException());
        } else {
            this.getProtocol().getInterceptorManager().fireReceiveReplyInterceptor(this.m_clientInterceptors, call.id);
        }
    }

    private void handleJndiVoidResponse(int status, RMICall call, ObjectInputStream in) throws IOException {
        if (status == 7) {
            call.recordServerException(new OracleRemoteException(in.readUTF()));
        } else if (status == 23 || status == 35) {
            call.recordServerException(new NoPermissionException(in.readUTF()));
        }
    }

    private void handleListContextResponse(int response, RMICall call, ObjectInputStream in) throws IOException {
        if (response != 34) {
            call.recordServerException(new NamingException(in.readUTF()));
        } else {
            try {
                call.response = in.readObject();
            }
            catch (ClassNotFoundException e) {
                call.recordClientException(e);
            }
            catch (NotSerializableException e) {
                call.recordClientException(new OracleRemoteException("Not serializable: " + e.getMessage()));
            }
        }
    }

    private void handleLookupResponse(int status, RMICall call, ClassLoaderObjectInputStream in) throws IOException {
        if (status == 7) {
            call.recordServerException(new OracleRemoteException(in.readUTF()));
        } else if (status == 23 || status == 35) {
            call.recordServerException(new NoPermissionException(in.readUTF()));
        } else if (status == 1) {
            call.response = null;
        } else if (status == 2) {
            try {
                in.setClassLoader(this.getRMIClassLoader(call.getClassLoader()));
                call.response = in.readObject();
                if (call.response == null) {
                    call.response = RMI_NULL_BINDING;
                }
            }
            catch (ClassNotFoundException e) {
                call.recordClientException(new OracleRemoteException("ClassNotFoundException: " + e.getMessage()));
            }
            catch (IOException e) {
                call.recordClientException(e);
                throw e;
            }
        }
    }

    private void handleMethodInvocationResponse(int status, ClassLoaderObjectInputStream in, RMICall call) throws IOException {
        if (status == 5) {
            try {
                in.setClassLoader(this.getRMIClassLoader(call.getClassLoader()));
                call.response = this.getProtocol().readValue(call.type, in);
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.log(Level.FINEST, "after getting response: call object : " + call);
                }
            }
            catch (InvalidClassException e) {
                call.recordClientException(new UnmarshalException("Error deserializing return-value: " + e));
            }
            catch (NotSerializableException e) {
                call.recordClientException(new UnmarshalException("Error deserializing return-value: " + e));
            }
            catch (ObjectStreamException e1) {
                call.recordClientException(new UnmarshalException("Error deserializing return-value: " + e1.getMessage(), e1));
            }
            catch (ClassNotFoundException e) {
                call.recordClientException(new UnmarshalException("Error deserializing return-value: " + e.getMessage(), e));
            }
        } else if (status == 7) {
            try {
                in.setClassLoader(this.getRMIClassLoader(call.getClassLoader()));
                Throwable throwable = (Throwable)in.readObject();
                call.recordApplicationException(throwable);
                if (throwable instanceof OracleRemoteException) {
                    this.getRmiTransport().annotateException((OracleRemoteException)throwable);
                }
            }
            catch (ClassNotFoundException cnfe) {
                call.recordClientException(new OracleRemoteException("Class not found: " + cnfe.getMessage(), cnfe));
            }
            catch (NotSerializableException e) {
                call.recordClientException(new OracleRemoteException("Error marshalling objects: " + e, e));
            }
            catch (ObjectStreamException e1) {
                call.recordClientException(new UnmarshalException("Error deserializing exception-value: " + e1.getMessage(), e1));
            }
            catch (IOException ee) {
                call.recordClientException(new OracleRemoteException("Error reading exception: " + ee, ee));
            }
        } else {
            call.recordClientException(new OracleRemoteException("Method invocation failed (Invalid return command: " + status + ")"));
        }
    }

    private void handleGetClassDataResponse(int status, ClassLoaderObjectInputStream in, RMICall call) throws IOException {
        boolean found;
        boolean bl = found = status != 0;
        if (found) {
            byte[] data;
            long lastModified = in.readLong();
            int length = IOUtils.readCompressedInt(in);
            if (length >= 0) {
                data = new byte[length];
                in.readFully(data);
            } else {
                data = null;
            }
            call.response = new RemoteData(data, lastModified);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleReleaseObjectResponse(int status, ClassLoaderObjectInputStream in, RMICall call) throws IOException {
        try {
            try {
                this.getProtocol().readObjectResponseId(status, in);
            }
            catch (IOException e) {
                call.recordClientException(e);
                throw e;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                this.makeInterceptorReplyNotifications(call);
                throw throwable;
            }
            catch (RMIInterceptorException e) {
                throw new OracleRemoteException("Exception during client interceptor processing", e.getCause());
            }
        }
        try {}
        catch (RMIInterceptorException e) {
            throw new OracleRemoteException("Exception during client interceptor processing", e.getCause());
        }
        this.makeInterceptorReplyNotifications(call);
    }

    protected boolean isDisconnectOnInterrupt() {
        return this.lockedRemoteObjects == 0 && this.m_callQueue.isEmpty();
    }

    protected RmiTransport getTransport() {
        return this.m_transport;
    }

    private void handleFailoverResponse(int status, RMICall call, ClassLoaderObjectInputStream in) throws IOException {
        if (status == 7) {
            call.recordServerException(new IOException(in.readUTF()));
        }
        if (call.getException() != null) {
            m_logger.log(Level.FINE, "Handling failover: {0}", call.getException().getMessage());
        }
        call.recordClientException(new RMIConnectionException("Failing over.", 1));
        this.failoverPendingCalls();
    }

    private void failoverPendingCalls() {
        this.m_callQueue.abortPendingCalls();
        this.currentCommandID = 0;
    }

    boolean isMatchingConnection(ClientRmiTransport transport, String username, String password, RMIContext context) {
        return transport.equals(this.getRmiTransport()) && this.hasCredentials(username, password) && this.handlesContext(context);
    }

    boolean handlesContext(RMIContext context) {
        return this.m_context != null && this.m_context.isMatchingContext(context);
    }

    Object getBoundObject(ObjectInfo info, ClassLoader classLoader) throws IOException {
        if (info.type < 0) {
            info.type = this.m_typeCache.addReceivedType(info.interfaceNames);
        }
        RMIInterfaceType interfaceType = this.m_typeCache.getCachedType(info.type, classLoader);
        try {
            RemoteInvocationHandler handler = info.createRemoteInvocationHandler(this, this.m_context);
            handler.setHandlerInfo(info, interfaceType);
            ++this.lockedRemoteObjects;
            return handler.getObject();
        }
        catch (Throwable t) {
            throw new OracleRemoteException("Unable to instantiate proxy object: " + t.getMessage(), t);
        }
    }

    RMIClassLoader getRMIClassLoader(ClassLoader parent) {
        WeakReference reference = (WeakReference)this.m_rmiClassLoaders.get(parent);
        if (reference == null || reference.get() == null) {
            if (this.m_classLoaderConnection == null) {
                this.m_classLoaderConnection = new RMIClientConnection(this);
            }
            RMIClassLoader loader = this.createRMIClassLoader(parent, this.m_classLoaderConnection, this.m_context);
            this.m_rmiClassLoaders.put(parent, new WeakReference<RMIClassLoader>(loader));
            return loader;
        }
        return (RMIClassLoader)reference.get();
    }

    private RMIClassLoader createRMIClassLoader(final ClassLoader parent, final RMIClientConnection connection, final RMIClientContext context) {
        if (System.getSecurityManager() == null) {
            return new RMIClassLoader(parent, connection, context);
        }
        return (RMIClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new RMIClassLoader(parent, connection, context);
            }
        });
    }

    protected RmiCommandSource.MessageIn receiveInputMessage() throws IOException {
        return this.getTransport().createContinuousMessageIn(this);
    }

    private void beginCommandIDTransaction() {
        this.inCallIdTransaction = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackCommandIDTransaction() throws IOException {
        if (this.inCallIdTransaction) {
            RmiCallQueue rmiCallQueue = this.m_callQueue;
            synchronized (rmiCallQueue) {
                block6: {
                    try {
                        this.m_callQueue.getQueuedClass(this.currentCommandID);
                    }
                    catch (IOException e) {
                        if (!m_logger.isLoggable(Level.WARNING)) break block6;
                        m_logger.log(Level.WARNING, "failed to rollback callQueue: {0}", e.getMessage());
                    }
                }
            }
        }
        this.inCallIdTransaction = false;
    }

    private void commitCommandIDTransaction() {
        if (this.inCallIdTransaction) {
            this.inCallIdTransaction = false;
            ++this.currentCommandID;
        }
    }
}

