/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.MessageSelector;
import com.evermind.server.multicastjms.ServerQueue;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;

public class QueueBrowserEnumerationServerStub {
    protected MessageSelector selector;
    protected List messages;
    protected int index;

    public QueueBrowserEnumerationServerStub(ServerQueue queue, MessageSelector selector) {
        this.messages = queue.getMessages();
        this.selector = selector;
        this.sortOutUnselectedMessages();
    }

    protected void sortOutUnselectedMessages() {
        if (this.selector == null) {
            return;
        }
        Iterator iterator = this.messages.iterator();
        while (iterator.hasNext()) {
            EvermindMessage message = (EvermindMessage)iterator.next();
            if (this.selector.isSelected(message)) continue;
            iterator.remove();
        }
    }

    public void writeInitialResponse(OutputStream out, DataOutputStream dataOut) throws IOException {
        dataOut.writeInt(this.messages.size());
        this.writeMessageBurst(out, dataOut);
    }

    public void writeMessageBurst(OutputStream out, DataOutputStream dataOut) throws IOException {
        int amountToWrite = 10;
        if (this.index + 10 > this.messages.size()) {
            amountToWrite = this.messages.size() - this.index;
        }
        dataOut.writeInt(amountToWrite);
        for (int i = 0; i < amountToWrite; ++i) {
            EvermindMessage message = (EvermindMessage)this.messages.get(this.index++);
            out.write(message.getTypeID());
            message.write(out, dataOut);
        }
    }

    public boolean isDone() {
        return this.index == this.messages.size();
    }
}

