/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.compiler.CompilationException;
import com.evermind.parser.BooleanExpression;
import com.evermind.parser.Expression;
import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.JMSExpressionParser;
import java.util.HashMap;
import java.util.Map;
import javax.jms.InvalidSelectorException;

public class MessageSelector {
    private static final JMSExpressionParser parser = new JMSExpressionParser();
    private static final Map cachedSelectors = new HashMap();
    protected BooleanExpression expression;
    protected String condition;

    public MessageSelector(String condition) throws CompilationException {
        Expression expression = parser.parse(condition);
        if (!(expression instanceof BooleanExpression)) {
            throw new CompilationException('\'' + condition + "' is not a boolean expression");
        }
        this.expression = (BooleanExpression)expression;
        this.condition = condition;
    }

    public boolean isSelected(EvermindMessage message) {
        return this.expression.evaluate(message) == 1;
    }

    public String getCondition() {
        return this.condition;
    }

    public static MessageSelector getSelector(String condition) throws InvalidSelectorException {
        Map map = cachedSelectors;
        synchronized (map) {
            try {
                MessageSelector selector = (MessageSelector)cachedSelectors.get(condition);
                if (selector == null) {
                    selector = new MessageSelector(condition);
                    cachedSelectors.put(condition, selector);
                }
                return selector;
            }
            catch (CompilationException e) {
                e.printStackTrace();
                throw new InvalidSelectorException(e.getMessage());
            }
        }
    }
}

