/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.naming.ContextUtils;
import com.evermind.net.NetworkConnection;
import com.evermind.net.SocketNetworkConnection;
import com.evermind.security.User;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerUser;
import com.evermind.server.Server;
import com.evermind.server.multicastjms.CMTQueueConnectionFactory;
import com.evermind.server.multicastjms.CMTTopicConnectionFactory;
import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.EvermindQueue;
import com.evermind.server.multicastjms.EvermindTopic;
import com.evermind.server.multicastjms.EvermindTopicConnection;
import com.evermind.server.multicastjms.EvermindXAQueueConnectionFactory;
import com.evermind.server.multicastjms.EvermindXATopicConnectionFactory;
import com.evermind.server.multicastjms.JMSRequestHandler;
import com.evermind.server.multicastjms.JMSServerConfig;
import com.evermind.server.multicastjms.JMSTask;
import com.evermind.server.multicastjms.LocalTopicConnection;
import com.evermind.server.multicastjms.MessageSelector;
import com.evermind.server.multicastjms.ServerQueue;
import com.evermind.server.multicastjms.deployment.QueueConnectionFactoryConfig;
import com.evermind.server.multicastjms.deployment.TopicConnectionFactoryConfig;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import javax.naming.Context;
import javax.naming.NamingException;

public class JMSServer
extends Server
implements Runnable {
    public static final int DEFAULT_PORT = 9127;
    private JMSServerConfig config;
    private JMSTask task;
    private ApplicationServer server;
    private ServerSocket serverSocket;
    private boolean alive = true;
    private Map queues = new HashMap();
    private List boundLocations = new ArrayList();
    private XAQueueConnectionFactory defaultQueueConnectionFactory;
    private XATopicConnectionFactory defaultTopicConnectionFactory;
    private List topicDelegators;
    private List queueDelegators;
    private JMSRequestHandler[] topicClients = new JMSRequestHandler[0];
    private int topicClientCount;
    private List localTopicConnections;
    private int currentID = 1;
    protected Map contextMappings = new HashMap();
    protected JMSRequestHandler[] clients;
    protected int clientsCount;
    protected Object clientsLock = new Object();

    public JMSServer(ApplicationServer server) {
        this.server = server;
    }

    public synchronized void setConfig(JMSServerConfig config) throws InstantiationException {
        Object cmtFactory;
        Serializable factory;
        String location;
        Map.Entry entry;
        this.defaultQueueConnectionFactory = null;
        this.defaultTopicConnectionFactory = null;
        this.contextMappings.clear();
        super.setConfig(config);
        this.config = config;
        int port = config.getPort();
        InetAddress address = config.getAddress();
        boolean newSocket = false;
        if (this.serverSocket != null) {
            if (this.serverSocket.getLocalPort() != port || !address.equals(this.serverSocket.getInetAddress())) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                newSocket = true;
            }
        } else {
            newSocket = true;
        }
        if (newSocket) {
            try {
                this.serverSocket = new ServerSocket(port, 30, address);
            }
            catch (IOException e) {
                throw new InstantiationException("Unable to bind socket: " + e.getMessage());
            }
            this.server.getConnectionThreadPool().launch(this);
        }
        Iterator iterator = config.getQueueMappings().entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            location = (String)entry.getKey();
            EvermindQueue queue = (EvermindQueue)entry.getValue();
            if (location == null) {
                throw new InstantiationException("queue tag with missing location attribute");
            }
            ServerQueue serverQueue = this.createQueue(queue);
            if (queue.getPersistenceFile() != null) {
                try {
                    FileInputStream fileIn = new FileInputStream(queue.getPersistenceFile());
                    serverQueue.loadState(fileIn);
                    fileIn.close();
                }
                catch (FileNotFoundException e) {
                }
                catch (IOException e) {
                    System.err.println("Error loading queue state: " + e.getMessage());
                }
            }
            this.contextMappings.put(location, queue);
            this.boundLocations.add(location);
        }
        iterator = config.getTopicMappings().entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            location = (String)entry.getKey();
            EvermindTopic topic = (EvermindTopic)entry.getValue();
            if (location == null) {
                throw new InstantiationException("topic tag with missing location attribute");
            }
            this.contextMappings.put(location, topic);
            this.boundLocations.add(location);
        }
        iterator = config.getQueueConnectionFactories().iterator();
        while (iterator.hasNext()) {
            QueueConnectionFactoryConfig queueConfig = (QueueConnectionFactoryConfig)((Object)iterator.next());
            try {
                factory = new EvermindXAQueueConnectionFactory(queueConfig, this);
                if (this.defaultQueueConnectionFactory == null) {
                    this.defaultQueueConnectionFactory = factory;
                }
                if (queueConfig.getLocation() == null) {
                    throw new InstantiationException((queueConfig.isTransactional() ? "xa-" : "") + "queue-connection-factory tag with missing location attribute");
                }
                this.contextMappings.put(queueConfig.getLocation(), factory);
                if (queueConfig.getCMTLocation() == null) continue;
                cmtFactory = new CMTQueueConnectionFactory((XAQueueConnectionFactory)factory);
                this.contextMappings.put(queueConfig.getCMTLocation(), cmtFactory);
            }
            catch (UnknownHostException e) {
                throw new InstantiationException("Unknown host: " + e.getMessage());
            }
        }
        iterator = config.getTopicConnectionFactories().iterator();
        while (iterator.hasNext()) {
            TopicConnectionFactoryConfig topicConfig = (TopicConnectionFactoryConfig)((Object)iterator.next());
            try {
                factory = new EvermindXATopicConnectionFactory(topicConfig, this);
                if (this.defaultTopicConnectionFactory == null) {
                    this.defaultTopicConnectionFactory = factory;
                }
                if (topicConfig.getLocation() == null) {
                    throw new InstantiationException((topicConfig.isTransactional() ? "xa-" : "") + "topic-connection-factory tag with missing location attribute");
                }
                this.contextMappings.put(topicConfig.getLocation(), factory);
                if (topicConfig.getCMTLocation() == null) continue;
                cmtFactory = new CMTTopicConnectionFactory((XATopicConnectionFactory)factory);
                this.contextMappings.put(topicConfig.getCMTLocation(), cmtFactory);
            }
            catch (UnknownHostException e) {
                throw new InstantiationException("Unknown host: " + e.getMessage());
            }
        }
        if (this.defaultQueueConnectionFactory == null || this.defaultTopicConnectionFactory == null) {
            User admin = this.server.getAdminUser();
            String username = admin == null ? "anonymous" : admin.getName();
            String password = "";
            if (admin instanceof ApplicationServerUser) {
                password = ((ApplicationServerUser)admin).getPassword();
            }
            InetAddress factoryAddress = address;
            try {
                if (address.getHostAddress().equals("0.0.0.0")) {
                    factoryAddress = InetAddress.getByName("127.0.0.1");
                }
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            if (this.defaultQueueConnectionFactory == null) {
                this.defaultQueueConnectionFactory = new EvermindXAQueueConnectionFactory(factoryAddress, port, username, password);
                ((EvermindXAQueueConnectionFactory)this.defaultQueueConnectionFactory).setServer(this);
                this.contextMappings.put("jms/QueueConnectionFactory", this.defaultQueueConnectionFactory);
                this.contextMappings.put("jms/XAQueueConnectionFactory", this.defaultQueueConnectionFactory);
            }
            if (this.defaultTopicConnectionFactory == null) {
                this.defaultTopicConnectionFactory = new EvermindXATopicConnectionFactory(factoryAddress, port, 1, username, password);
                ((EvermindXATopicConnectionFactory)this.defaultTopicConnectionFactory).setServer(this);
                this.contextMappings.put("jms/TopicConnectionFactory", this.defaultTopicConnectionFactory);
                this.contextMappings.put("jms/XATopicConnectionFactory", this.defaultTopicConnectionFactory);
            }
        }
    }

    public void stop() {
        this.server.getTaskManager().removeTask(this.task);
    }

    public void run() {
        Thread.currentThread().setName("JMSServer");
        if (this.serverSocket == null) {
            return;
        }
        if (this.task == null) {
            this.task = new JMSTask(this, 10);
            this.server.getTaskManager().addTask(this.task, this.config.getTaskManagerInterval());
        }
        while (this.alive) {
            try {
                Socket socket = this.serverSocket.accept();
                this.connect(new SocketNetworkConnection(socket), true);
            }
            catch (IOException e) {
                if (!this.alive) break;
                Thread.yield();
            }
        }
    }

    public void addMessage(String queueName, EvermindMessage message) throws InvalidDestinationException {
        ServerQueue queue = this.getQueue(queueName);
        if (queue == null) {
            throw new InvalidDestinationException("The queue didnt exist");
        }
        if (message.getJMSDestination() == null) {
            if (queue.getQueue() != null) {
                message.setJMSDestination((Destination)queue.getQueue());
            } else {
                message.setJMSDestination((Destination)new EvermindQueue(queueName));
            }
        }
        queue.add(message);
    }

    public synchronized ServerQueue createQueue(String name) {
        return this.createQueue(new EvermindQueue(name));
    }

    public synchronized ServerQueue createQueue(EvermindQueue queue) {
        ServerQueue serverQueue = new ServerQueue(this, queue);
        if (!this.queues.containsKey(queue.getQueueName())) {
            this.queues.put(queue.getQueueName(), serverQueue);
        }
        return serverQueue;
    }

    public void getMessage(String queueName, MessageSelector selector, JMSRequestHandler handler, long timeout, int id, byte acknowledgeMode) throws InvalidDestinationException, JMSException, IOException {
        ServerQueue queue = this.getQueue(queueName);
        if (queue == null) {
            throw new InvalidDestinationException("The queue didnt exist");
        }
        if (timeout != 0L) {
            if (timeout < 0L) {
                queue.receiveNoWait(handler, id, selector, acknowledgeMode);
            } else {
                queue.receive(handler, id, selector, timeout, acknowledgeMode);
            }
        } else {
            queue.receive(handler, id, selector, acknowledgeMode);
        }
    }

    public synchronized ServerQueue getQueue(String name) {
        return (ServerQueue)this.queues.get(name);
    }

    public synchronized List getQueues() {
        return new ArrayList(this.queues.values());
    }

    public synchronized void deleteExpiredMessages() {
        Iterator iterator = this.queues.values().iterator();
        while (iterator.hasNext()) {
            ServerQueue queue = (ServerQueue)iterator.next();
            queue.deleteExpiredMessages();
        }
    }

    public synchronized void destroy(String reason) {
        if (!this.alive) {
            return;
        }
        this.alive = false;
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
                this.serverSocket = null;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        Iterator iterator = this.queues.values().iterator();
        while (iterator.hasNext()) {
            ServerQueue queue = (ServerQueue)iterator.next();
            if (queue.getQueue().getPersistenceFile() == null) continue;
            try {
                FileOutputStream out = new FileOutputStream(queue.getQueue().getPersistenceFile());
                queue.saveState(out);
                out.close();
            }
            catch (IOException e) {
                System.err.println("Error persisting queue state: " + e.getMessage());
            }
        }
        super.destroy(reason);
    }

    public ApplicationServer getApplicationServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListeners(JMSRequestHandler handler) {
        Map map = this.queues;
        synchronized (map) {
            Iterator iterator = this.queues.values().iterator();
            while (iterator.hasNext()) {
                ServerQueue queue = (ServerQueue)iterator.next();
                queue.removeListeners(handler);
            }
        }
    }

    public synchronized void handleTopicMessage(Object source, String topicName, EvermindMessage message) {
        EvermindTopicConnection connection;
        int i;
        if (this.localTopicConnections != null) {
            for (i = 0; i < this.localTopicConnections.size(); ++i) {
                connection = (LocalTopicConnection)this.localTopicConnections.get(i);
                connection.notifySessions(topicName, message);
            }
        }
        if (this.topicDelegators != null) {
            for (i = 0; i < this.topicDelegators.size(); ++i) {
                connection = (EvermindTopicConnection)this.topicDelegators.get(i);
                try {
                    connection.distribute(topicName, message);
                    continue;
                }
                catch (JMSException e) {
                    this.log("Error delegating incoming topic message", e);
                    continue;
                }
                catch (IOException e) {
                    this.log("Error delegating incoming topic message", e);
                }
            }
        }
        if (this.topicClients != null) {
            JMSRequestHandler[] clients = this.topicClients;
            for (int i2 = 0; i2 < clients.length; ++i2) {
                JMSRequestHandler handler = clients[i2];
                if (handler == null) continue;
                try {
                    if (handler == source) continue;
                    handler.sendTopicMessage(topicName, message);
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized void registerTopicInterest(JMSRequestHandler handler) {
        for (int i = 0; i < this.topicClients.length; ++i) {
            if (this.topicClients[i] != handler) continue;
            return;
        }
        if (this.topicClients.length > 0 && this.topicClients[this.topicClients.length - 1] == null) {
            for (int pos = this.topicClients.length - 1; pos > 0 && this.topicClients[pos - 1] == null; --pos) {
            }
            this.topicClients[pos] = handler;
            ++this.topicClientCount;
        } else {
            JMSRequestHandler[] newHandlers = new JMSRequestHandler[this.topicClients.length + 10];
            System.arraycopy(this.topicClients, 0, newHandlers, 0, this.topicClients.length);
            newHandlers[this.topicClients.length] = handler;
            this.topicClients = newHandlers;
            ++this.topicClientCount;
        }
    }

    public synchronized void removeTopicInterest(JMSRequestHandler handler) {
        for (int i = 0; i < this.topicClients.length; ++i) {
            if (this.topicClients[i] != handler) continue;
            this.topicClients[i] = null;
            --this.topicClientCount;
        }
    }

    public synchronized int getNextID() {
        return this.currentID++;
    }

    public void bind(Context context) throws InstantiationException {
        try {
            ContextUtils.bind(context, this.contextMappings, true);
        }
        catch (NamingException e) {
            throw new InstantiationException("Error binding JMS object: " + e.getMessage());
        }
    }

    public Set getQueueNames() {
        return this.queues.keySet();
    }

    public void connect(NetworkConnection connection, boolean async) throws IOException {
        if (async) {
            this.server.getThreadPool().launch(new JMSRequestHandler(this, connection));
        } else {
            new JMSRequestHandler(this, connection).run();
        }
    }

    public String getDefaultQueueLocation() {
        if (this.contextMappings != null) {
            Iterator iterator = this.contextMappings.values().iterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (!(next instanceof EvermindQueue)) continue;
                return ((EvermindQueue)next).getLocation();
            }
        }
        return null;
    }

    public String getDefaultTopicLocation() {
        if (this.contextMappings != null) {
            Iterator iterator = this.contextMappings.values().iterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (!(next instanceof EvermindTopic)) continue;
                return ((EvermindTopic)next).getLocation();
            }
        }
        return null;
    }

    protected String getVersion() {
        return ApplicationServer.VERSION;
    }

    public JMSServerConfig getConfig() {
        return this.config;
    }

    public synchronized List getDefinedQueueNames() {
        return new ArrayList(this.queues.keySet());
    }

    public synchronized void registerLocalTopicConnection(LocalTopicConnection connection) {
        if (this.localTopicConnections == null) {
            this.localTopicConnections = new ArrayList();
        }
        if (!this.localTopicConnections.contains(connection)) {
            this.localTopicConnections.add(connection);
        }
    }

    public synchronized void removeLocalTopicConnection(LocalTopicConnection connection) {
        if (this.localTopicConnections != null) {
            this.localTopicConnections.remove(connection);
        }
    }

    public String getDefaultQueueConnectionFactoryLocation(boolean transactional) {
        List factories = this.config.getQueueConnectionFactories();
        for (int i = 0; i < factories.size(); ++i) {
            QueueConnectionFactoryConfig config = (QueueConnectionFactoryConfig)factories.get(i);
            if (config.isTransactional() != transactional) continue;
            return config.getLocation();
        }
        return transactional ? "jms/XAQueueConnectionFactory" : "jms/QueueConnectionFactory";
    }

    public String getDefaultTopicConnectionFactoryLocation(boolean transactional) {
        List factories = this.config.getTopicConnectionFactories();
        for (int i = 0; i < factories.size(); ++i) {
            TopicConnectionFactoryConfig config = (TopicConnectionFactoryConfig)factories.get(i);
            if (config.isTransactional() != transactional) continue;
            return config.getLocation();
        }
        return transactional ? "jms/XATopicConnectionFactory" : "jms/TopicConnectionFactory";
    }

    public int getNumberOfClients() {
        return this.topicClientCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClient(JMSRequestHandler handler) {
        Object object = this.clientsLock;
        synchronized (object) {
            handler.queueID = this.clientsCount;
            if (this.clients == null) {
                this.clients = new JMSRequestHandler[4];
            } else if (this.clientsCount >= this.clients.length) {
                JMSRequestHandler[] newClients = new JMSRequestHandler[this.clients.length * 2];
                System.arraycopy(this.clients, 0, newClients, 0, this.clients.length);
                this.clients = newClients;
            }
            this.clients[this.clientsCount++] = handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClient(JMSRequestHandler handler) {
        Object object = this.clientsLock;
        synchronized (object) {
            if (handler.queueID >= 0 && this.clients[handler.queueID] == handler) {
                if (handler.queueID == this.clientsCount - 1) {
                    this.clients[--this.clientsCount] = null;
                } else {
                    this.clients[handler.queueID] = this.clients[--this.clientsCount];
                    this.clients[this.clientsCount] = null;
                    this.clients[handler.queueID].queueID = handler.queueID;
                }
                handler.queueID = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getClients() {
        ArrayList<JMSRequestHandler> response = new ArrayList<JMSRequestHandler>();
        Object object = this.clientsLock;
        synchronized (object) {
            for (int i = 0; i < this.clientsCount; ++i) {
                response.add(this.clients[i]);
            }
        }
        return response;
    }

    public ServerSocket getSocket() {
        return this.serverSocket;
    }

    public Set getImplementations(Class type) {
        HashSet response = new HashSet();
        if (this.contextMappings != null) {
            Iterator iterator = this.contextMappings.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!type.isAssignableFrom(entry.getValue().getClass())) continue;
                response.add(entry.getKey());
            }
        }
        return response;
    }
}

