/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.security.User;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ContextContainer;
import com.evermind.server.ServerApplicationClientLauncherImpl;
import com.evermind.server.ThreadState;
import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.EvermindMessageConsumer;
import com.evermind.server.multicastjms.EvermindTopic;
import com.evermind.server.multicastjms.EvermindTopicSession;
import com.evermind.server.multicastjms.LocalTopicConnection;
import com.evermind.server.multicastjms.MessageSelector;
import com.evermind.server.multicastjms.SynchronousMessageListener;
import java.util.ArrayList;
import java.util.List;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class EvermindTopicSubscriber
extends EvermindMessageConsumer
implements TopicSubscriber {
    protected EvermindTopicSession session;
    protected EvermindTopic topic;
    protected boolean noLocal;
    protected MessageSelector selector;
    protected List messageQueue = new ArrayList();
    protected Object messageListenerContext;
    protected Object messageListenerUser;

    protected EvermindTopicSubscriber(EvermindTopicSession session, EvermindTopic topic, String selectorString) throws JMSException {
        super(selectorString);
        this.session = session;
        this.topic = topic;
        session.registerTopicInterest(topic.getTopicName());
    }

    public EvermindTopicSubscriber(EvermindTopicSession session, EvermindTopic topic) throws JMSException {
        this(session, topic, null);
    }

    public EvermindTopicSubscriber(EvermindTopicSession session, EvermindTopic topic, String selector, boolean noLocal) throws InvalidSelectorException, JMSException {
        this(session, topic);
        if (selector != null) {
            this.selector = MessageSelector.getSelector(selector);
        }
        this.noLocal = noLocal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMessage(EvermindMessage message) {
        if (this.noLocal && message.sender == this.session.connection.clientID) {
            return;
        }
        if (this.selector != null && !this.selector.isSelected(message)) {
            return;
        }
        if (this.messageListener != null) {
            this.handleMessageListener(message);
        } else {
            List list = this.messageQueue;
            synchronized (list) {
                this.messageQueue.add(message);
                this.messageQueue.notifyAll();
            }
        }
    }

    protected void handleMessageListener(final EvermindMessage message) {
        if (ApplicationServer.isServerEnvironment()) {
            if (this.session.connection instanceof LocalTopicConnection && !(this.messageListener instanceof SynchronousMessageListener)) {
                ((LocalTopicConnection)this.session.connection).getServer().getApplicationServer().getThreadPool().launch(new Runnable(){

                    public void run() {
                        EvermindTopicSubscriber.this.handleMessageListenerAction(message, ThreadState.getCurrentState());
                    }
                });
            } else {
                this.handleMessageListenerAction(message, ThreadState.getCurrentState());
            }
        } else {
            this.handleMessageListenerAction(message, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void handleMessageListenerAction(EvermindMessage message, ThreadState state) {
        block13: {
            ContextContainer previousContainer = null;
            Transaction previousTransaction = null;
            User previousUser = null;
            TransactionManager tm = ApplicationServer.getInstance().getTransactionManager();
            boolean suspendFailed = false;
            if (state != null) {
                previousContainer = state.contextContainer;
                try {
                    previousTransaction = tm.suspend();
                }
                catch (SystemException systemException) {
                    suspendFailed = true;
                    this.logExceptionFromHandleMessageListenerAction(systemException, "during suspend before ");
                }
                previousUser = state.user;
                state.contextContainer = (ContextContainer)this.messageListenerContext;
                state.user = (User)this.messageListenerUser;
            }
            if (!suspendFailed) {
                this.messageListener.onMessage((Message)message);
                Object var10_10 = null;
                if (state == null) break block13;
                state.contextContainer = previousContainer;
                try {
                    tm.resume(previousTransaction);
                }
                catch (Exception exception) {
                    this.logExceptionFromHandleMessageListenerAction(exception, "during resume after ");
                }
                state.user = previousUser;
                {
                    break block13;
                    catch (Throwable t) {
                        this.logExceptionFromHandleMessageListenerAction(t, "in ");
                        Object var10_11 = null;
                        if (state == null) break block13;
                        state.contextContainer = previousContainer;
                        try {
                            tm.resume(previousTransaction);
                        }
                        catch (Exception exception) {
                            this.logExceptionFromHandleMessageListenerAction(exception, "during resume after ");
                        }
                        state.user = previousUser;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    if (state != null) {
                        state.contextContainer = previousContainer;
                        try {
                            tm.resume(previousTransaction);
                        }
                        catch (Exception exception) {
                            this.logExceptionFromHandleMessageListenerAction(exception, "during resume after ");
                        }
                        state.user = previousUser;
                    }
                    throw throwable;
                }
            }
        }
    }

    private void logExceptionFromHandleMessageListenerAction(Throwable t, String whereOccurred) {
        try {
            if (this.messageListenerContext != null && ((ContextContainer)this.messageListenerContext).getApplication() != null) {
                ((ContextContainer)this.messageListenerContext).getApplication().log("Error " + whereOccurred + (this.messageListener == null ? "" : this.messageListener.getClass().getName()) + ".onMessage(...)", t);
            } else {
                t.printStackTrace();
            }
        }
        catch (NamingException e) {
            t.printStackTrace();
        }
    }

    public void setMessageListener(MessageListener listener) {
        super.setMessageListener(listener);
        if (ApplicationServer.isServerEnvironment()) {
            ServerApplicationClientLauncherImpl appClientLauncherImpl;
            ThreadState state = ThreadState.getCurrentState();
            if (state != null) {
                this.messageListenerContext = state.contextContainer;
                this.messageListenerUser = state.getUser();
            } else {
                this.messageListenerContext = null;
                this.messageListenerUser = null;
            }
            if (this.messageListenerContext == null && (appClientLauncherImpl = ServerApplicationClientLauncherImpl.getCurrentClient()) != null) {
                this.messageListenerContext = appClientLauncherImpl;
            }
        }
        this.messageListener = listener;
    }

    public boolean getNoLocal() {
        return this.noLocal;
    }

    public Topic getTopic() {
        return this.topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(long timeOut) throws JMSException {
        timeOut += System.currentTimeMillis();
        List list = this.messageQueue;
        synchronized (list) {
            while (this.messageQueue.size() == 0) {
                if (this.session.isClosed()) {
                    throw new JMSException("Session closed");
                }
                try {
                    long time = timeOut - System.currentTimeMillis();
                    if (time > 0L) {
                        this.messageQueue.wait(time);
                    }
                }
                catch (InterruptedException e) {
                    throw new JMSException("Interrupted");
                }
                if (timeOut >= System.currentTimeMillis()) continue;
                return null;
            }
            if (this.session.connection.disconnectedMessage != null) {
                throw new JMSException(this.session.connection.disconnectedMessage);
            }
            if (this.messageQueue.size() < 1) {
                throw new JMSException("Closed");
            }
            return (EvermindMessage)this.messageQueue.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive() throws JMSException {
        List list = this.messageQueue;
        synchronized (list) {
            while (this.messageQueue.size() == 0) {
                if (this.session.isClosed()) {
                    throw new JMSException("Session closed");
                }
                try {
                    this.messageQueue.wait();
                }
                catch (InterruptedException e) {
                    if (this.session.isClosed()) {
                        throw new JMSException("Session closed");
                    }
                    throw new JMSException("Interrupted");
                }
            }
            if (this.session.connection.disconnectedMessage != null) {
                throw new JMSException(this.session.connection.disconnectedMessage);
            }
            if (this.messageQueue.size() < 1) {
                throw new JMSException("Closed");
            }
            return (EvermindMessage)this.messageQueue.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receiveNoWait() throws JMSException {
        List list = this.messageQueue;
        synchronized (list) {
            if (this.messageQueue.size() == 0) {
                return null;
            }
            return (EvermindMessage)this.messageQueue.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        List list = this.messageQueue;
        synchronized (list) {
            this.messageQueue.clear();
            this.messageQueue.notifyAll();
        }
    }
}

