/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.EvermindSession;
import com.evermind.server.multicastjms.EvermindTemporaryTopic;
import com.evermind.server.multicastjms.EvermindTopic;
import com.evermind.server.multicastjms.EvermindTopicConnection;
import com.evermind.server.multicastjms.EvermindTopicPublisher;
import com.evermind.server.multicastjms.EvermindTopicSubscriber;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class EvermindTopicSession
extends EvermindSession
implements TopicSession {
    protected EvermindTopicConnection connection;
    protected List subscribers = new ArrayList();
    protected List temporaryTopics = new ArrayList();
    protected boolean closed;

    public synchronized void rollback() throws JMSException {
        if (this.transactionMessages != null) {
            this.transactionMessages.clear();
        }
    }

    public void run() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() throws JMSException {
        if (this.transactionMessages != null) {
            try {
                this.publish(this.transactionMessages);
            }
            finally {
                this.transactionMessages.clear();
            }
        }
    }

    protected void publish(List messages) throws JMSException {
        for (int i = 0; i < messages.size(); ++i) {
            EvermindMessage message = (EvermindMessage)messages.get(i);
            try {
                this.connection.send(((Topic)message.getJMSDestination()).getTopicName(), message);
                continue;
            }
            catch (IOException e) {
                throw new JMSException("Disconnected");
            }
        }
    }

    synchronized void removeTemporaryTopic(EvermindTemporaryTopic topic) {
        this.temporaryTopics.remove(topic);
    }

    public EvermindTopicSession(EvermindTopicConnection connection, boolean transacted, int acknowledgeMode) {
        super(transacted, acknowledgeMode);
        this.connection = connection;
    }

    public TopicSubscriber createSubscriber(Topic topic, String selector, boolean noLocal) throws InvalidDestinationException, InvalidSelectorException, JMSException {
        try {
            EvermindTopicSubscriber subscriber = new EvermindTopicSubscriber(this, (EvermindTopic)topic, selector, noLocal);
            this.subscribers.add(subscriber);
            return subscriber;
        }
        catch (ClassCastException e) {
            throw new InvalidDestinationException("Invalid topic");
        }
    }

    synchronized void addMessage(String topicName, EvermindMessage message) {
        for (int i = 0; i < this.subscribers.size(); ++i) {
            EvermindTopicSubscriber subscriber = (EvermindTopicSubscriber)this.subscribers.get(i);
            String subscriberName = subscriber.topic.name;
            if (!topicName.startsWith(subscriberName) || subscriberName.length() != topicName.length() && topicName.charAt(subscriberName.length()) != '/') continue;
            if (message.getJMSDestination() == null) {
                if (topicName.equals(subscriber.topic.name)) {
                    message.setJMSDestination((Destination)subscriber.topic);
                } else {
                    message.setJMSDestination((Destination)new EvermindTopic(topicName, topicName));
                }
            }
            subscriber.addMessage(message);
        }
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws InvalidDestinationException, JMSException {
        try {
            EvermindTopicSubscriber subscriber = new EvermindTopicSubscriber(this, (EvermindTopic)topic);
            this.subscribers.add(subscriber);
            return subscriber;
        }
        catch (ClassCastException e) {
            throw new InvalidDestinationException("Invalid topic");
        }
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal) throws InvalidDestinationException, InvalidSelectorException, JMSException {
        try {
            EvermindTopicSubscriber subscriber = new EvermindTopicSubscriber(this, (EvermindTopic)topic, selector, noLocal);
            this.subscribers.add(subscriber);
            return subscriber;
        }
        catch (ClassCastException e) {
            throw new InvalidDestinationException("Invalid topic");
        }
    }

    public TopicPublisher createPublisher(Topic topic) throws InvalidDestinationException {
        try {
            return new EvermindTopicPublisher(this, (EvermindTopic)topic);
        }
        catch (ClassCastException e) {
            throw new InvalidDestinationException("Invalid topic");
        }
    }

    public void unsubscribe(String name) {
    }

    public Topic createTopic(String name) {
        return new EvermindTopic(name, null);
    }

    public TemporaryTopic createTemporaryTopic() {
        EvermindTemporaryTopic topic = new EvermindTemporaryTopic(this);
        this.temporaryTopics.add(topic);
        return topic;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws InvalidDestinationException, JMSException {
        try {
            EvermindTopicSubscriber subscriber = new EvermindTopicSubscriber(this, (EvermindTopic)topic);
            this.subscribers.add(subscriber);
            return subscriber;
        }
        catch (ClassCastException e) {
            throw new InvalidDestinationException("Invalid topic");
        }
    }

    void publish(Topic topic, EvermindMessage message) throws JMSException {
        message.setJMSDestination((Destination)topic);
        if (this.getTransacted()) {
            this.transactionMessages.add(message);
        } else {
            try {
                this.connection.send(topic.getTopicName(), message);
            }
            catch (IOException e) {
                throw new JMSException("Disconnected");
            }
        }
    }

    public synchronized void close() throws JMSException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.close();
        for (int i = 0; i < this.subscribers.size(); ++i) {
            EvermindTopicSubscriber subscriber = (EvermindTopicSubscriber)this.subscribers.get(i);
            subscriber.close();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void registerTopicInterest(String topicName) throws JMSException {
        this.connection.registerTopicInterest(topicName);
    }

    public void addTransactionMessage(EvermindMessage message) {
        this.transactionMessages.add(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() throws JMSException {
        if (this.transactionMessages != null) {
            throw new IllegalStateException("Illlegal to call recover() for sessions in transacted mode");
        }
        EvermindTopicSession evermindTopicSession = this;
        synchronized (evermindTopicSession) {
            for (int i = 0; i < this.unacknowledgedMessagesCount; ++i) {
                this.unacknowledgedMessages[i].setJMSRedelivered(true);
                this.publish((Topic)this.unacknowledgedMessages[i].destination, this.unacknowledgedMessages[i]);
            }
        }
    }
}

