/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.EvermindQueueSession;
import com.evermind.server.multicastjms.MessageSelector;
import com.evermind.server.multicastjms.TemporaryDestination;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.TemporaryQueue;

public class EvermindTemporaryQueue
extends TemporaryDestination
implements TemporaryQueue {
    protected static int currentID;
    protected EvermindQueueSession session;
    protected List messages;

    public EvermindTemporaryQueue(EvermindQueueSession session) {
        super(session.connection.clientID, currentID++);
        this.session = session;
    }

    List getMessages() {
        return this.messages;
    }

    public String getQueueName() {
        return Long.toHexString(this.session.connection.clientID) + ':' + Integer.toString(this.session.id, 16) + ':' + Integer.toString(this.id, 16);
    }

    public void delete() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(EvermindMessage genericMessage, int deliveryMode, int priority, long timeToLive) throws MessageFormatException {
        try {
            EvermindMessage message = genericMessage;
            List list = this.messages;
            synchronized (list) {
                this.messages.add(message);
                this.messages.notifyAll();
            }
        }
        catch (ClassCastException e) {
            throw new MessageFormatException("Invalid message");
        }
    }

    EvermindMessage receive(MessageSelector selector) throws JMSException {
        List list = this.messages;
        synchronized (list) {
            EvermindMessage message;
            int index = 0;
            while (true) {
                if (index >= this.messages.size()) {
                    try {
                        this.messages.wait();
                    }
                    catch (InterruptedException e) {
                        throw new JMSException("Interrupted");
                    }
                }
                message = (EvermindMessage)this.messages.get(index++);
                if (selector == null || selector.isSelected(message)) break;
            }
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EvermindMessage receiveNoWait(MessageSelector selector) {
        List list = this.messages;
        synchronized (list) {
            for (int index = 0; index < this.messages.size(); ++index) {
                EvermindMessage message = (EvermindMessage)this.messages.get(index);
                if (selector != null && !selector.isSelected(message)) continue;
                this.messages.remove(index);
                return message;
            }
        }
        return null;
    }

    EvermindMessage receive(MessageSelector selector, long timeout) throws JMSException {
        timeout += System.currentTimeMillis();
        List list = this.messages;
        synchronized (list) {
            int index = 0;
            while (true) {
                if (index >= this.messages.size()) {
                    try {
                        long waitTime = timeout - System.currentTimeMillis();
                        if (waitTime > 0L) {
                            this.messages.wait(waitTime);
                        }
                    }
                    catch (InterruptedException e) {
                        throw new JMSException("Interrupted");
                    }
                    if (System.currentTimeMillis() < timeout) continue;
                    return null;
                }
                EvermindMessage message = (EvermindMessage)this.messages.get(index);
                if (selector == null || selector.isSelected(message)) {
                    this.messages.remove(index);
                    return message;
                }
                ++index;
            }
        }
    }
}

