/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.EvermindMessageConsumer;
import com.evermind.server.multicastjms.EvermindQueue;
import com.evermind.server.multicastjms.EvermindQueueSession;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueReceiver;

public class EvermindQueueReceiver
extends EvermindMessageConsumer
implements QueueReceiver {
    protected EvermindQueueSession session;
    protected EvermindQueue queue;

    public EvermindQueueReceiver(EvermindQueueSession session, EvermindQueue queue, String selector) {
        super(selector);
        this.session = session;
        this.queue = queue;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public Message receive() throws JMSException {
        EvermindMessage message = this.session.receive(this.queue.getQueueName(), this.selectorString, 0L);
        if (message.getJMSDestination() == null) {
            message.setJMSDestination((Destination)this.queue);
        }
        if (this.messageListener != null) {
            try {
                this.messageListener.onMessage((Message)message);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return message;
    }

    public Message receive(long timeout) throws JMSException {
        EvermindMessage message = this.session.receive(this.queue.getQueueName(), this.selectorString, timeout);
        if (message != null) {
            if (message.getJMSDestination() == null) {
                message.setJMSDestination((Destination)this.queue);
            }
            if (this.messageListener != null) {
                try {
                    this.messageListener.onMessage((Message)message);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        return message;
    }

    public Message receiveNoWait() throws JMSException {
        EvermindMessage message = this.session.receive(this.queue.getQueueName(), this.selectorString, -1L);
        if (message != null) {
            if (message.getJMSDestination() == null) {
                message.setJMSDestination((Destination)this.queue);
            }
            if (this.messageListener != null) {
                try {
                    this.messageListener.onMessage((Message)message);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        return message;
    }
}

