/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.EvermindQueueBrowser;
import com.evermind.util.JMSProperties;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jms.Destination;
import javax.jms.JMSException;

public class EvermindQueueBrowserEnumeration
implements Enumeration {
    protected EvermindQueueBrowser browser;
    protected int id;
    protected List messages = new ArrayList();
    protected int messagesRetreived;
    protected int totalMessages;
    protected int index;
    protected int messageOffset;

    public EvermindQueueBrowserEnumeration(EvermindQueueBrowser browser, int id) {
        this.browser = browser;
        this.id = id;
    }

    protected void initialize(InputStream in, DataInputStream dataIn) throws IOException {
        this.totalMessages = dataIn.readInt();
        if (JMSProperties.getJMSDebug()) {
            System.out.println("Total messages for this enumeration: " + this.totalMessages);
        }
        this.readMessageBurst(in, dataIn);
    }

    void readMessageBurst(InputStream in, DataInputStream dataIn) throws IOException {
        int amountToReceive = dataIn.readInt();
        if (JMSProperties.getJMSDebug()) {
            System.out.println("AmountToReceive: " + amountToReceive);
        }
        this.messages.clear();
        for (int i = 0; i < amountToReceive; ++i) {
            this.messages.add(EvermindMessage.readMessage(in.read(), in, dataIn));
        }
        this.messagesRetreived += amountToReceive;
    }

    public boolean hasMoreElements() {
        return this.index < this.totalMessages;
    }

    public Object nextElement() {
        EvermindMessage message;
        if (JMSProperties.getJMSDebug()) {
            System.out.println("nextElement(), index: " + this.index);
        }
        if (this.index >= this.totalMessages) {
            throw new NoSuchElementException();
        }
        if (this.index >= this.messagesRetreived) {
            this.getMoreMessages();
        }
        if ((message = (EvermindMessage)this.messages.get(this.index++)).getJMSDestination() == null) {
            message.setJMSDestination((Destination)this.browser.getQueue());
        }
        return message;
    }

    protected void getMoreMessages() {
        try {
            this.messageOffset += this.messagesRetreived;
            this.browser.session.connection.getQueueBrowserEnumerationMessages(this);
        }
        catch (JMSException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public int getID() {
        return this.id;
    }
}

