/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.CMTTopicSession;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicPublisher;

public class CMTTopicPublisher
implements TopicPublisher {
    private CMTTopicSession session;
    private TopicPublisher publisher;

    public CMTTopicPublisher(CMTTopicSession session, TopicPublisher publisher) {
        this.session = session;
        this.publisher = publisher;
    }

    public int getDeliverMode() throws JMSException {
        return this.publisher.getDeliveryMode();
    }

    public void publish(Message message) throws JMSException {
        this.session.intercept();
        this.publisher.publish(message);
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.intercept();
        this.publisher.publish(message, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic Topic2, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.intercept();
        this.publisher.publish(Topic2, message, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic Topic2, Message message) throws JMSException {
        this.session.intercept();
        this.publisher.publish(Topic2, message);
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.publisher.setPriority(defaultPriority);
    }

    public long getTimeToLive() throws JMSException {
        return this.publisher.getTimeToLive();
    }

    public void close() throws JMSException {
        this.publisher.close();
    }

    public Topic getTopic() throws JMSException {
        return this.publisher.getTopic();
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.publisher.getDisableMessageID();
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.publisher.setDisableMessageTimestamp(value);
    }

    public int getDeliveryMode() throws JMSException {
        return this.publisher.getDeliveryMode();
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.publisher.getDisableMessageTimestamp();
    }

    public void setDeliveryMode(int mode) throws JMSException {
        this.publisher.setDeliveryMode(mode);
    }

    public int getPriority() throws JMSException {
        return this.publisher.getPriority();
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.publisher.setTimeToLive(timeToLive);
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.publisher.setDisableMessageID(value);
    }

    public Destination getDestination() throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public void send(Message msg) throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public void send(Message msg, int delmode, int priority, long ttl) throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public void send(Destination d, Message msg) throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }

    public void send(Destination d, Message msg, int delmode, int priority, long ttl) throws JMSException {
        throw new JMSException("JMS 1.1 features not supported");
    }
}

