/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.parser.BooleanExpression;
import com.evermind.parser.Expression;
import com.evermind.parser.ExpressionContext;
import com.evermind.parser.NumberExpression;

public class BetweenExpression
implements BooleanExpression {
    private NumberExpression expression;
    private NumberExpression min;
    private NumberExpression max;

    public BetweenExpression(NumberExpression expression, NumberExpression min, NumberExpression max) {
        this.expression = expression;
        this.min = min;
        this.max = max;
    }

    public int evaluate(ExpressionContext context) {
        try {
            double value = this.expression.evaluate(context);
            if (value >= this.min.evaluate(context) && value <= this.max.evaluate(context)) {
                return 1;
            }
            return 0;
        }
        catch (NumberFormatException e) {
            return 2;
        }
    }

    public void write(StringBuffer buffer, ExpressionContext context, Expression enclosing) {
    }
}

