/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.EventRules;
import com.evermind.server.jms.filter.ExactParser;
import com.evermind.server.jms.filter.FieldAccess;
import com.evermind.server.jms.filter.Filter;
import com.evermind.server.jms.filter.GeneralException;
import com.evermind.server.jms.filter.IBooleanExpression;
import com.evermind.server.jms.filter.IExpression;
import com.evermind.server.jms.filter.InexactParser;
import com.evermind.server.jms.filter.MessageFormat;
import com.evermind.server.jms.filter.NoSuchFieldException;
import com.evermind.server.jms.filter.PBinaryExpr;
import com.evermind.server.jms.filter.PConstant;
import com.evermind.server.jms.filter.PFieldName;
import com.evermind.server.jms.filter.PIsNull;
import com.evermind.server.jms.filter.PLike;
import com.evermind.server.jms.filter.PNode;
import com.evermind.server.jms.filter.PToken;
import com.evermind.server.jms.filter.PTokenDoubleConst;
import com.evermind.server.jms.filter.PTokenEOS;
import com.evermind.server.jms.filter.PTokenFloatConst;
import com.evermind.server.jms.filter.PTokenIdent;
import com.evermind.server.jms.filter.PTokenIntConst;
import com.evermind.server.jms.filter.PTokenLongConst;
import com.evermind.server.jms.filter.PTokenStringConst;
import com.evermind.server.jms.filter.PUnaryExpr;
import com.evermind.server.jms.filter.QuerySemanticException;
import com.evermind.server.jms.filter.QuerySyntaxException;
import com.evermind.server.jms.filter.TableEntry;
import com.evermind.server.jms.filter.UnsupportedFieldException;
import java.util.Vector;

public class Query {
    private boolean m_idempotent = true;
    private String m_buffer;
    private MessageFormat m_format;
    private PToken m_nextToken;
    private PToken m_currentToken;
    private boolean m_tokenAvailable;
    private int m_start;
    private int m_length;
    private InexactParser m_fp_parse = new InexactParser();
    private ExactParser m_int_parse = new ExactParser();
    static final int tokenERROR = -1;
    static final int tokenEOS = 0;
    static final int tokenAND = 1;
    static final int tokenOR = 2;
    static final int tokenNOT = 3;
    static final int tokenTRUE = 4;
    static final int tokenFALSE = 5;
    static final int tokenLPAR = 6;
    static final int tokenRPAR = 7;
    static final int tokenLT = 8;
    static final int tokenGT = 9;
    static final int tokenEQ = 10;
    static final int tokenLTEQ = 11;
    static final int tokenGTEQ = 12;
    static final int tokenNEQ = 13;
    static final int tokenLBRACK = 14;
    static final int tokenRBRACK = 15;
    static final int tokenCOMMA = 16;
    static final int tokenPLUS = 17;
    static final int tokenSUB = 18;
    static final int tokenMULT = 19;
    static final int tokenDIV = 20;
    static final int tokenNULL = 21;
    static final int tokenESCAPE = 22;
    static final int tokenID = 50;
    static final int tokenICONST = 51;
    static final int tokenLCONST = 52;
    static final int tokenFCONST = 53;
    static final int tokenDCONST = 54;
    static final int tokenSCONST = 55;
    static final int tokenIS = 97;
    static final int tokenBETWEEN = 98;
    static final int tokenIN = 99;
    static final int tokenLIKE = 100;
    static final int LAST_TOKEN = 100;
    static final String[] tokenToString = new String[101];
    private static final TableEntry[] s_keywords;

    static String tokenToString(int tok_id) {
        if (tok_id >= 0 && tok_id < tokenToString.length) {
            return tokenToString[tok_id];
        }
        return " unknown ";
    }

    private Query(String buffer, MessageFormat format) {
        this.m_buffer = buffer;
        this.m_length = buffer.length();
        this.m_format = format;
    }

    static IBooleanExpression parseQuery(String queryExpr, MessageFormat mf, EventRules er) throws QuerySyntaxException, QuerySemanticException, GeneralException {
        Query q = new Query(queryExpr, mf);
        IBooleanExpression ret = q.parse();
        er.setIdempotent(q.m_idempotent);
        return ret;
    }

    public static Filter parseFilter(String queryExpr, MessageFormat mf, EventRules er) throws QuerySyntaxException, QuerySemanticException, GeneralException {
        return Query.parseQuery(queryExpr, mf, er);
    }

    private IBooleanExpression parse() throws QuerySyntaxException, QuerySemanticException, GeneralException {
        this.m_tokenAvailable = false;
        this.m_start = 0;
        PNode parseTree = this.parseOrExpression();
        if (parseTree == null) {
            throw this.syntaxError(new PTokenEOS(0), "Parse tree is null");
        }
        PToken token = this.peekToken();
        if (token.m_token != 0) {
            throw this.syntaxError(token, "expected end of query expression");
        }
        IExpression booleanTree = this.convertTree(parseTree);
        if (!(booleanTree instanceof IBooleanExpression)) {
            throw Query.semanticError("query must result in a boolean expression");
        }
        return (IBooleanExpression)booleanTree;
    }

    private IExpression convertTree(PNode parseTree) throws QuerySemanticException {
        return parseTree.convert(this);
    }

    private void markIdempotent(String fieldName) {
        if (!this.m_idempotent) {
            return;
        }
        if ("JMSXConsumerTXID".equals(fieldName) || "JMSXDeliveryCount".equals(fieldName) || "JMSXRcvTimestamp".equals(fieldName)) {
            this.m_idempotent = false;
        }
    }

    FieldAccess getFieldAccess(String fieldName) throws NoSuchFieldException, UnsupportedFieldException {
        this.markIdempotent(fieldName);
        return this.m_format.getFieldAccess(fieldName);
    }

    MessageFormat getFormat() {
        return this.m_format;
    }

    private PNode parseOrExpression() throws QuerySyntaxException {
        PNode node = this.parseAndExpression();
        return this.parseOrExpressionPrime(node);
    }

    private PNode parseOrExpressionPrime(PNode leftExpr) throws QuerySyntaxException {
        PToken tok = this.peekToken();
        if (tok.m_token != 2) {
            return leftExpr;
        }
        this.advanceToken();
        PNode expr1 = this.parseAndExpression();
        PBinaryExpr finalExpr = new PBinaryExpr(leftExpr, expr1, tok.m_token);
        return this.parseOrExpressionPrime(finalExpr);
    }

    private PNode parseAndExpression() throws QuerySyntaxException {
        PNode node = this.parseBooleanExpression();
        return this.parseAndExpressionPrime(node);
    }

    private PNode parseAndExpressionPrime(PNode leftExpr) throws QuerySyntaxException {
        PToken tok = this.peekToken();
        if (tok.m_token != 1) {
            return leftExpr;
        }
        this.advanceToken();
        PNode expr1 = this.parseBooleanExpression();
        PBinaryExpr finalExpr = new PBinaryExpr(leftExpr, expr1, tok.m_token);
        return this.parseAndExpressionPrime(finalExpr);
    }

    private PNode parseBooleanExpression() throws QuerySyntaxException {
        PNode expr1 = this.parseFactor();
        return this.parseBooleanExpressionPrime(expr1);
    }

    private PNode parseBooleanExpressionPrime(PNode leftExpr) throws QuerySyntaxException {
        PToken tok = this.peekToken();
        int tokval = tok.m_token;
        switch (tokval) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            default: {
                return leftExpr;
            }
        }
        this.advanceToken();
        PNode rightExpr = this.parseFactor();
        PBinaryExpr finalExpr = new PBinaryExpr(leftExpr, rightExpr, tokval);
        return this.parseBooleanExpressionPrime(finalExpr);
    }

    private PNode parseFactor() throws QuerySyntaxException {
        PToken tok = this.peekToken();
        if (tok.m_token == 3) {
            this.advanceToken();
            PNode notExpr = this.parseFactor();
            return new PUnaryExpr(notExpr, tok.m_token);
        }
        PNode mdExpr = this.parseMultDiv();
        PNode factor = this.parseFactorPrime(mdExpr);
        tok = this.peekToken();
        if (tok.m_token != 3 && tok.m_token != 98) {
            return factor;
        }
        return this.parseBetween(factor, tok);
    }

    private PNode parseFactorPrime(PNode expr) throws QuerySyntaxException {
        PToken tok = this.peekForAddSub();
        switch (tok.m_token) {
            case 17: 
            case 18: {
                this.advanceToken();
                PNode mdNode = this.parseMultDiv();
                PBinaryExpr asExpr = new PBinaryExpr(expr, mdNode, tok.m_token);
                return this.parseFactorPrime(asExpr);
            }
        }
        return expr;
    }

    private PNode parseMultDiv() throws QuerySyntaxException {
        PNode term = this.parseUnary();
        return this.parseMultDivPrime(term);
    }

    private PNode parseMultDivPrime(PNode expr) throws QuerySyntaxException {
        PToken tok = this.peekToken();
        switch (tok.m_token) {
            case 19: 
            case 20: {
                this.advanceToken();
                PNode tNode = this.parseUnary();
                PBinaryExpr mdExpr = new PBinaryExpr(expr, tNode, tok.m_token);
                return this.parseMultDivPrime(mdExpr);
            }
        }
        return expr;
    }

    private PNode parseUnary() throws QuerySyntaxException {
        PToken tok = this.peekToken();
        switch (tok.m_token) {
            case 17: 
            case 18: {
                this.advanceToken();
                PNode uExpr = this.parseTerm();
                return new PUnaryExpr(uExpr, tok.m_token);
            }
        }
        return this.parseTerm();
    }

    private PNode parseTerm() throws QuerySyntaxException {
        PToken tok = this.advanceToken();
        switch (tok.m_token) {
            case 6: {
                PNode term = this.parseOrExpression();
                tok = this.advanceToken();
                if (tok.m_token != 7) {
                    throw this.syntaxError(tok, "expected ')' after parsing " + term.toString());
                }
                return term;
            }
            case 4: 
            case 5: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                return new PConstant(tok);
            }
            case 50: {
                if (!(tok instanceof PTokenIdent)) {
                    throw this.syntaxError(tok, " <id> ");
                }
                PFieldName ident = new PFieldName((PTokenIdent)tok);
                PToken nTok = this.peekToken();
                if (nTok.m_token == 97 || nTok.m_token == 3 || nTok.m_token == 99 || nTok.m_token == 98 || nTok.m_token == 100) {
                    return this.parseSql(ident, nTok);
                }
                return ident;
            }
        }
        throw this.syntaxError(tok, "unexpected token: ");
    }

    private PNode parseSql(PFieldName ident, PToken nTok) throws QuerySyntaxException {
        boolean invert = false;
        switch (nTok.m_token) {
            case 97: {
                this.advanceToken();
                PToken nullTok = this.peekToken();
                if (nullTok.m_token == 3) {
                    invert = true;
                    this.advanceToken();
                    nullTok = this.peekToken();
                }
                if (nullTok.m_token != 21) {
                    throw this.syntaxError(nullTok, " null ");
                }
                this.advanceToken();
                return new PIsNull(ident, invert);
            }
            case 3: {
                this.advanceToken();
                nTok = this.peekToken();
                switch (nTok.m_token) {
                    case 99: {
                        return this.parseSqlIn(nTok, true, ident);
                    }
                    case 100: {
                        return this.parseSqlLike(nTok, true, ident);
                    }
                    case 98: {
                        return this.parseSqlBetween(nTok, true, ident);
                    }
                }
                throw this.syntaxError(nTok, " in | like ");
            }
            case 99: {
                return this.parseSqlIn(nTok, false, ident);
            }
            case 100: {
                return this.parseSqlLike(nTok, false, ident);
            }
            case 98: {
                return this.parseSqlBetween(nTok, false, ident);
            }
        }
        throw this.syntaxError(nTok, " in | like ");
    }

    private PNode parseSqlLike(PToken nTok, boolean invert, PFieldName ident) throws QuerySyntaxException {
        this.advanceToken();
        nTok = this.advanceToken();
        if (nTok.m_token != 55) {
            throw this.syntaxError(nTok, " <string literal> ");
        }
        String patConst = ((PTokenStringConst)nTok).m_c;
        nTok = this.peekToken();
        if (nTok.m_token == 22) {
            this.advanceToken();
            nTok = this.advanceToken();
            if (nTok.m_token != 55) {
                throw this.syntaxError(nTok, " <character literal> ");
            }
            PTokenStringConst scons = (PTokenStringConst)nTok;
            if (scons.m_c.length() != 1) {
                throw this.syntaxError(nTok, " <character literal> not " + scons);
            }
            return new PLike(ident, invert, patConst, scons.m_c.charAt(0));
        }
        return new PLike(ident, invert, patConst);
    }

    private PNode parseSqlIn(PToken nTok, boolean invert, PFieldName ident) throws QuerySyntaxException {
        this.advanceToken();
        nTok = this.advanceToken();
        if (nTok.m_token != 6) {
            throw this.syntaxError(nTok, " ( ");
        }
        nTok = this.peekToken();
        Vector<PConstant> args = new Vector<PConstant>();
        while (nTok.m_token == 55) {
            args.addElement(new PConstant(nTok));
            this.advanceToken();
            nTok = this.advanceToken();
            if (nTok.m_token != 16) continue;
            nTok = this.peekToken();
        }
        if (nTok.m_token != 7) {
            throw this.syntaxError(nTok, " ) ");
        }
        if (args.size() < 1) {
            throw this.syntaxError(nTok, " <string> ");
        }
        PBinaryExpr[] eqExprs = new PBinaryExpr[args.size()];
        int aLen = args.size();
        for (int i = 0; i < aLen; ++i) {
            eqExprs[i] = new PBinaryExpr(ident, (PConstant)args.elementAt(i), invert ? 13 : 10);
        }
        PBinaryExpr resExpr = eqExprs[0];
        for (int i = 1; i < aLen; ++i) {
            resExpr = new PBinaryExpr(resExpr, eqExprs[i], invert ? 1 : 2);
        }
        return resExpr;
    }

    private PNode parseSqlBetween(PToken nTok, boolean invert, PFieldName ident) throws QuerySyntaxException {
        return this.parseBetweenPost(invert, ident);
    }

    private PNode parseBetween(PNode factor, PToken tok) throws QuerySyntaxException {
        boolean invert = false;
        if (tok.m_token == 3) {
            invert = true;
            this.advanceToken();
            tok = this.peekToken();
        }
        if (tok.m_token != 98) {
            throw this.syntaxError(tok, " between ");
        }
        return this.parseBetweenPost(invert, factor);
    }

    private PNode parseBetweenPost(boolean invert, PNode factor) throws QuerySyntaxException {
        this.advanceToken();
        PNode first = this.parseFactor();
        PToken tok = this.advanceToken();
        if (tok.m_token != 1) {
            throw this.syntaxError(tok, " and ");
        }
        PNode second = this.parseFactor();
        PBinaryExpr cmpl = new PBinaryExpr(factor, first, 12);
        PBinaryExpr cmpr = new PBinaryExpr(factor, second, 11);
        PNode resNode = new PBinaryExpr(cmpl, cmpr, 1);
        if (invert) {
            resNode = new PUnaryExpr(resNode, 3);
        }
        return resNode;
    }

    private QuerySyntaxException syntaxError(PToken tok, String reason) throws QuerySyntaxException {
        return new QuerySyntaxException("token = '" + tok + "'" + " at [" + tok.m_position + "]: expected " + reason);
    }

    static int isAsciiDigit(char c, int base) {
        if (base == 8) {
            return Query.isOctalDigit(c);
        }
        if (base == 16) {
            return Query.isHexDigit(c);
        }
        if (base == 10) {
            return Query.isDecimalDigit(c);
        }
        return -1;
    }

    static int isOctalDigit(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
        }
        return -1;
    }

    static int isHexDigit(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return -1;
    }

    static int isDecimalDigit(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
        }
        return -1;
    }

    private void pushbackToken() {
        if (this.m_tokenAvailable) {
            this.m_tokenAvailable = false;
            this.m_start = this.m_nextToken.m_position;
        }
    }

    private PToken peekForAddSub() throws QuerySyntaxException {
        if (this.m_tokenAvailable && (this.m_nextToken.m_token == 18 || this.m_nextToken.m_token == 17)) {
            return this.m_nextToken;
        }
        this.pushbackToken();
        this.m_nextToken = this.nextToken(true);
        this.m_tokenAvailable = true;
        return this.m_nextToken;
    }

    private PToken peekToken() throws QuerySyntaxException {
        if (this.m_tokenAvailable) {
            return this.m_nextToken;
        }
        this.m_nextToken = this.nextToken(false);
        this.m_tokenAvailable = true;
        return this.m_nextToken;
    }

    private PToken advanceToken() throws QuerySyntaxException {
        this.m_currentToken = this.m_tokenAvailable ? this.m_nextToken : this.peekToken();
        this.m_tokenAvailable = false;
        return this.m_currentToken;
    }

    private PToken nextToken(boolean lookForSub) throws QuerySyntaxException {
        int startToken = this.m_start;
        PToken token = null;
        while (this.m_start < this.m_length && Character.isWhitespace(this.m_buffer.charAt(this.m_start))) {
            ++this.m_start;
        }
        if (this.m_start == this.m_length) {
            return new PTokenEOS(this.m_start);
        }
        char ch = Character.toLowerCase(this.m_buffer.charAt(this.m_start));
        switch (ch) {
            case ',': {
                token = new PToken(16, startToken);
                break;
            }
            case '(': {
                token = new PToken(6, startToken);
                break;
            }
            case ')': {
                token = new PToken(7, startToken);
                break;
            }
            case '*': {
                token = new PToken(19, startToken);
                break;
            }
            case '/': {
                token = new PToken(20, startToken);
                break;
            }
            case '<': {
                if (this.peek() == '=') {
                    ++this.m_start;
                    token = new PToken(11, startToken);
                    break;
                }
                if (this.peek() == '>') {
                    ++this.m_start;
                    token = new PToken(13, startToken);
                    break;
                }
                token = new PToken(8, startToken);
                break;
            }
            case '>': {
                if (this.peek() == '=') {
                    ++this.m_start;
                    token = new PToken(12, startToken);
                    break;
                }
                token = new PToken(9, startToken);
                break;
            }
            case '!': {
                if (this.peek() == '=') {
                    ++this.m_start;
                    token = new PToken(13, startToken);
                    break;
                }
                throw new QuerySyntaxException(this.m_start, "'!' not followed by '='");
            }
            case '=': {
                token = new PToken(10, startToken);
                break;
            }
            case '\'': {
                token = this.parseStringConst();
                break;
            }
            case '+': {
                if (!lookForSub && this.peekIsNum()) break;
                token = new PToken(17, startToken);
                break;
            }
            case '-': {
                if (!lookForSub && this.peekIsNum()) break;
                token = new PToken(18, startToken);
            }
        }
        if (token == null) {
            if (Query.isAsciiDigit(ch, 10) != -1 || ch == '.' || ch == '-' || ch == '+') {
                token = this.parseNumberConst();
            } else if (Character.isJavaIdentifierStart(ch) || Character.isLetter(ch)) {
                token = this.setTokenType(this.parseIdentifier(), startToken);
            }
        }
        if (token == null) {
            throw new QuerySyntaxException(this.m_start, "unable to parse");
        }
        ++this.m_start;
        return token;
    }

    private char peek() throws QuerySyntaxException {
        if (this.m_start + 1 < this.m_length) {
            return this.m_buffer.charAt(this.m_start + 1);
        }
        throw new QuerySyntaxException(this.m_start, "end of expression");
    }

    private boolean peekIsNum() throws QuerySyntaxException {
        if (this.m_start + 1 >= this.m_length) {
            throw new QuerySyntaxException(this.m_start, "end of expression");
        }
        char c = this.m_buffer.charAt(this.m_start + 1);
        switch (c) {
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    private PToken parseNumberConst() throws QuerySyntaxException {
        int start = this.m_start;
        PToken token = null;
        boolean doExact = false;
        boolean doFloat = false;
        Object numObj = null;
        int lastIndex = -1;
        numObj = this.m_fp_parse.parse(this.m_buffer, this.m_start, this.m_length);
        if (numObj != null) {
            doFloat = true;
            lastIndex = this.m_fp_parse.getIndex();
        } else {
            numObj = this.m_int_parse.parse(this.m_buffer, this.m_start, this.m_length);
            if (numObj != null) {
                lastIndex = this.m_int_parse.getIndex();
                doExact = true;
            }
        }
        if (lastIndex == -1 || numObj == null) {
            throw new QuerySyntaxException(start, "could not parse number");
        }
        this.m_start = lastIndex;
        if (doFloat && numObj instanceof Double) {
            double d = (Double)numObj;
            token = new PTokenDoubleConst(d, start);
        } else if (doFloat && numObj instanceof Float) {
            float f = ((Float)numObj).floatValue();
            token = new PTokenFloatConst(f, start);
        } else if (doExact && numObj instanceof Long) {
            long t = (Long)numObj;
            token = new PTokenLongConst(t, start);
        } else if (doExact && numObj instanceof Integer) {
            int t = (Integer)numObj;
            token = new PTokenIntConst(t, start);
        } else {
            throw new QuerySyntaxException(start, "unable to parse numeric constant");
        }
        --this.m_start;
        return token;
    }

    private PToken parseStringConst() throws QuerySyntaxException {
        boolean done = false;
        ++this.m_start;
        int start = this.m_start;
        StringBuffer sbuf = new StringBuffer();
        while (!done) {
            char nextChar;
            char curChar = '\u0000';
            while (this.m_start < this.m_length && (curChar = this.m_buffer.charAt(this.m_start)) != '\'') {
                sbuf.append(curChar);
                ++this.m_start;
            }
            if (this.m_start == this.m_length) {
                throw new QuerySyntaxException(this.m_start - 1, "end of expression while parsing string");
            }
            done = true;
            if (this.m_start >= this.m_length - 1 || (nextChar = this.m_buffer.charAt(this.m_start + 1)) != '\'') continue;
            done = false;
            this.m_start += 2;
            sbuf.append(nextChar);
        }
        PTokenStringConst token = new PTokenStringConst(sbuf.toString(), start - 1);
        return token;
    }

    private String parseIdentifier() throws QuerySyntaxException {
        int startId = this.m_start;
        char c = this.m_buffer.charAt(this.m_start);
        if (!Character.isJavaIdentifierStart(c) && !Character.isLetter(c)) {
            throw new QuerySyntaxException("cannot start with: :'" + c + "'");
        }
        ++this.m_start;
        boolean cont = true;
        while (this.m_start < this.m_length && cont) {
            c = this.m_buffer.charAt(this.m_start);
            if (!Character.isJavaIdentifierPart(c) && !Character.isLetter(c)) {
                cont = false;
                continue;
            }
            ++this.m_start;
        }
        String identifier = this.m_buffer.substring(startId, this.m_start);
        --this.m_start;
        return identifier;
    }

    private PToken setTokenType(String identifier, int start) throws QuerySyntaxException {
        int lo = 0;
        int hi = s_keywords.length;
        String target = identifier.toLowerCase();
        while (lo < hi) {
            int mid = (lo + hi) / 2;
            int cmp = target.compareTo(Query.s_keywords[mid].m_keyword);
            if (cmp > 0) {
                lo = mid + 1;
                continue;
            }
            if (cmp < 0) {
                hi = mid;
                continue;
            }
            return new PToken(Query.s_keywords[mid].m_keyval, start);
        }
        return new PTokenIdent(identifier, start);
    }

    static QuerySemanticException semanticError(String reason) {
        return new QuerySemanticException("Semantic error: " + reason);
    }

    static {
        for (int i = 0; i < 100; ++i) {
            Query.tokenToString[i] = " undefined ";
        }
        Query.tokenToString[1] = " AND ";
        Query.tokenToString[2] = " OR ";
        Query.tokenToString[3] = " NOT ";
        Query.tokenToString[4] = " TRUE ";
        Query.tokenToString[5] = " FALSE ";
        Query.tokenToString[6] = " ( ";
        Query.tokenToString[7] = " ) ";
        Query.tokenToString[8] = " < ";
        Query.tokenToString[9] = " > ";
        Query.tokenToString[10] = " = ";
        Query.tokenToString[11] = " <= ";
        Query.tokenToString[12] = " >= ";
        Query.tokenToString[13] = " <> ";
        Query.tokenToString[14] = " [ ";
        Query.tokenToString[15] = " ] ";
        Query.tokenToString[97] = " is ";
        Query.tokenToString[21] = " NULL ";
        Query.tokenToString[16] = " , ";
        Query.tokenToString[17] = " + ";
        Query.tokenToString[18] = " - ";
        Query.tokenToString[19] = " * ";
        Query.tokenToString[20] = " / ";
        Query.tokenToString[50] = " <ID> ";
        Query.tokenToString[51] = " <int_const> ";
        Query.tokenToString[52] = " <long_const> ";
        Query.tokenToString[53] = " <float_const> ";
        Query.tokenToString[54] = " <double_const> ";
        Query.tokenToString[55] = " <string_const> ";
        Query.tokenToString[99] = " in ";
        Query.tokenToString[100] = " like ";
        Query.tokenToString[98] = " between ";
        Query.tokenToString[22] = " escape ";
        s_keywords = new TableEntry[]{new TableEntry("and", 1), new TableEntry("between", 98), new TableEntry("escape", 22), new TableEntry("false", 5), new TableEntry("in", 99), new TableEntry("is", 97), new TableEntry("like", 100), new TableEntry("not", 3), new TableEntry("null", 21), new TableEntry("or", 2), new TableEntry("true", 4)};
    }
}

