/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.IExpression;
import com.evermind.server.jms.filter.IStringExpression;
import com.evermind.server.jms.filter.LikeExpression;
import com.evermind.server.jms.filter.PFieldName;
import com.evermind.server.jms.filter.PNode;
import com.evermind.server.jms.filter.Query;
import com.evermind.server.jms.filter.QuerySemanticException;

class PLike
extends PNode {
    PFieldName m_ident;
    boolean m_invert;
    boolean useEscape;
    char m_escapeChar;
    String m_pattern;

    PLike(PFieldName ident, boolean invert, String pattern) {
        this.m_ident = ident;
        this.m_invert = invert;
        this.m_pattern = pattern;
        this.useEscape = false;
    }

    PLike(PFieldName ident, boolean invert, String pattern, char escapeChar) {
        this.m_ident = ident;
        this.m_invert = invert;
        this.m_pattern = pattern;
        this.m_escapeChar = escapeChar;
        this.useEscape = true;
    }

    IExpression convert(Query q) throws QuerySemanticException {
        IExpression id = this.m_ident.convert(q);
        if (!(id instanceof IStringExpression)) {
            throw new QuerySemanticException(this.m_ident + " does not evaluate to a string " + "for " + this);
        }
        IStringExpression ise = (IStringExpression)id;
        if (this.useEscape) {
            return new LikeExpression(ise, this.m_invert, this.m_pattern, this.m_escapeChar);
        }
        return new LikeExpression(ise, this.m_invert, this.m_pattern);
    }

    public String toString() {
        String func = this.m_invert ? " not like " : " like ";
        return this.m_ident.toString() + func + '\'' + this.m_pattern + '\'' + (this.useEscape ? " escape '" + this.m_escapeChar + '\\' : "");
    }
}

