/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.Apply;
import com.evermind.server.jms.filter.BooleanExpression;
import com.evermind.server.jms.filter.GeneralException;
import com.evermind.server.jms.filter.IExpression;
import javax.jms.Message;

class IsNullExpression
extends BooleanExpression {
    private boolean m_invert;

    IsNullExpression(IExpression expr, boolean invert) {
        super(expr.toString() + " is " + (invert ? " not null" : "null"), expr);
        this.m_invert = invert;
    }

    public void eval(Message m) {
        this.m_val = this.m_invert ? !this.m_leftExpr.isNull() : this.m_leftExpr.isNull();
    }

    public boolean equals(Object expr) {
        if (expr instanceof IsNullExpression) {
            IsNullExpression inexpr = (IsNullExpression)expr;
            return this.m_leftExpr.equals(inexpr.m_leftExpr) && this.m_invert == inexpr.m_invert;
        }
        return false;
    }

    public Object depthFirstApply(Apply app) throws GeneralException {
        this.m_leftExpr = (IExpression)app.apply(this.m_leftExpr);
        return app.apply(this);
    }
}

