/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.Apply;
import com.evermind.server.jms.filter.BooleanExpression;
import com.evermind.server.jms.filter.GeneralException;
import com.evermind.server.jms.filter.IIntegerExpression;
import com.evermind.server.jms.filter.QueryTypeException;
import javax.jms.Message;

class IntegerLtExpr
extends BooleanExpression {
    IntegerLtExpr(IIntegerExpression leftOp, IIntegerExpression rightOp) {
        super("(" + leftOp.toString() + " < " + rightOp.toString() + ")", leftOp, rightOp);
    }

    public void eval(Message m) throws QueryTypeException {
        this.m_null = false;
        this.m_val = false;
        if (this.m_leftExpr.isNull() || this.m_rightExpr.isNull()) {
            this.m_null = true;
        } else {
            this.m_val = ((IIntegerExpression)this.m_leftExpr).getIntVal() < ((IIntegerExpression)this.m_rightExpr).getIntVal();
        }
    }

    public boolean equals(Object expr) {
        if (expr instanceof IntegerLtExpr) {
            return this.m_leftExpr.equals(((IntegerLtExpr)expr).m_leftExpr) && this.m_rightExpr.equals(((IntegerLtExpr)expr).m_rightExpr);
        }
        return false;
    }

    public Object depthFirstApply(Apply app) throws GeneralException {
        this.m_leftExpr = (IIntegerExpression)this.m_leftExpr.depthFirstApply(app);
        this.m_rightExpr = (IIntegerExpression)this.m_rightExpr.depthFirstApply(app);
        return app.apply(this);
    }
}

