/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.Apply;
import com.evermind.server.jms.filter.AssertException;
import com.evermind.server.jms.filter.Expression;
import com.evermind.server.jms.filter.GeneralException;
import com.evermind.server.jms.filter.IBooleanExpression;
import com.evermind.server.jms.filter.QueryTypeException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.Message;

final class ExpressionVector {
    List exprs = new ArrayList();

    ExpressionVector() {
    }

    public String toString() {
        Iterator iter = this.exprs.iterator();
        String res = "";
        while (iter.hasNext()) {
            Expression ie = (Expression)iter.next();
            res = res + " " + ie.toString() + "<c=" + ie.getCount() + "> <i=" + ie.getid() + "> ";
        }
        return res;
    }

    void evaluate(Message formattedMessage) throws AssertException {
        Iterator liter = this.exprs.iterator();
        while (liter.hasNext()) {
            try {
                Expression ie = (Expression)liter.next();
                ie.eval(formattedMessage);
            }
            catch (QueryTypeException queryTypeException) {}
        }
    }

    IBooleanExpression addNewExpr(IBooleanExpression expr) throws GeneralException {
        return (IBooleanExpression)expr.depthFirstApply(new AddNewExprApp());
    }

    void removeExpr(IBooleanExpression expr) throws GeneralException {
        expr.depthFirstApply(new RemoveExprApp());
    }

    class RemoveExprApp
    implements Apply {
        RemoveExprApp() {
        }

        public Object apply(Object arg) throws AssertException {
            if (!(arg instanceof Expression)) {
                throw new AssertException("Expecting Expression, received " + arg.getClass().getName() + " as " + arg, null);
            }
            Expression expr = (Expression)arg;
            Expression e = null;
            Iterator liter = ExpressionVector.this.exprs.iterator();
            while (liter.hasNext()) {
                e = (Expression)liter.next();
                if (e != expr) continue;
                if (e.removeRef()) {
                    liter.remove();
                }
                return e;
            }
            throw new AssertException("Did not find expression" + expr, null);
        }
    }

    class AddNewExprApp
    implements Apply {
        AddNewExprApp() {
        }

        public Object apply(Object arg) throws AssertException {
            if (!(arg instanceof Expression)) {
                throw new AssertException("Expecting Expression, received " + arg.getClass().getName() + " as " + arg, null);
            }
            Expression expr = (Expression)arg;
            Expression e = null;
            Iterator liter = ExpressionVector.this.exprs.iterator();
            while (liter.hasNext()) {
                e = (Expression)liter.next();
                if (!e.equals(expr)) continue;
                e.addRef();
                return e;
            }
            ExpressionVector.this.exprs.add(expr);
            return expr;
        }
    }
}

