/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.Query;
import com.evermind.server.jms.filter.QuerySyntaxException;

class ExactParser {
    private int index;

    ExactParser() {
    }

    int getIndex() {
        return this.index;
    }

    Object parse(String buffer, int start, int length) throws QuerySyntaxException {
        if (start >= length) {
            return null;
        }
        int base = 10;
        long value = 0L;
        boolean neg = false;
        int state = 0;
        this.index = start;
        while (this.index < length) {
            char curChar = buffer.charAt(this.index);
            switch (state) {
                case 0: {
                    if (curChar == '-') {
                        neg = true;
                        state = 1;
                        break;
                    }
                    if (curChar == '+') {
                        state = 1;
                        break;
                    }
                    int digVal = Query.isAsciiDigit(curChar, 10);
                    if (digVal == 0) {
                        base = 8;
                        state = 3;
                        break;
                    }
                    digVal = Query.isAsciiDigit(curChar, 10);
                    if (digVal != -1) {
                        value = value * (long)base + (long)digVal;
                        state = 2;
                        break;
                    }
                    return null;
                }
                case 1: {
                    long prev;
                    int digVal = Query.isAsciiDigit(curChar, base);
                    if (digVal != -1) {
                        if (neg ? (value = value * (long)base - (long)digVal) >= (prev = value) : (value = value * (long)base + (long)digVal) <= (prev = value)) {
                            throw new QuerySyntaxException(start, "overflow");
                        }
                        state = 2;
                        break;
                    }
                    return null;
                }
                case 3: {
                    if (curChar == 'x' || curChar == 'X') {
                        base = 16;
                        state = 1;
                        break;
                    }
                }
                case 2: {
                    long prev;
                    int digVal = Query.isAsciiDigit(curChar, base);
                    if (digVal != -1) {
                        if (!(neg ? (value = value * (long)base - (long)digVal) >= (prev = value) : (value = value * (long)base + (long)digVal) <= (prev = value))) break;
                        throw new QuerySyntaxException(start, "overflow");
                    }
                    if (curChar == 'l' || curChar == 'L') {
                        ++this.index;
                        return new Long(value);
                    }
                    if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
                        return new Integer((int)value);
                    }
                    throw new QuerySyntaxException("cannot represent " + value + " as an integer");
                }
                default: {
                    return null;
                }
            }
            ++this.index;
        }
        if (state == 2 || state == 3) {
            if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
                return new Integer((int)value);
            }
            return new Long(value);
        }
        return null;
    }
}

