/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.Expression;
import com.evermind.server.jms.filter.IDynamicExpression;
import com.evermind.server.jms.filter.QueryTypeException;

abstract class DynamicExpression
extends Expression
implements IDynamicExpression {
    protected IDynamicExpression m_leftExpr;
    protected IDynamicExpression m_rightExpr;
    protected int int_val;
    protected long long_val;
    protected boolean boolean_val;
    protected String string_val;
    protected double double_val;
    protected float float_val;
    protected int cur_type = -1;

    DynamicExpression(String s, IDynamicExpression leftExpr, IDynamicExpression rightExpr) {
        super(s);
        this.m_leftExpr = leftExpr;
        this.m_rightExpr = rightExpr;
    }

    DynamicExpression(String s, IDynamicExpression leftExpr) {
        super(s);
        this.m_leftExpr = leftExpr;
        this.m_rightExpr = null;
    }

    DynamicExpression(String s) {
        super(s);
        this.m_leftExpr = null;
        this.m_rightExpr = null;
    }

    public int typeOf() {
        return 7;
    }

    public int getCurrentType() {
        return this.cur_type;
    }

    public int getIntVal() throws QueryTypeException {
        switch (this.cur_type) {
            case 2: {
                return this.int_val;
            }
        }
        throw new QueryTypeException("Cannot cast from type id : " + this.cur_type + " to int for the expression: " + this.toString());
    }

    public long getLongVal() throws QueryTypeException {
        switch (this.cur_type) {
            case 2: {
                return this.int_val;
            }
            case 4: {
                return this.long_val;
            }
        }
        throw new QueryTypeException("Cannot cast from type id : " + this.cur_type + " to long for the expression: " + this.toString());
    }

    public float getFloatVal() throws QueryTypeException {
        switch (this.cur_type) {
            case 2: {
                return this.int_val;
            }
            case 4: {
                return this.long_val;
            }
            case 5: {
                return this.float_val;
            }
        }
        throw new QueryTypeException("Cannot cast from type id : " + this.cur_type + " to float for the expression: " + this.toString());
    }

    public double getDoubleVal() throws QueryTypeException {
        switch (this.cur_type) {
            case 2: {
                return this.int_val;
            }
            case 4: {
                return this.long_val;
            }
            case 5: {
                return this.float_val;
            }
            case 6: {
                return this.double_val;
            }
        }
        throw new QueryTypeException("Cannot cast from type id : " + this.cur_type + " to double for the expression: " + this.toString());
    }

    public boolean getBooleanVal() throws QueryTypeException {
        switch (this.cur_type) {
            case 1: {
                return this.boolean_val;
            }
        }
        throw new QueryTypeException("Cannot cast from type id : " + this.cur_type + " to boolean for the expression: " + this.toString());
    }

    public String getStringVal() throws QueryTypeException {
        switch (this.cur_type) {
            case 3: {
                return this.string_val;
            }
        }
        throw new QueryTypeException("Cannot cast from type id : " + this.cur_type + " to string for the expression: " + this.toString());
    }

    public void setIntVal(int val) {
        this.int_val = val;
        this.cur_type = 2;
    }

    public void setLongVal(long val) {
        this.long_val = val;
        this.cur_type = 4;
    }

    public void setFloatVal(float val) {
        this.float_val = val;
        this.cur_type = 5;
    }

    public void setDoubleVal(double val) {
        this.double_val = val;
        this.cur_type = 6;
    }

    public void setStringVal(String val) {
        this.string_val = val;
        this.cur_type = 3;
    }

    public void setBooleanVal(boolean val) {
        this.boolean_val = val;
        this.cur_type = 1;
    }
}

