/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.Apply;
import com.evermind.server.jms.filter.DoubleExpression;
import com.evermind.server.jms.filter.GeneralException;
import com.evermind.server.jms.filter.IDoubleExpression;
import com.evermind.server.jms.filter.QueryTypeException;
import javax.jms.Message;

class DoubleMult
extends DoubleExpression {
    DoubleMult(IDoubleExpression leftExpr, IDoubleExpression rightExpr) {
        super(leftExpr.toString() + " * " + rightExpr.toString(), leftExpr, rightExpr);
    }

    public void eval(Message m) throws QueryTypeException {
        this.m_null = false;
        if (this.m_leftExpr.isNull() || this.m_rightExpr.isNull()) {
            this.m_null = true;
        } else {
            this.m_val = this.m_leftExpr.getDoubleVal() * this.m_rightExpr.getDoubleVal();
        }
    }

    public boolean equals(Object expr) {
        if (expr instanceof DoubleMult) {
            return this.m_leftExpr.equals(((DoubleMult)expr).m_leftExpr) && this.m_rightExpr.equals(((DoubleMult)expr).m_rightExpr);
        }
        return false;
    }

    public Object depthFirstApply(Apply app) throws GeneralException {
        this.m_leftExpr = (IDoubleExpression)this.m_leftExpr.depthFirstApply(app);
        this.m_rightExpr = (IDoubleExpression)this.m_rightExpr.depthFirstApply(app);
        return app.apply(this);
    }
}

