/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.administration;

import com.evermind.server.jms.JMSServer;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.administration.DefaultQueueAdministrator;
import com.evermind.server.jms.administration.JMSServerAdministrator;
import com.evermind.server.jms.administration.QueueAdministrator;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;

public class DefaultJMSServerAdministrator
implements JMSServerAdministrator {
    private JMSServer server;

    public DefaultJMSServerAdministrator(JMSServer server) {
        this.server = server;
    }

    public QueueAdministrator getQueue(String name) throws JMSException {
        return new DefaultQueueAdministrator(this.server, name);
    }

    public List getQueues() {
        ArrayList queues = new ArrayList();
        ArrayList<DefaultQueueAdministrator> response = new ArrayList<DefaultQueueAdministrator>();
        for (int i = 0; i < queues.size(); ++i) {
            response.add(new DefaultQueueAdministrator(this.server, (String)queues.get(i)));
        }
        return response;
    }

    public void putQueue(Map queueInfo) throws IOException, InstantiationException {
    }

    public void putTopic(Map topicInfo) throws IOException, InstantiationException {
    }

    public void putConnectionFactory(Map connectionFactory) throws IOException, InstantiationException {
    }

    public void putQueueConnectionFactory(Map queueConnectionFactory) throws IOException, InstantiationException {
    }

    public void putTopicConnectionFactory(Map topicConnectionFactory) throws IOException, InstantiationException {
    }

    public Map getStatistics() {
        HashMap response = new HashMap();
        return response;
    }

    public void disconnectClients(List clients, String message) {
    }

    public String list() throws RemoteException {
        String ret = "";
        try {
            ret = this.server.list();
        }
        catch (Throwable ex) {
            JMSUtils.toRemoteException("list", ex);
        }
        return ret;
    }

    public void sync() throws RemoteException {
        try {
            this.server.sync();
        }
        catch (Throwable ex) {
            JMSUtils.toRemoteException("sync", ex);
        }
    }

    public void server(String host, String port) throws RemoteException {
        try {
            this.server.server(host, port);
        }
        catch (Throwable ex) {
            JMSUtils.toRemoteException("server(" + host + "," + port + ")", ex);
        }
    }

    public void addFactory(int domain, Map info) throws RemoteException {
        try {
            this.server.addFactory(domain, info);
        }
        catch (Throwable ex) {
            JMSUtils.toRemoteException("addFactory", ex);
        }
    }

    public void removeFactory(String location) throws RemoteException {
        try {
            this.server.removeFactory(location);
        }
        catch (Throwable ex) {
            JMSUtils.toRemoteException("removeFactory", ex);
        }
    }

    public void addDestination(boolean isQ, Map info) throws RemoteException {
        try {
            this.server.addDestination(isQ, info);
        }
        catch (Throwable ex) {
            JMSUtils.toRemoteException("addDestination", ex);
        }
    }

    public void removeDestination(String name) throws RemoteException {
        try {
            this.server.removeDestination(name);
        }
        catch (Throwable ex) {
            JMSUtils.toRemoteException("removeDestination", ex);
        }
    }
}

