/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.tpc.NormalXid;

public final class SessionID
implements Serializable {
    private String m_sessionID = null;
    private Xid m_xid = null;
    static final long serialVersionUID = -4926630026000811843L;

    private SessionID() {
        this.m_sessionID = null;
        this.m_xid = null;
    }

    public SessionID(String sessionID) {
        JMSUtils.checkNull("SessionID", "sessionID", sessionID);
        this.m_sessionID = sessionID;
        this.m_xid = null;
    }

    public SessionID(Xid xid) {
        JMSUtils.checkNull("SessionID", "xid", xid);
        this.m_sessionID = null;
        this.m_xid = xid instanceof NormalXid ? xid : new NormalXid(xid);
    }

    public String toString() {
        return this.m_sessionID != null ? this.m_sessionID.toString() : this.m_xid.toString();
    }

    public boolean equals(Object o) {
        return o instanceof SessionID && this.compareTo((SessionID)o);
    }

    public int hashCode() {
        return this.m_sessionID != null ? this.m_sessionID.hashCode() : this.m_xid.hashCode();
    }

    private void writeObject(ObjectOutputStream oout) throws IOException {
        this.writeTo(oout);
    }

    private void readObject(ObjectInputStream oinp) throws IOException, ClassNotFoundException {
        this.readFrom(oinp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] toBytes() throws IOException {
        ByteArrayOutputStream bout = null;
        DataOutputStream dout = null;
        byte[] buf = null;
        try {
            bout = new ByteArrayOutputStream();
            dout = new DataOutputStream(bout);
            this.writeTo(dout);
            dout.flush();
            bout.flush();
            buf = bout.toByteArray();
        }
        catch (Throwable throwable) {
            JMSUtils.closeIt(dout);
            JMSUtils.closeIt(bout);
            throw throwable;
        }
        JMSUtils.closeIt(dout);
        JMSUtils.closeIt(bout);
        return buf;
    }

    synchronized void writeTo(DataOutput dout) throws IOException {
        this.writeTo(-559038734, dout);
    }

    synchronized void writeTo(int protocol, DataOutput dout) throws IOException {
        if (protocol == -559038735) {
            dout.writeUTF(this.m_sessionID != null ? this.m_sessionID : this.m_xid.toString());
            return;
        }
        dout.writeByte(8);
        dout.writeBoolean(this.m_xid == null);
        if (this.m_xid == null) {
            dout.writeUTF(this.m_sessionID);
        } else {
            int fmt = this.m_xid.getFormatId();
            byte[] gid = this.m_xid.getGlobalTransactionId();
            byte[] bid = this.m_xid.getBranchQualifier();
            dout.writeInt(fmt);
            JMSUtils.packWrite(gid, dout);
            JMSUtils.packWrite(bid, dout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionID toSessionID(byte[] buf) throws IOException {
        ByteArrayInputStream binp = null;
        DataInputStream dinp = null;
        SessionID id = null;
        try {
            binp = new ByteArrayInputStream(buf);
            dinp = new DataInputStream(binp);
            id = SessionID.readSessionID(dinp);
        }
        catch (Throwable throwable) {
            JMSUtils.closeIt(dinp);
            JMSUtils.closeIt(binp);
            throw throwable;
        }
        JMSUtils.closeIt(dinp);
        JMSUtils.closeIt(binp);
        return id;
    }

    static SessionID readSessionID(DataInput dinp) throws IOException {
        return SessionID.readSessionID(-559038734, dinp);
    }

    static SessionID readSessionID(int protocol, DataInput dinp) throws IOException {
        SessionID id = new SessionID();
        if (protocol == -559038735) {
            id.m_sessionID = dinp.readUTF();
        } else {
            id.readFrom(dinp);
        }
        return id;
    }

    private void readFrom(DataInput dinp) throws IOException {
        byte type = dinp.readByte();
        if (type != 8) {
            JMSUtils.toIOException(JMSMessages.getMessage("J2EE JMS-02602", "readFrom", "" + type, ""));
        } else {
            boolean noXA = dinp.readBoolean();
            if (noXA) {
                this.m_sessionID = dinp.readUTF();
                this.m_xid = null;
            } else {
                int fmt = dinp.readInt();
                byte[] gid = (byte[])JMSUtils.packRead(dinp);
                byte[] bid = (byte[])JMSUtils.packRead(dinp);
                this.m_sessionID = null;
                this.m_xid = new NormalXid(gid, fmt, bid);
            }
        }
    }

    public String sessionID() {
        return this.m_sessionID;
    }

    public Xid xid() {
        return this.m_xid;
    }

    public boolean isXA() {
        return this.m_xid != null;
    }

    private boolean compareTo(SessionID id) {
        return JMSUtils.equals(this.m_sessionID, id.m_sessionID) && JMSUtils.equals(this.m_xid, id.m_xid);
    }
}

