/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.ConsumerInfo;
import com.evermind.server.jms.EvermindDestination;
import com.evermind.server.jms.EvermindMessage;
import com.evermind.server.jms.EvermindQueue;
import com.evermind.server.jms.EvermindTemporaryDestination;
import com.evermind.server.jms.EvermindTopic;
import com.evermind.server.jms.JMSServer;
import com.evermind.server.jms.JMSServerUtils;
import com.evermind.server.jms.JMSStats;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.JMXSupport;
import com.evermind.server.jms.MessageSelector;
import com.evermind.server.jms.ServerFile;
import com.evermind.server.jms.ServerQueue;
import com.evermind.server.jms.ServerStore;
import com.evermind.server.jms.ServerTopic;
import com.evermind.server.jms.Tset;
import com.evermind.server.jms.TxMap;
import com.evermind.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import oracle.oc4j.admin.management.callbackinterfaces.JMSUtilsCallBackIf;
import oracle.oc4j.admin.management.mbeans.JMSQueue;
import oracle.oc4j.admin.management.mbeans.JMSTopic;
import org.w3c.dom.Node;

public abstract class ServerDestination {
    private final Destination m_dest;
    private final ServerFile m_file;
    private final String m_name;
    private final String m_id;
    private final JMSStats m_jstats;
    private final Tset m_isClosed = new Tset(false);
    private static final JMSTraceLogger s_traceLogger = new JMSTraceLogger(ServerDestination.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerDestination(TxMap txMap, Destination d) throws Exception {
        this.m_dest = d;
        String tmp = JMSUtils.isTemp(d) ? "Temporary" : "";
        String domain = JMSUtils.isQ(d) ? "Queue" : "Topic";
        this.m_name = "Server" + domain + "[" + JMSUtils.getName(d) + "]";
        this.m_id = tmp + domain + "." + JMSUtils.getName(d);
        String type = JMSUtils.isTemp(d) ? "JMSTemporaryDestination" : "JMSDestination";
        this.m_jstats = JMSStats.create("/JMS", this.m_id, type);
        JMSUtilsCallBackIf cb = JMSServerUtils.getJMSUtilsCallBack(JMSUtils.getName(d), JMSUtils.isT(d));
        if (JMSUtils.isTemp(d)) {
            String cid = ((EvermindTemporaryDestination)d).getConnectionID();
            this.m_jstats.state("connectionID", cid, true);
            this.m_jstats.setMBean(JMSUtils.isT(d) ? new JMSTopic(cb, this.m_id, JMSUtils.getName(d), cid) : new JMSQueue(cb, this.m_id, JMSUtils.getName(d), cid));
        } else {
            String loc = ((EvermindDestination)d).getLocation();
            String desc = ((EvermindDestination)d).getDescription();
            this.m_jstats.state("location", loc, true);
            this.m_jstats.state("description", desc, true);
            this.m_jstats.setMBean(JMSUtils.isT(d) ? new JMSTopic(cb, this.m_id, JMSUtils.getName(d), desc, loc) : new JMSQueue(cb, this.m_id, JMSUtils.getName(d), desc, loc));
        }
        this.m_jstats.state("name", JMSUtils.getName(d), true);
        this.m_jstats.state("domain", JMSUtils.domain(d), true);
        boolean success = false;
        try {
            this.m_file = ServerDestination.makeFile(txMap, d, JMSUtils.isQ(d) ? (byte)3 : 5, this.m_jstats.getName());
            success = true;
        }
        finally {
            if (!success) {
                this.m_jstats.close();
            }
        }
    }

    static EvermindDestination createDestination(Node parent, boolean isQ, URL url) throws InstantiationException {
        return isQ ? new EvermindQueue(ServerDestination.makeMap(parent), url) : new EvermindTopic(ServerDestination.makeMap(parent), url);
    }

    private static Map makeMap(Node parent) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", JMSUtils.get(parent, "name", null));
        map.put("location", JMSUtils.get(parent, "location", null));
        map.put("persistence-file", JMSUtils.get(parent, "persistence-file", null));
        map.put("description", XMLUtils.getSubnodeValue(parent, "description"));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String toXML(EvermindDestination dest) {
        String string;
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter((Writer)sw, true);
            ServerDestination.writeXML(dest, pw, "", true);
            pw.flush();
            sw.flush();
            string = sw.toString();
        }
        catch (Throwable ex) {
            try {
                s_traceLogger.fine("toXML", ex);
                return "";
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                JMSUtils.closeIt(pw);
                JMSUtils.closeIt(sw);
            }
        }
        JMSUtils.closeIt(pw);
        JMSUtils.closeIt(sw);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeXML(EvermindDestination dest, PrintWriter out, String indent) throws IOException {
        EvermindDestination evermindDestination = dest;
        synchronized (evermindDestination) {
            ServerDestination.writeXML(dest, out, indent, false);
        }
    }

    private static void writeXML(EvermindDestination dest, PrintWriter out, String indent, boolean doSpecial) throws IOException {
        if (dest.isSpecial() && !doSpecial) {
            return;
        }
        String prefix = JMSUtils.pp(dest).toLowerCase();
        out.println(indent + "<" + prefix);
        JMSUtils.encode(out, indent, "name", dest.getName());
        JMSUtils.encode(out, indent, "location", dest.getLocation());
        if (!JMSUtils.isNull(dest.getRelativePath())) {
            JMSUtils.encode(out, indent, "persistence-file", dest.getRelativePath());
        }
        out.println(indent + ">");
        if (!JMSUtils.isNull(dest.getDescription())) {
            out.println(indent + "    <description>" + dest.getDescription() + "</description>");
        }
        out.println(indent + "</" + prefix + ">");
    }

    public String toString() {
        return this.m_name;
    }

    static ServerDestination createDestination(TxMap txMap, Destination dest) throws Exception {
        return JMSUtils.isQ(dest) ? new ServerQueue(txMap, (Queue)dest) : new ServerTopic(txMap, (Topic)dest);
    }

    String getID() {
        return this.m_id;
    }

    protected final long startPhase(String func) {
        return this.m_isClosed.test() ? 0L : this.m_jstats.phase(func);
    }

    protected final void stopPhase(String func, long tok) {
        if (!this.m_isClosed.test()) {
            this.m_jstats.phase(func, tok);
        }
    }

    protected final ServerStore makeStore(ConsumerInfo cons) throws Exception {
        return new ServerStore(this.m_jstats.getName(), this, cons);
    }

    protected final void commitFile(Object sessionID) throws JMSException {
        try {
            this.m_file.commit(sessionID);
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("commitFile(" + this.m_file + "," + sessionID + ")", ex);
        }
    }

    protected final void rollbackFile(Object sessionID) throws JMSException {
        try {
            this.m_file.rollback(sessionID);
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("rollbackFile(" + this.m_file + "," + sessionID + ")", ex);
        }
    }

    protected abstract void closeDestination() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void close() throws Exception {
        block6: {
            if (this.m_isClosed.testAndSet(true)) {
                return;
            }
            try {
                this.closeDestination();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                try {
                    this.m_file.close();
                }
                catch (Throwable ex) {
                    s_traceLogger.fine(this.toString(), ex);
                }
                this.m_jstats.close();
                throw throwable;
            }
            try {
                this.m_file.close();
                break block6;
            }
            catch (Throwable ex) {
                s_traceLogger.fine(this.toString(), ex);
            }
            {
            }
        }
        this.m_jstats.close();
    }

    public final Destination getDestination() {
        return this.m_dest;
    }

    public final ServerFile getFile() {
        return this.m_file;
    }

    public final String getCanonicalName() {
        return JMXSupport.getCanonicalName(this.m_jstats.getMBean());
    }

    public boolean isPersistent() {
        return !this.m_file.isDummy();
    }

    public final String getPersistenceCanonicalName() {
        return this.m_file.getCanonicalName();
    }

    public abstract void enq(String var1, Object var2, boolean var3, EvermindMessage var4) throws JMSException;

    public abstract EvermindMessage deq(ConsumerInfo var1, Object var2, String var3, boolean var4) throws JMSException;

    public abstract void expireMessages();

    public abstract List listMessages(String var1, Object var2, MessageSelector var3) throws JMSException;

    public abstract EvermindMessage peekMessage(String var1, String var2) throws JMSException;

    public abstract void commit(Object var1) throws JMSException;

    public abstract void rollback(Object var1) throws JMSException;

    public abstract void addConsumer(ConsumerInfo var1) throws JMSException;

    public abstract void removeConsumer(ConsumerInfo var1) throws JMSException;

    public abstract List listDurableConsumers();

    public abstract boolean isActive();

    private static ServerFile makeFile(TxMap txMap, Destination d, byte dType, String statsName) throws Exception {
        if (txMap == null) {
            return ServerFile.getDummy();
        }
        if (!JMSServer.USE_PERSISTENCE) {
            return ServerFile.getDummy();
        }
        if (JMSUtils.isTemp(d)) {
            return ServerFile.getDummy();
        }
        String file = ((EvermindDestination)d).getPersistenceFile();
        if (JMSUtils.isNull(file)) {
            return ServerFile.getDummy();
        }
        return new ServerFile(txMap, statsName, JMSUtils.fold(file), dType, JMSUtils.getName(d), true, true, !((EvermindDestination)d).isExceptionQueue());
    }
}

