/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.EvermindMessage;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.jms.JMSException;

public final class PropertyMap
implements Serializable {
    private final EvermindMessage m_msg;
    private final boolean m_isHdr;
    private final Map m_data = new HashMap();
    private static Set s_selKey = new HashSet();
    static final long serialVersionUID = -2190710255706385000L;

    PropertyMap(EvermindMessage msg) {
        this(msg, true);
    }

    PropertyMap(EvermindMessage msg, boolean isHdr) {
        this.m_msg = msg;
        this.m_isHdr = isHdr;
    }

    void copyInto(PropertyMap ret) throws JMSException {
        ret.m_data.clear();
        Iterator iter = this.m_data.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            Object val = entry.getValue();
            ret.m_data.put(key, val);
        }
    }

    final void writeTo(DataOutput dout) throws IOException {
        dout.writeInt(this.m_data.size());
        Iterator iter = this.m_data.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            Object val = entry.getValue();
            dout.writeUTF(key);
            JMSUtils.packWrite(val, dout);
        }
    }

    final void readFrom(DataInput dinp) throws IOException {
        int size = dinp.readInt();
        for (int i = 0; i < size; ++i) {
            String key = dinp.readUTF();
            Object val = JMSUtils.packRead(dinp);
            this.m_data.put(key, val);
        }
    }

    boolean getBoolean(String key) throws JMSException {
        boolean ret = false;
        Object v = this.get(key);
        if (v instanceof Boolean) {
            ret = (Boolean)v;
        } else if (v == null || v instanceof String) {
            ret = Boolean.valueOf((String)v);
        } else {
            this.badFormat("getBoolean", v);
        }
        return ret;
    }

    byte getByte(String key) throws JMSException {
        byte ret = 0;
        Object v = this.get(key);
        if (v instanceof Byte) {
            ret = (Byte)v;
        } else if (v == null || v instanceof String) {
            ret = Byte.valueOf((String)v);
        } else {
            this.badFormat("getByte", v);
        }
        return ret;
    }

    byte[] getBytes(String key) throws JMSException {
        byte[] ret = null;
        Object v = this.get(key);
        if (v == null || v instanceof byte[]) {
            ret = (byte[])v;
        } else {
            this.badFormat("getBytes", v);
        }
        return JMSUtils.clone(ret);
    }

    char getChar(String key) throws JMSException {
        char ret = '\u0000';
        Object v = this.get(key);
        JMSUtils.checkNull("getChar", "java.lang.Object", v);
        if (v instanceof Character) {
            ret = ((Character)v).charValue();
        } else {
            this.badFormat("getChar", v);
        }
        return ret;
    }

    double getDouble(String key) throws JMSException {
        double ret = 0.0;
        Object v = this.get(key);
        if (v instanceof Float) {
            ret = ((Float)v).floatValue();
        } else if (v instanceof Double) {
            ret = (Double)v;
        } else if (v == null || v instanceof String) {
            ret = Double.valueOf((String)v);
        } else {
            this.badFormat("getDouble", v);
        }
        return ret;
    }

    float getFloat(String key) throws JMSException {
        float ret = 0.0f;
        Object v = this.get(key);
        if (v instanceof Float) {
            ret = ((Float)v).floatValue();
        } else if (v == null || v instanceof String) {
            ret = Float.valueOf((String)v).floatValue();
        } else {
            this.badFormat("getFloat", v);
        }
        return ret;
    }

    int getInt(String key) throws JMSException {
        int ret = 0;
        Object v = this.get(key);
        if (v instanceof Byte) {
            ret = ((Byte)v).byteValue();
        } else if (v instanceof Short) {
            ret = ((Short)v).shortValue();
        } else if (v instanceof Integer) {
            ret = (Integer)v;
        } else if (v == null || v instanceof String) {
            ret = Integer.valueOf((String)v);
        } else {
            this.badFormat("getInteger", v);
        }
        return ret;
    }

    long getLong(String key) throws JMSException {
        long ret = 0L;
        Object v = this.get(key);
        if (v instanceof Byte) {
            ret = ((Byte)v).byteValue();
        } else if (v instanceof Short) {
            ret = ((Short)v).shortValue();
        } else if (v instanceof Integer) {
            ret = ((Integer)v).intValue();
        } else if (v instanceof Long) {
            ret = (Long)v;
        } else if (v == null || v instanceof String) {
            ret = Long.valueOf((String)v);
        } else {
            this.badFormat("getLong", v);
        }
        return ret;
    }

    Object getObject(String key) throws JMSException {
        Object v = this.get(key);
        if (!(v == null || v instanceof Boolean || v instanceof Byte || v instanceof Character && !this.m_isHdr || v instanceof Double || v instanceof Float || v instanceof Integer || v instanceof Long || v instanceof Short || v instanceof String || v instanceof byte[] && !this.m_isHdr)) {
            JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-02900", this.m_msg, this.ppMethod("getObject()"), v, JMSUtils.getType(v)));
        }
        if (v instanceof byte[]) {
            v = JMSUtils.clone((byte[])v);
        }
        return v;
    }

    short getShort(String key) throws JMSException {
        short ret = 0;
        Object v = this.get(key);
        if (v instanceof Byte) {
            ret = ((Byte)v).byteValue();
        } else if (v instanceof Short) {
            ret = (Short)v;
        } else if (v == null || v instanceof String) {
            ret = Short.valueOf((String)v);
        } else {
            this.badFormat("getShort", v);
        }
        return ret;
    }

    String getString(String key) throws JMSException {
        String ret = null;
        Object v = this.get(key);
        if (v instanceof Boolean) {
            ret = ((Boolean)v).toString();
        } else if (v instanceof Byte) {
            ret = ((Byte)v).toString();
        } else if (v instanceof Character && !this.m_isHdr) {
            ret = ((Character)v).toString();
        } else if (v instanceof Double) {
            ret = ((Double)v).toString();
        } else if (v instanceof Float) {
            ret = ((Float)v).toString();
        } else if (v instanceof Integer) {
            ret = ((Integer)v).toString();
        } else if (v instanceof Long) {
            ret = ((Long)v).toString();
        } else if (v instanceof Short) {
            ret = ((Short)v).toString();
        } else if (v == null || v instanceof String) {
            ret = (String)v;
        } else {
            this.badFormat("getString", v);
        }
        return ret;
    }

    Enumeration getMapNames() throws JMSException {
        Vector keys = new Vector();
        Iterator iter = this.m_data.keySet().iterator();
        while (iter.hasNext()) {
            keys.addElement(iter.next());
        }
        return keys.elements();
    }

    boolean itemExists(String key) throws JMSException {
        return key == null ? false : this.m_data.containsKey(key);
    }

    void setBoolean(String key, boolean val) throws JMSException {
        this.setObject(key, new Boolean(val));
    }

    void setByte(String key, byte val) throws JMSException {
        this.setObject(key, new Byte(val));
    }

    void setBytes(String key, byte[] val) throws JMSException {
        this.setObject(key, JMSUtils.clone(val));
    }

    void setBytes(String key, byte[] val, int off, int len) throws JMSException {
        this.setObject(key, JMSUtils.clone(val, off, len));
    }

    void setChar(String key, char val) throws JMSException {
        this.setObject(key, new Character(val));
    }

    void setDouble(String key, double val) throws JMSException {
        this.setObject(key, new Double(val));
    }

    void setFloat(String key, float val) throws JMSException {
        this.setObject(key, new Float(val));
    }

    void setInt(String key, int val) throws JMSException {
        this.setObject(key, new Integer(val));
    }

    void setLong(String key, long val) throws JMSException {
        this.setObject(key, new Long(val));
    }

    void setObject(String key, Object val) throws JMSException {
        this.checkKey(key);
        if (val == null || val instanceof Boolean || val instanceof Byte || val instanceof Character && !this.m_isHdr || val instanceof Double || val instanceof Float || val instanceof Integer || val instanceof Long || val instanceof Short || val instanceof String || val instanceof byte[] && !this.m_isHdr) {
            this.m_data.put(key, val);
        } else {
            this.badFormat("setObject", val);
        }
    }

    void setShort(String key, short val) throws JMSException {
        this.setObject(key, new Short(val));
    }

    void setString(String key, String val) throws JMSException {
        this.setObject(key, val);
    }

    void clear() {
        this.m_data.clear();
    }

    private void badFormat(String func, Object val) throws JMSException {
        JMSUtils.badFormat(this.ppMethod(func), val);
    }

    private String ppMethod(String func) {
        return func + (this.m_isHdr ? "Property" : "");
    }

    private void checkKey(String key) throws JMSException {
        if (key == null || key.equals("")) {
            throw new IllegalArgumentException(JMSMessages.getMessage("J2EE JMS-02901", this.m_msg));
        }
        if (this.m_isHdr) {
            if (EvermindMessage.isJMSHeader(key)) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-02902", this.m_msg, key));
            }
            if (s_selKey.contains(key.toUpperCase())) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-02903", this.m_msg, key));
            }
            char[] chars = key.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if ((i != 0 || Character.isJavaIdentifierStart(chars[i])) && Character.isJavaIdentifierPart(chars[i])) continue;
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-02904", this.m_msg, key));
            }
        }
    }

    private Object get(String key) throws JMSException {
        this.checkKey(key);
        return this.m_data.get(key);
    }

    static {
        s_selKey.add("AND");
        s_selKey.add("BETWEEN");
        s_selKey.add("ESCAPE");
        s_selKey.add("FALSE");
        s_selKey.add("IN");
        s_selKey.add("IS");
        s_selKey.add("LIKE");
        s_selKey.add("NON_PERSISTENT");
        s_selKey.add("NOT");
        s_selKey.add("NULL");
        s_selKey.add("OR");
        s_selKey.add("PERSISTENT");
        s_selKey.add("TRUE");
    }
}

