/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.EvermindMessage;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSUtils;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

public final class PQContainer {
    private final TreeSet m_msgs = new TreeSet(MsgCmp.getComparator());
    private static long s_order = 0L;

    PQContainer() {
    }

    void clear() {
        this.m_msgs.clear();
    }

    void add(EvermindMessage msg) {
        if (msg.getOrder() <= 0L) {
            msg.setOrder(++s_order);
        }
        this.m_msgs.add(msg);
    }

    void remove(EvermindMessage msg) {
        this.m_msgs.remove(msg);
    }

    void remove(EvermindMessage msg, Iterator iter) {
        if (iter == null) {
            this.remove(msg);
        } else {
            iter.remove();
        }
    }

    Iterator iterator() {
        return this.m_msgs.iterator();
    }

    private static final class MsgCmp
    implements Comparator {
        private static final MsgCmp s_cmp = new MsgCmp();

        private MsgCmp() {
        }

        public static MsgCmp getComparator() {
            return s_cmp;
        }

        public int compare(Object o1, Object o2) {
            JMSUtils.checkNull("compare", "o1", o1);
            JMSUtils.checkNull("compare", "o2", o2);
            if (!(o1 instanceof EvermindMessage)) {
                throw new ClassCastException(JMSMessages.getMessage("J2EE JMS-02800", this, o1.getClass()));
            }
            if (!(o2 instanceof EvermindMessage)) {
                throw new ClassCastException(JMSMessages.getMessage("J2EE JMS-02800", this, o2.getClass()));
            }
            EvermindMessage m1 = (EvermindMessage)o1;
            EvermindMessage m2 = (EvermindMessage)o2;
            if (m1 == m2 || m1.getID().equals(m2.getID())) {
                return 0;
            }
            int pDiff = m1.getPriority() - m2.getPriority();
            if (pDiff > 0) {
                return -1;
            }
            if (pDiff < 0) {
                return 1;
            }
            long tDiff = m1.getTimestamp() - m2.getTimestamp();
            if (tDiff > 0L) {
                return 1;
            }
            if (tDiff < 0L) {
                return -1;
            }
            long oDiff = m1.getOrder() - m2.getOrder();
            return oDiff < 0L ? -1 : (oDiff == 0L ? 0 : 1);
        }
    }
}

