/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.EvermindMessage;
import com.evermind.server.jms.JMSUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jms.JMSException;
import javax.jms.TextMessage;

public final class EvermindTextMessage
extends EvermindMessage
implements TextMessage {
    private String m_data = null;
    static final long serialVersionUID = 5605349677187803930L;

    EvermindTextMessage() throws JMSException {
    }

    EvermindTextMessage(String data) throws JMSException {
        this.m_data = data;
    }

    protected final void xmlBody(PrintWriter out) {
        String pfx = "    ";
        out.println(pfx + "<textbody>");
        EvermindTextMessage.pp(out, this.m_data);
        out.println(pfx + "</textbody>");
    }

    protected final void writeBodyTo(DataOutput dout) throws IOException {
        JMSUtils.packWrite(this.m_data, dout);
    }

    protected final void readBodyFrom(DataInput dinp) throws IOException {
        this.m_data = (String)JMSUtils.packRead(dinp);
    }

    public synchronized String getText() throws JMSException {
        return this.m_data;
    }

    public synchronized void setText(String data) throws JMSException {
        this.assertWriteable();
        this.m_data = data;
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.m_data = null;
    }

    public int getTypeID() {
        return 6;
    }

    protected EvermindMessage makeSelf() throws JMSException {
        return new EvermindTextMessage();
    }

    protected synchronized void cloneBody(EvermindMessage ret) throws JMSException {
        ((EvermindTextMessage)ret).m_data = this.m_data;
    }
}

