/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.CMTBase;
import com.evermind.server.jms.CMTMessageConsumer;
import com.evermind.server.jms.CMTMessageProducer;
import com.evermind.server.jms.CMTTopicSubscriber;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.jms.XASession;

public class CMTSession
extends CMTBase
implements Session {
    private final XASession m_sess;

    CMTSession(XASession sess) {
        super(sess.getXAResource());
        this.m_sess = sess;
    }

    public XASession unwrap() {
        return this.m_sess;
    }

    public String toString() {
        return "CMTSession[" + this.m_sess + "]";
    }

    public void close() throws JMSException {
        this.m_sess.close();
    }

    public void commit() throws JMSException {
        this.m_sess.commit();
    }

    public QueueBrowser createBrowser(Queue q) throws JMSException {
        return this.m_sess.createBrowser(q);
    }

    public QueueBrowser createBrowser(Queue q, String selector) throws JMSException {
        return this.m_sess.createBrowser(q, selector);
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.m_sess.createBytesMessage();
    }

    public MessageConsumer createConsumer(Destination d) throws JMSException {
        return new CMTMessageConsumer(this, this.m_sess.createConsumer(d));
    }

    public MessageConsumer createConsumer(Destination d, String selector) throws JMSException {
        return new CMTMessageConsumer(this, this.m_sess.createConsumer(d, selector));
    }

    public MessageConsumer createConsumer(Destination d, String selector, boolean noLocal) throws JMSException {
        return new CMTMessageConsumer(this, this.m_sess.createConsumer(d, selector, noLocal));
    }

    public TopicSubscriber createDurableSubscriber(Topic t, String name) throws JMSException {
        return new CMTTopicSubscriber(this, this.m_sess.createDurableSubscriber(t, name));
    }

    public TopicSubscriber createDurableSubscriber(Topic t, String name, String selector, boolean noLocal) throws JMSException {
        return new CMTTopicSubscriber(this, this.m_sess.createDurableSubscriber(t, name, selector, noLocal));
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.m_sess.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.m_sess.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.m_sess.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable body) throws JMSException {
        return this.m_sess.createObjectMessage(body);
    }

    public MessageProducer createProducer(Destination d) throws JMSException {
        return new CMTMessageProducer(this, this.m_sess.createProducer(d));
    }

    public Queue createQueue(String qName) throws JMSException {
        return this.m_sess.createQueue(qName);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.m_sess.createStreamMessage();
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.m_sess.createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.m_sess.createTemporaryTopic();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.m_sess.createTextMessage();
    }

    public TextMessage createTextMessage(String body) throws JMSException {
        return this.m_sess.createTextMessage(body);
    }

    public Topic createTopic(String tName) throws JMSException {
        return this.m_sess.createTopic(tName);
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.m_sess.getAcknowledgeMode();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.m_sess.getMessageListener();
    }

    public boolean getTransacted() throws JMSException {
        return this.m_sess.getTransacted();
    }

    public void recover() throws JMSException {
        this.m_sess.recover();
    }

    public void rollback() throws JMSException {
        this.m_sess.rollback();
    }

    public void run() {
        this.m_sess.run();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.m_sess.setMessageListener(listener);
    }

    public void unsubscribe(String name) throws JMSException {
        this.m_sess.unsubscribe(name);
    }
}

