/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.CMTQueueSession;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;

public final class CMTQueueSender
implements QueueSender {
    private final CMTQueueSession m_sess;
    private final QueueSender m_snd;

    CMTQueueSender(CMTQueueSession sess, QueueSender snd) {
        this.m_sess = sess;
        this.m_snd = snd;
    }

    public QueueSender unwrap() {
        return this.m_snd;
    }

    public String toString() {
        return "CMTQueueSender[" + this.m_sess + "," + this.m_snd + "]";
    }

    public void close() throws JMSException {
        this.m_snd.close();
    }

    public int getDeliveryMode() throws JMSException {
        return this.m_snd.getDeliveryMode();
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.m_snd.getDisableMessageID();
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.m_snd.getDisableMessageTimestamp();
    }

    public int getPriority() throws JMSException {
        return this.m_snd.getPriority();
    }

    public Queue getQueue() throws JMSException {
        return this.m_snd.getQueue();
    }

    public long getTimeToLive() throws JMSException {
        return this.m_snd.getTimeToLive();
    }

    public Destination getDestination() throws JMSException {
        return this.m_snd.getQueue();
    }

    public synchronized void send(Queue q, Message msg) throws JMSException {
        this.m_sess.checkForCMT();
        this.m_snd.send(q, msg);
    }

    public synchronized void send(Queue q, Message msg, int deliveryMode, int priority, long ttl) throws JMSException {
        this.m_sess.checkForCMT();
        this.m_snd.send(q, msg, deliveryMode, priority, ttl);
    }

    public synchronized void send(Destination d, Message msg) throws JMSException {
        this.m_sess.checkForCMT();
        this.m_snd.send(d, msg);
    }

    public synchronized void send(Destination d, Message msg, int deliveryMode, int priority, long ttl) throws JMSException {
        this.m_sess.checkForCMT();
        this.m_snd.send(d, msg, deliveryMode, priority, ttl);
    }

    public synchronized void send(Message msg) throws JMSException {
        this.m_sess.checkForCMT();
        this.m_snd.send(msg);
    }

    public synchronized void send(Message msg, int deliveryMode, int priority, long ttl) throws JMSException {
        this.m_sess.checkForCMT();
        this.m_snd.send(msg, deliveryMode, priority, ttl);
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.m_snd.setDeliveryMode(deliveryMode);
    }

    public void setDisableMessageID(boolean noMsgID) throws JMSException {
        this.m_snd.setDisableMessageID(noMsgID);
    }

    public void setDisableMessageTimestamp(boolean noTimestamp) throws JMSException {
        this.m_snd.setDisableMessageTimestamp(noTimestamp);
    }

    public void setPriority(int priority) throws JMSException {
        this.m_snd.setPriority(priority);
    }

    public void setTimeToLive(long ttl) throws JMSException {
        this.m_snd.setTimeToLive(ttl);
    }
}

