/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.CMTQueueSession;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueReceiver;

public final class CMTQueueReceiver
implements QueueReceiver {
    private final CMTQueueSession m_sess;
    private final QueueReceiver m_rcv;

    CMTQueueReceiver(CMTQueueSession sess, QueueReceiver rcv) {
        this.m_sess = sess;
        this.m_rcv = rcv;
    }

    public QueueReceiver unwrap() {
        return this.m_rcv;
    }

    public String toString() {
        return "CMTQueueReceiver[" + this.m_sess + "," + this.m_rcv + "]";
    }

    public void close() throws JMSException {
        this.m_rcv.close();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.m_rcv.getMessageListener();
    }

    public String getMessageSelector() throws JMSException {
        return this.m_rcv.getMessageSelector();
    }

    public Queue getQueue() throws JMSException {
        return this.m_rcv.getQueue();
    }

    public synchronized Message receive() throws JMSException {
        this.m_sess.checkForCMT();
        return this.m_rcv.receive();
    }

    public synchronized Message receive(long ms) throws JMSException {
        this.m_sess.checkForCMT();
        return this.m_rcv.receive(ms);
    }

    public synchronized Message receiveNoWait() throws JMSException {
        this.m_sess.checkForCMT();
        return this.m_rcv.receiveNoWait();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.m_rcv.setMessageListener(listener);
    }
}

