/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.CMTQueueSession;
import com.evermind.server.jms.CMTSession;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAQueueConnection;

public final class CMTQueueConnection
implements QueueConnection {
    private final XAQueueConnection m_conn;

    CMTQueueConnection(XAQueueConnection conn) {
        this.m_conn = conn;
    }

    public XAQueueConnection unwrap() {
        return this.m_conn;
    }

    public String toString() {
        return "CMTQueueConnection[" + this.m_conn + "]";
    }

    public void close() throws JMSException {
        this.m_conn.close();
    }

    public ConnectionConsumer createConnectionConsumer(Destination d, String selector, ServerSessionPool pool, int maxMsgs) throws JMSException {
        return this.m_conn.createConnectionConsumer(d, selector, pool, maxMsgs);
    }

    public ConnectionConsumer createConnectionConsumer(Queue q, String selector, ServerSessionPool pool, int maxMsgs) throws JMSException {
        return this.m_conn.createConnectionConsumer(q, selector, pool, maxMsgs);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic t, String name, String selector, ServerSessionPool pool, int maxMsgs) throws JMSException {
        return this.m_conn.createDurableConnectionConsumer(t, name, selector, pool, maxMsgs);
    }

    public QueueSession createQueueSession(boolean xact, int ackMode) throws JMSException {
        return xact ? new CMTQueueSession(this.m_conn.createXAQueueSession()) : this.m_conn.createQueueSession(xact, ackMode);
    }

    public Session createSession(boolean xact, int ackMode) throws JMSException {
        return xact ? new CMTSession(this.m_conn.createXASession()) : this.m_conn.createSession(xact, ackMode);
    }

    public String getClientID() throws JMSException {
        return this.m_conn.getClientID();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.m_conn.getExceptionListener();
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.m_conn.getMetaData();
    }

    public void setClientID(String id) throws JMSException {
        this.m_conn.setClientID(id);
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.m_conn.setExceptionListener(listener);
    }

    public void start() throws JMSException {
        this.m_conn.start();
    }

    public void stop() throws JMSException {
        this.m_conn.stop();
    }
}

