/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ThreadState;
import com.evermind.server.jms.CMTTricks;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSUtils;
import javax.jms.JMSException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class CMTBase
implements CMTTricks,
XAResource {
    private final XAResource m_xar;
    private Transaction m_appTrans;
    private Xid m_currXid;

    CMTBase(XAResource xar) {
        this.m_xar = xar;
    }

    public final synchronized void delistCurrent() throws JMSException {
        try {
            if (this.m_appTrans != null) {
                this.m_appTrans.delistResource((XAResource)this, 0x2000000);
                this.m_appTrans = null;
            }
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("delistResource()", ex);
        }
    }

    public void commit(Xid xid, boolean singlePhase) throws XAException {
        this.m_xar.commit(xid, singlePhase);
    }

    public synchronized void end(Xid xid, int flags) throws XAException {
        if (this.m_currXid == xid) {
            this.m_currXid = null;
        }
        this.m_xar.end(xid, flags);
    }

    public void forget(Xid xid) throws XAException {
        this.m_xar.forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this.m_xar.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xar) throws XAException {
        if (this == xar) {
            return true;
        }
        if (xar instanceof CMTBase) {
            CMTBase txar = (CMTBase)xar;
            return this.m_xar.isSameRM(txar.m_xar);
        }
        return false;
    }

    public int prepare(Xid xid) throws XAException {
        return this.m_xar.prepare(xid);
    }

    public Xid[] recover(int flags) throws XAException {
        return this.m_xar.recover(flags);
    }

    public void rollback(Xid xid) throws XAException {
        this.m_xar.rollback(xid);
    }

    public boolean setTransactionTimeout(int val) throws XAException {
        return this.m_xar.setTransactionTimeout(val);
    }

    public synchronized void start(Xid xid, int flags) throws XAException {
        if (this.m_currXid != null) {
            JMSUtils.toXAException(JMSMessages.getMessage("J2EE JMS-01905", this, "start(" + xid + "," + flags + ")", this.m_currXid), -6);
        }
        this.m_xar.start(xid, flags);
        this.m_currXid = xid;
    }

    void checkForCMT() throws JMSException {
        try {
            ThreadState state = ThreadState.getCurrentState();
            Transaction tx = ApplicationServer.getInstance().getTransactionManager().getTransaction();
            if (state == null || tx == this.m_appTrans) {
                return;
            }
            if (this.m_currXid != null) {
                this.end(this.m_currXid, 0x2000000);
            }
            if (tx == null) {
                this.m_appTrans = null;
                this.m_currXid = null;
            } else {
                this.m_appTrans = tx;
                JMSMessages.infoDirectEnlistment();
                this.m_appTrans.enlistResource((XAResource)this);
            }
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("enlistResource()", ex);
        }
    }
}

