/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.persistence;

import com.evermind.server.http.persistence.InternalHttpSessionInterface;
import com.oracle.jgroups.TestAndWait;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.ias.container.persistence.InternalPersistenceException;

public class InternalHttpSessionObject
implements InternalHttpSessionInterface {
    String id;
    String applicationId;
    Map values = new HashMap();
    String userName;
    long creationTime;
    int ip;
    long lastAccessed;
    int maxInactiveTime;
    protected final TestAndWait stateChangeSync = new TestAndWait();

    public InternalHttpSessionObject() {
    }

    public InternalHttpSessionObject(String id, int ip, long creationTime) {
        this.id = id;
        this.ip = ip;
        this.creationTime = creationTime;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public Map getValues() {
        return this.values;
    }

    public void setValues(Map values) {
        this.values = values;
    }

    public Serializable put(Object key, Object value) throws InterruptedException {
        this.stateChangeSync.acquire();
        Serializable result = (Serializable)this.values.put(key, value);
        return result;
    }

    public Serializable get(Serializable key) throws InterruptedException {
        this.stateChangeSync.acquire();
        this.setLastAccessed(System.currentTimeMillis());
        Serializable result = (Serializable)this.values.get(key);
        return result;
    }

    public Serializable remove(Serializable key) throws InterruptedException {
        this.stateChangeSync.acquire();
        this.setLastAccessed(System.currentTimeMillis());
        Serializable result = (Serializable)this.values.remove(key);
        return result;
    }

    public Set entrySet() {
        return this.values.entrySet();
    }

    public Set keySet() {
        return this.values.keySet();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public int getIp() {
        return this.ip;
    }

    public void setIp(int ip) {
        this.ip = ip;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public void setLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    public Timestamp getTimeLastAccessed() {
        return new Timestamp(this.lastAccessed);
    }

    public void setTimeLastAccessed(Timestamp timestamp) {
        this.lastAccessed = timestamp.getTime();
    }

    public int getMaxInactiveTime() {
        return this.maxInactiveTime;
    }

    public void setMaxInactiveTime(int maxInactiveTime) {
        this.maxInactiveTime = maxInactiveTime;
    }

    public boolean isExpired(Timestamp aTime) {
        if (aTime == null) {
            throw new InternalPersistenceException("the time to compare with can not be null");
        }
        long aResultTime = aTime.getTime() - this.getLastAccessed();
        return new Timestamp(aResultTime).getNanos() > this.getMaxInactiveTime();
    }

    public InternalHttpSessionInterface refresh() {
        return null;
    }
}

