/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.deployment;

import com.evermind.server.deployment.ClassUtils;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.deployment.FilterDescriptor;
import com.evermind.server.http.deployment.HttpApplicationDescriptor;
import com.evermind.server.http.deployment.ListenerDescriptor;
import com.evermind.server.http.deployment.ServletDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.classloader.PolicyClassLoader;

public class WARAnnotationParser {
    private static final String ANNOTATION_PARSER_CLASS = "com.evermind.server.http.deployment.WARAnnotationHelper";
    private static final String PARSE_ANNOTATIONS_METHOD = "parseAnnotatedClass";
    private static Method parseAnnotationsMethod;
    private HttpApplication m_httpApp;
    private HttpApplicationDescriptor m_httpAppDesc;
    private Object m_parser;
    private List servletClasses = new ArrayList();
    private List filterClasses = new ArrayList();
    private List listenerClasses = new ArrayList();
    private static final String JDK50_MARKER_METHOD = "getDeclaredAnnotations";

    private static boolean isJDK50() {
        try {
            Class.class.getMethod(JDK50_MARKER_METHOD, null);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public WARAnnotationParser(HttpApplication httpApp) {
        this.m_httpApp = httpApp;
        this.m_httpAppDesc = (HttpApplicationDescriptor)httpApp.getConfig();
    }

    public void parseAnnotations(PolicyClassLoader clsLdr) throws InstantiationException {
        Iterator[] iterators = new Iterator[]{this.getServletClasses(clsLdr).iterator(), this.getFilterClasses(clsLdr).iterator(), this.getListenerClasses(clsLdr).iterator()};
        Iterator iter = null;
        for (int i = 0; i < iterators.length; ++i) {
            iter = iterators[i];
            while (iter.hasNext()) {
                Class cls = (Class)iter.next();
                this.parseAnnotatedClass(cls);
            }
        }
    }

    private void parseAnnotatedClass(Class cls) throws InstantiationException {
        if (!WARAnnotationParser.isJDK50()) {
            return;
        }
        Class<?> annotationParserClass = null;
        try {
            if (parseAnnotationsMethod == null) {
                annotationParserClass = Class.forName(ANNOTATION_PARSER_CLASS);
                parseAnnotationsMethod = annotationParserClass.getMethod(PARSE_ANNOTATIONS_METHOD, HttpApplicationDescriptor.class, Class.class);
            }
            if (this.m_parser == null) {
                if (annotationParserClass == null) {
                    annotationParserClass = Class.forName(ANNOTATION_PARSER_CLASS);
                }
                this.m_parser = annotationParserClass.newInstance();
            }
            parseAnnotationsMethod.invoke(this.m_parser, this.m_httpAppDesc, cls);
        }
        catch (Exception e) {
            throw (InstantiationException)new InstantiationException("Error parsing annotation for " + cls).initCause(e);
        }
    }

    private Collection getServletClasses(PolicyClassLoader clsLdr) throws InstantiationException {
        try {
            Iterator servlets = this.m_httpAppDesc.getServlets().iterator();
            while (servlets.hasNext()) {
                this.servletClasses.add(Class.forName(((ServletDescriptor)servlets.next()).getClassName(), true, (ClassLoader)clsLdr));
            }
        }
        catch (ClassNotFoundException e) {
            throw (InstantiationException)new InstantiationException("Error instantiate servlet classes").initCause(e);
        }
        return this.servletClasses;
    }

    private Collection getFilterClasses(PolicyClassLoader clsLdr) throws InstantiationException {
        try {
            Iterator filters = this.m_httpAppDesc.getFilters().iterator();
            while (filters.hasNext()) {
                this.filterClasses.add(Class.forName(((FilterDescriptor)filters.next()).getClassName(), true, (ClassLoader)clsLdr));
            }
        }
        catch (ClassNotFoundException e) {
            throw (InstantiationException)new InstantiationException("Error instantiate filter classes").initCause(e);
        }
        return this.filterClasses;
    }

    private Collection getListenerClasses(PolicyClassLoader clsLdr) throws InstantiationException {
        try {
            Iterator listeners = this.m_httpAppDesc.getListeners().iterator();
            while (listeners.hasNext()) {
                this.listenerClasses.add(Class.forName(((ListenerDescriptor)listeners.next()).getClassName(), true, (ClassLoader)clsLdr));
            }
            if (this.m_httpApp.getJspTldListenerDescriptors() != null) {
                listeners = this.m_httpApp.getJspTldListenerDescriptors().iterator();
                while (listeners.hasNext()) {
                    this.listenerClasses.add(Class.forName(((ListenerDescriptor)listeners.next()).getClassName(), true, (ClassLoader)clsLdr));
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw (InstantiationException)new InstantiationException("Error instantiate listener classes").initCause(e);
        }
        return this.listenerClasses;
    }

    public static void setPreDestroyMethod(HttpApplicationDescriptor desc, Method method, Class baseCls) throws InstantiationException {
        WARAnnotationParser.verifyLifecycleMethodTypes(baseCls, method);
        Method previous = null;
        if (ClassUtils.isMethodOverridden(baseCls, method)) {
            return;
        }
        ServletDescriptor servletDesc = desc.getServletDescriptor(baseCls);
        if (servletDesc != null) {
            previous = servletDesc.getPreDestroyMethod();
            if (previous != null && !previous.getName().equals(method.getName())) {
                throw new InstantiationException("Only one pre-destory method is allowed in " + baseCls);
            }
            if (previous != null) {
                if (WARAnnotationParser.isSubclass(method.getDeclaringClass(), previous.getDeclaringClass())) {
                    servletDesc.setPreDestroyMethod(method);
                }
                return;
            }
            servletDesc.setPreDestroyMethod(method);
            return;
        }
        FilterDescriptor filterDesc = desc.getFilterDescriptor(baseCls);
        if (filterDesc != null) {
            previous = filterDesc.getPreDestroyMethod();
            if (previous != null && !previous.getName().equals(method.getName())) {
                throw new InstantiationException("Only one pre-destroy method is allowed in " + baseCls);
            }
            if (previous != null) {
                if (WARAnnotationParser.isSubclass(method.getDeclaringClass(), previous.getDeclaringClass())) {
                    servletDesc.setPreDestroyMethod(method);
                }
                return;
            }
            filterDesc.setPreDestroyMethod(method);
            return;
        }
        ListenerDescriptor listenerDesc = desc.getListenerDescriptor(baseCls);
        if (listenerDesc != null) {
            previous = listenerDesc.getPreDestroyMethod();
            if (previous != null && !previous.getName().equals(method.getName())) {
                throw new InstantiationException("Only one pre-destroy method is allowed in " + baseCls);
            }
            if (previous != null) {
                if (WARAnnotationParser.isSubclass(method.getDeclaringClass(), previous.getDeclaringClass())) {
                    servletDesc.setPreDestroyMethod(method);
                }
                return;
            }
            listenerDesc.setPreDestroyMethod(method);
            return;
        }
        throw new InstantiationException("pre-destroy method must be defined in container management class :" + baseCls + " " + method);
    }

    public static void setPostConstructMethod(HttpApplicationDescriptor desc, Method method, Class baseCls) throws InstantiationException {
        WARAnnotationParser.verifyLifecycleMethodTypes(baseCls, method);
        Method previous = null;
        if (ClassUtils.isMethodOverridden(baseCls, method)) {
            return;
        }
        ServletDescriptor servletDesc = desc.getServletDescriptor(baseCls);
        if (servletDesc != null) {
            previous = servletDesc.getPostConstructMethod();
            if (previous != null && !previous.getName().equals(method.getName())) {
                throw new InstantiationException("Only one post-construct method is allowed in " + baseCls);
            }
            if (previous != null) {
                if (WARAnnotationParser.isSubclass(method.getDeclaringClass(), previous.getDeclaringClass())) {
                    servletDesc.setPostConstructMethod(method);
                }
                return;
            }
            servletDesc.setPostConstructMethod(method);
            return;
        }
        FilterDescriptor filterDesc = desc.getFilterDescriptor(baseCls);
        if (filterDesc != null) {
            previous = filterDesc.getPostConstructMethod();
            if (previous != null && !previous.getName().equals(method.getName())) {
                throw new InstantiationException("Only one post-construct method is allowed in " + baseCls);
            }
            if (previous != null) {
                if (WARAnnotationParser.isSubclass(method.getDeclaringClass(), previous.getDeclaringClass())) {
                    servletDesc.setPostConstructMethod(method);
                }
                return;
            }
            filterDesc.setPostConstructMethod(method);
            return;
        }
        ListenerDescriptor listenerDesc = desc.getListenerDescriptor(baseCls);
        if (listenerDesc != null) {
            previous = listenerDesc.getPostConstructMethod();
            if (previous != null && !previous.getName().equals(method.getName())) {
                throw new InstantiationException("Only one post-construct method is allowed in " + baseCls);
            }
            if (previous != null) {
                if (WARAnnotationParser.isSubclass(method.getDeclaringClass(), previous.getDeclaringClass())) {
                    servletDesc.setPostConstructMethod(method);
                }
                return;
            }
            listenerDesc.setPostConstructMethod(method);
            return;
        }
        throw new InstantiationException("post-construct method must be defined in container management class :" + baseCls + " " + method);
    }

    static void verifyLifecycleMethodTypes(Class baseCls, Method method) throws InstantiationException {
        if (method.getReturnType() != Void.TYPE) {
            throw new InstantiationException("Return type of life cycle method must be void: " + baseCls + " " + method);
        }
        if (method.getParameterTypes().length != 0) {
            throw new InstantiationException("Lifecycle method must not have parameters: " + baseCls + " " + method);
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw new InstantiationException("Lifecycle method must not be static: " + baseCls + " " + method);
        }
        Class<?>[] exceptions = method.getExceptionTypes();
        Class<?> runtimeExceptionCls = null;
        Class<?> exceptionCls = null;
        if (exceptions.length > 0) {
            try {
                runtimeExceptionCls = baseCls.getClassLoader().loadClass("java.lang.RuntimeException");
                exceptionCls = baseCls.getClassLoader().loadClass("java.lang.Exception");
            }
            catch (ClassNotFoundException e) {
                throw (InstantiationException)new InstantiationException("Unable to load excetpion class").initCause(e);
            }
        }
        for (int i = 0; i < exceptions.length; ++i) {
            if (WARAnnotationParser.isSubclass(exceptions[i], runtimeExceptionCls) || !WARAnnotationParser.isSubclass(exceptions[i], exceptionCls)) continue;
            throw new InstantiationException("Lifecycle method must not throw checked exception: " + baseCls + " " + method);
        }
    }

    static boolean isSubclass(Class a, Class b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        for (Class x = a; x != null; x = x.getSuperclass()) {
            if (x == b) {
                return true;
            }
            if (!b.isInterface()) continue;
            Class<?>[] interfaces = x.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!WARAnnotationParser.isSubclass(interfaces[i], b)) continue;
                return true;
            }
        }
        return false;
    }
}

