/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.deployment;

import com.evermind.server.deployment.AbstractSecurityConstraint;
import com.evermind.server.http.deployment.HttpApplicationDescriptor;
import com.evermind.server.http.deployment.ResourceCollection;
import com.evermind.util.ServerProperties;
import com.evermind.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityConstraint
extends AbstractSecurityConstraint {
    protected transient HttpApplicationDescriptor application;
    protected String userdataConstraintDescription;
    protected List resourceCollections = new ArrayList();
    protected String authConstraintDescription;
    protected String displayName;

    public SecurityConstraint(HttpApplicationDescriptor application) {
        this.application = application;
    }

    public SecurityConstraint(HttpApplicationDescriptor application, Node parent) throws InstantiationException {
        if (application == null) {
            throw new InternalError("application was null");
        }
        this.application = application;
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("#text")) continue;
            if (name.equals("display-name")) {
                this.setDisplayName(XMLUtils.getStringValue(node));
                continue;
            }
            if (name.equals("web-resource-collection")) {
                this.addResourceCollection(new ResourceCollection(node));
                continue;
            }
            if (name.equals("auth-constraint")) {
                this.parseAuthorizationConstraint(node);
                continue;
            }
            if (!name.equals("user-data-constraint")) continue;
            if (ServerProperties.getOracleCtsUseCtsFlags() && this.resourceCollections.isEmpty()) {
                throw new InstantiationException("security-constraint subelement is not defined in correct order: user-data-constraint");
            }
            this.parseUserdataConstraint(node);
        }
    }

    public void parseUserdataConstraint(Node node) throws InstantiationException {
        this.userdataConstraintDescription = XMLUtils.getSubnodeValue(node, "description");
        String value = XMLUtils.getSubnodeValue(node, "transport-guarantee");
        if (value == null) {
            throw new InstantiationException("user-data-constraint tag with missing transport-guarantee subtag");
        }
        this.setTransportGuarantee(value);
    }

    public List getResourceCollections() {
        return this.resourceCollections;
    }

    public void setResourceCollections(List collections) {
        this.resourceCollections = collections;
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<security-constraint>");
        if (this.getDisplayName() != null) {
            out.println(indention + "\t<display-name>" + XMLUtils.encode(this.getDisplayName()) + "</display-name>");
        }
        XMLUtils.writeAll(this.resourceCollections, out, indention + "\t");
        if (this.hasAuthorizationConstraint()) {
            out.println(indention + "\t<auth-constraint>");
            if (this.getAuthorizationConstraintDescription() != null) {
                out.println(indention + "\t\t<description>" + XMLUtils.encode(this.getAuthorizationConstraintDescription()) + "</description>");
            }
            if (this.roleNames != null) {
                XMLUtils.writeStrings(this.roleNames, "role-name", out, indention + "\t\t");
            }
            out.println(indention + "\t</auth-constraint>");
        }
        if (this.transportGuarantee != 0 || this.userdataConstraintDescription != null && !this.userdataConstraintDescription.equals("")) {
            out.println(indention + "\t<user-data-constraint>");
            if (this.userdataConstraintDescription != null && !this.userdataConstraintDescription.equals("")) {
                out.println(indention + "\t\t<description>" + XMLUtils.encode(this.userdataConstraintDescription) + "</description>");
            }
            out.print(indention + "\t\t<transport-guarantee>");
            switch (this.transportGuarantee) {
                case 2: {
                    out.print("INTEGRAL");
                    break;
                }
                case 1: {
                    out.print("CONFIDENTIAL");
                    break;
                }
                default: {
                    out.print("NONE");
                }
            }
            out.println("</transport-guarantee>");
            out.println(indention + "\t</user-data-constraint>");
        }
        out.println(indention + "</security-constraint>");
    }

    public String getUserdataConstraintDescription() {
        return this.userdataConstraintDescription;
    }

    public void setUserdataConstraintDescription(String description) {
        this.userdataConstraintDescription = description;
    }

    public void addResourceCollection(ResourceCollection collection) {
        this.resourceCollections.add(collection);
        this.firePropertyChangeEvent("resourceCollections", null, collection);
    }

    public void removeResourceCollection(int pos) {
        ResourceCollection collection = (ResourceCollection)this.resourceCollections.remove(pos);
        this.firePropertyChangeEvent("resourceCollections", collection, null);
    }

    public HttpApplicationDescriptor getApplication() {
        return this.application;
    }

    public boolean hasAuthorizationConstraint() {
        return this.roleNames != null;
    }

    public void setHasAuthorizationConstraint(boolean has) {
        if (has) {
            if (this.roleNames == null) {
                this.roleNames = new ArrayList();
            }
        } else {
            this.roleNames = null;
        }
    }

    public void parseAuthorizationConstraint(Node node) {
        this.roleNames = new ArrayList();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String name = nodes.item(i).getNodeName();
            if (name.equals("#text")) continue;
            if (name.equals("description")) {
                this.setAuthorizationConstraintDescription(XMLUtils.getStringValue(nodes.item(i)));
                continue;
            }
            if (!name.equals("role-name")) continue;
            this.roleNames.add(XMLUtils.getStringValue(nodes.item(i)));
        }
    }

    public void setAuthorizationConstraintDescription(String description) {
        this.authConstraintDescription = description;
    }

    public String getAuthorizationConstraintDescription() {
        return this.authConstraintDescription;
    }

    public String getAuthConstraintDesc() {
        return this.authConstraintDescription;
    }

    public void setAuthConstraintDesc(String desc) {
        this.authConstraintDescription = desc;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("security-constraint: ");
        buf.append("\n");
        buf.append("  display-name: ");
        buf.append(this.getDisplayName());
        buf.append("\n");
        buf.append("  web-resource-collection: ");
        buf.append(this.getResourceCollections());
        buf.append("\n");
        buf.append("  auth-constraint-desc: ");
        buf.append(this.getAuthConstraintDesc());
        buf.append("\n");
        buf.append("  auth-constrant-role-names: ");
        buf.append(this.getRoleNames());
        buf.append("\n");
        buf.append("  transport-guarantee: ");
        buf.append(this.getTransportGuaranteeString());
        buf.append("\n");
        buf.append(" user-data-constraint-desc: ");
        buf.append(this.getUserdataConstraintDescription());
        buf.append("\n");
        return buf.toString();
    }
}

