/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.deployment;

import com.evermind.server.http.deployment.HttpApplicationDescriptor;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.j2ee.deployment.DeploymentMessages;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class OjspInitDescriptor
implements XMLizable {
    HttpApplicationDescriptor config;
    private String jsr45Debug;
    private String reduceTagCode;
    private String reqTimeIntrospection;
    private String staticTextInChars;
    private String tagsReuse;
    private String debugMode;
    private String precompileCheck;
    private String mainMode;
    private Hashtable h = new Hashtable();

    public OjspInitDescriptor(HttpApplicationDescriptor config) {
        this.config = config;
    }

    public OjspInitDescriptor(HttpApplicationDescriptor config, Node node) {
        this(config);
        this.parseOjspInitConfig(node);
    }

    private void parseOjspInitConfig(Node node) {
        NamedNodeMap map = node.getAttributes();
        int length = map.getLength();
        for (int i = 0; i < length; ++i) {
            Node item = map.item(i);
            String name = item.getNodeName();
            String value = item.getNodeValue();
            value = value == null ? "" : value.trim();
            if (name.equals("jsr45-debug")) {
                this.jsr45Debug = value;
                this.h.put("jsr45-debug", value);
                continue;
            }
            if (name.equals("main-mode")) {
                this.mainMode = value;
                this.h.put("main-mode", value);
                continue;
            }
            if (name.equals("precompile-check")) {
                this.precompileCheck = value;
                this.h.put("precompile-check", value);
                continue;
            }
            if (name.equals("reduce-tag-code")) {
                this.reduceTagCode = value;
                this.h.put("reduce-tag-code", value);
                continue;
            }
            if (name.equals("req-time-introspection")) {
                this.reqTimeIntrospection = value;
                this.h.put("req-time-introspection", value);
                continue;
            }
            if (name.equals("debug-mode")) {
                this.debugMode = value;
                this.h.put("debug-mode", value);
                continue;
            }
            if (name.equals("static-text-in-chars")) {
                this.staticTextInChars = value;
                this.h.put("static-text-in-chars", value);
                continue;
            }
            if (name.equals("tags-reuse")) {
                this.tagsReuse = value;
                this.h.put("tags-reuse", value);
                continue;
            }
            DeploymentMessages.warningInvalidOjspInitAttrName(new Object[]{name, this.config.getName()});
        }
    }

    public String getDebugMode() {
        return this.debugMode;
    }

    public String getJsr45Debug() {
        return this.jsr45Debug;
    }

    public String getMainMode() {
        return this.mainMode;
    }

    public String getPrecompileCheck() {
        return this.precompileCheck;
    }

    public String getReduceTagCode() {
        return this.reduceTagCode;
    }

    public String getReqTimeIntrospection() {
        return this.reqTimeIntrospection;
    }

    public String getStaticTextInChars() {
        return this.staticTextInChars;
    }

    public String getTagsReuse() {
        return this.tagsReuse;
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        if (this.h.isEmpty()) {
            out.println(indention + "<ojsp-init />");
        } else {
            out.println(indention + "<ojsp-init");
            Enumeration keys = this.h.keys();
            while (keys.hasMoreElements()) {
                String name = (String)keys.nextElement();
                out.println(indention + "   " + name + "=\"" + this.h.get(name) + "\"");
            }
            out.println(indention + "/>");
        }
    }
}

