/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.compilation;

import com.evermind.compiler.CompilationException;
import com.evermind.compiler.CompiledObject;
import com.evermind.naming.ContextUtils;
import com.evermind.naming.archive.MemoryArchiveContext;
import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import com.evermind.server.J2EEComponent;
import com.evermind.server.ServerComponent;
import com.evermind.server.compilation.AbstractCompilation;
import com.evermind.util.ConfigUtils;
import com.evermind.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import oracle.j2ee.util.TraceLogger;
import oracle.j2ee.ws.server.codegen.WebServiceArtifactGen;
import oracle.j2ee.ws.server.deployment.ServiceReferenceContainer;
import oracle.j2ee.ws.server.deployment.oc4j.WebServicesDescriptorHolder;

public class Compilation
extends AbstractCompilation {
    public Application application;
    protected Properties deploymentProperties = new Properties();
    private J2EEComponent component;
    private Context wrapperClassContext;
    List compilations = new ArrayList();
    private String applicationClasspath = "";
    private static Logger m_traceLogger = TraceLogger.getLogger(Compilation.class);

    public Compilation(Application application, ServerComponent webBundle, String classpath, ClassLoader cl) throws InstantiationException {
        this.init(application, webBundle, classpath, cl);
    }

    public Compilation(Application application, J2EEComponent webBundle) throws InstantiationException {
        this.init(application, webBundle, application.getClasspath(), null);
    }

    public void init(Application application, J2EEComponent webBundle, String classpath, ClassLoader cl) throws InstantiationException {
        this.classpath = classpath;
        this.parent = cl;
        this.application = application;
        this.component = webBundle;
        this.context = webBundle.getContext();
        this.deploymentContext = webBundle.getDeploymentContext();
        this.compiler = application.getServer().getCompiler();
    }

    public void compile() throws CompilationException {
        this.setClasspath();
        this.generateWebServices();
        this.generateWebServiceRefs();
        this.compileClasses();
        this.postCompilationCleanup();
    }

    public void compileServiceRefs() throws CompilationException {
        this.setClasspath();
        this.generateWebServiceRefs();
        this.compileClasses();
        this.postCompilationCleanup();
    }

    private void setClasspath() {
        if (this.parent != null) {
            return;
        }
        try {
            Context classesContext = (Context)this.component.getContext().lookup("WEB-INF/classes");
            URL[] urls = new URL[]{ContextUtils.getURL(classesContext, false)};
            this.applicationClasspath = ConfigUtils.getClasspath(urls);
        }
        catch (NamingException e) {
        }
        catch (ClassCastException e) {
        }
        catch (IOException e) {
            m_traceLogger.log(Level.FINEST, "warn: ws deployment" + e.getMessage(), e);
        }
        try {
            Context libContext = (Context)this.component.getContext().lookup("WEB-INF/lib");
            URL url = ContextUtils.getURL(libContext, false);
            List urls = FileUtils.getURLList(new File(url.getFile()));
            URL[] urlAs = urls.toArray(new URL[0]);
            this.applicationClasspath = this.applicationClasspath + ConfigUtils.getClasspath(urlAs);
        }
        catch (NamingException e) {
        }
        catch (ClassCastException e) {
        }
        catch (IOException e) {
            m_traceLogger.log(Level.FINEST, "warn: ws deployment" + e.getMessage(), e);
        }
        this.applicationClasspath = this.applicationClasspath + ContextUtils.getFile(this.component.getContext(), false).getAbsolutePath();
        this.classpath = this.classpath != null && !this.classpath.endsWith(File.pathSeparator) ? this.classpath + File.pathSeparator + this.applicationClasspath : this.classpath + this.applicationClasspath;
        if (this.classpath.endsWith(File.pathSeparator)) {
            this.classpath = this.classpath.substring(0, this.classpath.length() - 1);
        }
    }

    private void postCompilationCleanup() {
        if (this.classes != null) {
            this.classes.clear();
        }
        if (this.defaultAllowedRoleNames != null) {
            this.defaultAllowedRoleNames.clear();
        }
        if (this.callerVariables != null) {
            this.callerVariables.clear();
        }
        if (this.deploymentProperties != null) {
            this.deploymentProperties.clear();
        }
        if (this.compiler != null) {
            this.compiler.reset();
        }
        if (this.compilations != null) {
            this.compilations.clear();
        }
    }

    public String getCallerVariable(List users, String currentVar) {
        String newVar;
        if (this.callerVariables != null && (newVar = (String)this.callerVariables.get(users)) != null) {
            return newVar;
        }
        if (this.callerVariables == null) {
            this.callerVariables = new HashMap();
        }
        this.callerVariables.put(users, currentVar);
        return currentVar;
    }

    public void compileClasses() throws CompilationException {
        if (this.classes.isEmpty()) {
            return;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("classpath", this.classpath);
        properties.put("classLoader", this.parent);
        File file = ContextUtils.getFile(this.deploymentContext, false);
        if (file != null) {
            properties.put("target.directory", file.getPath());
            properties.put("source.directory", file.getPath());
        }
        ApplicationServer appServer = this.application.getServer();
        try {
            if (this.compiler.needsSecurityManager()) {
                appServer.addSecurityLayer();
            }
            Context deploymentContext = this.getWrapperClassContext();
            properties.put("targetContext", deploymentContext);
            if (deploymentContext instanceof MemoryArchiveContext) {
                ((MemoryArchiveContext)deploymentContext).clear();
            } else {
                try {
                    NamingEnumeration<NameClassPair> enumeration = deploymentContext.list("");
                    while (enumeration.hasMore()) {
                        NameClassPair pair = enumeration.next();
                        if (!pair.getName().endsWith(".class") && !pair.getName().endsWith(".java") || pair.getName().indexOf("OR") < 0 && pair.getName().indexOf("Wrapper") < 0 && pair.getName().indexOf("PersistenceManager") < 0 && pair.getName().indexOf("PM") < 0 && pair.getName().indexOf("Stub") < 0 && pair.getName().indexOf("Tie") < 0) continue;
                        deploymentContext.unbind(pair.getName());
                    }
                }
                catch (NamingException e) {
                    m_traceLogger.log(Level.FINE, "Error deleting old class files: " + e.getMessage(), e);
                }
            }
            if (deploymentContext instanceof MemoryArchiveContext) {
                ((MemoryArchiveContext)deploymentContext).setData(new byte[0], 0, 0);
            }
            ArrayList cleanClasses = new ArrayList(new HashSet(this.classes));
            Collection binaries = this.compiler.compile(cleanClasses, properties);
            this.compiler.reset();
            Iterator binariesIterator = binaries.iterator();
            while (binariesIterator.hasNext()) {
                CompiledObject binary = (CompiledObject)binariesIterator.next();
                try {
                    deploymentContext.rebind(binary.getName().replace('.', '/') + ".class", (Object)binary.getData());
                    binary.clean();
                }
                catch (IOException e) {
                    throw new CompilationException("Error reading wrapper class: " + e.getMessage());
                }
                catch (NamingException e) {
                    throw new CompilationException("Error writing wrapper class: " + e.getMessage());
                }
            }
            try {
                ContextUtils.flush(deploymentContext);
            }
            catch (IOException e) {
                throw new InstantiationException("IO error writing cache: " + e.getMessage());
            }
        }
        catch (InstantiationException e) {
            throw new CompilationException("Error instantiating compiler: " + e.getMessage());
        }
        finally {
            if (this.compiler.needsSecurityManager()) {
                appServer.removeSecurityLayer();
            }
        }
    }

    private void generateWebServices() throws CompilationException {
        ServerComponent sc = (ServerComponent)((Object)((WebServicesDescriptorHolder)((Object)this.component)).getWebServicesDescriptor());
        if (sc == null) {
            return;
        }
        try {
            File file = ContextUtils.getFile(this.deploymentContext, false);
            Class<?> generatorC = Class.forName("oracle.j2ee.ws.server.codegen.ServerArtifactGenerator");
            WebServiceArtifactGen generator = (WebServiceArtifactGen)generatorC.newInstance();
            generator.setDestnRootDir(file);
            generator.generateCompilables(sc, this.applicationClasspath, this.parent);
            this.classes.addAll(generator.getCompilables());
        }
        catch (IOException e) {
            CompilationException ce = new CompilationException("IO/Compilation error: " + e.getMessage());
            ce.initCause(e);
            throw ce;
        }
        catch (InstantiationException e) {
            CompilationException ce = new CompilationException("Error instantiating compiler: " + e.getMessage());
            ce.initCause(e);
            throw ce;
        }
        catch (Exception e) {
            CompilationException ce = new CompilationException(e.getMessage());
            ce.initCause(e);
            throw ce;
        }
    }

    private void generateWebServiceRefs() throws CompilationException {
        if (!(this.component instanceof ServiceReferenceContainer) || ((ServiceReferenceContainer)((Object)this.component)).getServiceReferences().isEmpty()) {
            return;
        }
        try {
            File file = ContextUtils.getFile(this.deploymentContext, false);
            Class<?> generatorC = Class.forName("oracle.j2ee.ws.server.codegen.ServerArtifactGenerator");
            WebServiceArtifactGen generator = (WebServiceArtifactGen)generatorC.newInstance();
            generator.setDestnRootDir(file);
            generator.generateCompilables((ServiceReferenceContainer)((Object)this.component), this.applicationClasspath, this.component, this.parent);
            this.classes.addAll(generator.getCompilables());
        }
        catch (InstantiationException e) {
            CompilationException ce = new CompilationException("Error instantiating compiler: " + e.getMessage());
            ce.initCause(e);
            throw ce;
        }
        catch (Exception e) {
            CompilationException ce = new CompilationException(e.getMessage());
            ce.initCause(e);
            throw ce;
        }
    }

    public void setDefaultAllowedRoleNames(List names) {
        this.defaultAllowedRoleNames = names;
    }

    public List getDefaultAllowedRoleNames() {
        return this.defaultAllowedRoleNames;
    }

    private String getDeploymentCacheName() throws InstantiationException {
        return this.component.getDeploymentCacheName();
    }

    public Context getWrapperClassContext() throws InstantiationException {
        if (this.wrapperClassContext == null) {
            try {
                byte[] data;
                try {
                    data = (byte[])this.deploymentContext.lookup(this.getDeploymentCacheName());
                }
                catch (NameNotFoundException e) {
                    data = new byte[]{};
                    this.deploymentContext.bind(this.getDeploymentCacheName(), (Object)data);
                }
                catch (ClassCastException e) {
                    data = new byte[]{};
                    this.deploymentContext.bind(this.getDeploymentCacheName(), (Object)data);
                }
                this.wrapperClassContext = new MemoryArchiveContext(this.deploymentContext, this.getDeploymentCacheName(), data, 0, data.length, false);
            }
            catch (NamingException e) {
                throw new InstantiationException("Unable to read deployment directory: " + e.getMessage());
            }
            catch (IOException e) {
                throw new InstantiationException("Unable to read deployment directory: " + e.getMessage());
            }
        }
        return this.wrapperClassContext;
    }
}

