/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.naming.ContextUtils;
import com.evermind.server.http.TagLibraryInfoImplBase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import javax.naming.Context;
import oracle.j2ee.util.SetContextClassLoaderAction;

public class TagLibraryArchive
extends TagLibraryInfoImplBase {
    private static final Object lock = new Object();
    public static InputStream currentIn;
    private ClassLoader parent;
    private ClassLoader loader;
    private File file;
    private File rootFile;
    private long lastModified;
    public Context context;

    private TagLibraryArchive(String prefix, String uri) {
        super(prefix, uri);
    }

    protected String getAndSet(String prefix, URL uri) {
        return prefix;
    }

    public boolean isUpdated() {
        if (this.lastModified < 1L) {
            return false;
        }
        if (this.file != null) {
            return this.lastModified != this.file.lastModified();
        }
        return this.lastModified != this.rootFile.lastModified();
    }

    public File getFile() {
        return this.file;
    }

    public File getRootFile() {
        if (this.rootFile == null) {
            if (this.context == null) {
                return null;
            }
            this.rootFile = ContextUtils.getFile(this.context, true);
        }
        return this.rootFile;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TagLibraryArchive getArchive(long lastModified, File file, ClassLoader parent, File rootFile, String prefix, String url, InputStream in, ClassLoader loader) throws IOException, InstantiationException {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Object object = lock;
        synchronized (object) {
            currentIn = in;
            try {
                AccessController.doPrivileged(new SetContextClassLoaderAction(Thread.currentThread(), loader));
                TagLibraryArchive archive = new TagLibraryArchive(prefix, url);
                archive.rootFile = rootFile;
                archive.parent = parent;
                archive.file = file;
                archive.loader = loader;
                archive.lastModified = lastModified;
                TagLibraryArchive tagLibraryArchive = archive;
                return tagLibraryArchive;
            }
            catch (IllegalArgumentException e) {
                throw new InstantiationException(e.getMessage());
            }
            finally {
                AccessController.doPrivileged(new SetContextClassLoaderAction(Thread.currentThread(), oldLoader));
            }
        }
    }
}

