/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.EvermindHttpServletResponse;
import com.evermind.server.http.HttpDateFormat;
import com.evermind.server.http.RequestLogger;
import com.evermind.util.ArrayUtils;
import com.evermind.util.Logger;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

class StandardRequestLogger
implements RequestLogger {
    OutputStream out;
    final byte[] buffer = new byte[6000];
    int pos;
    private static final byte[] DEFAULT_STATUS_LINE = "\" 200 ".getBytes();
    private static final byte[] NOT_MODIFIED_STATUS_LINE = "\" 304 ".getBytes();
    private static final String[] MONTH_NAME = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private boolean autoFlush;
    private byte[] dateArray = new byte[39];
    private long currentTimeMillis;
    private GregorianCalendar calendar = new GregorianCalendar();
    private TimeZone timeZone = this.calendar.getTimeZone();

    public StandardRequestLogger() {
        this.dateArray[0] = 32;
        this.dateArray[1] = 45;
        this.dateArray[2] = 32;
        this.dateArray[3] = 45;
        this.dateArray[4] = 32;
        this.dateArray[5] = 91;
        this.dateArray[36] = 93;
        this.dateArray[37] = 32;
        this.dateArray[38] = 34;
    }

    public StandardRequestLogger(OutputStream out, boolean autoFlush) {
        this();
        this.autoFlush = autoFlush;
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(EvermindHttpServletRequest request, EvermindHttpServletResponse response) throws IOException {
        byte[] _buffer = new byte[512];
        int _pos = 0;
        _pos = this.appendIP(_buffer, _pos, request.clientInetAddress);
        byte[] byArray = this.dateArray;
        synchronized (this.dateArray) {
            if (this.currentTimeMillis != HttpDateFormat.currentTimeLong) {
                this.currentTimeMillis = this.appendTime(this.dateArray, 6, HttpDateFormat.currentTimeLong);
            }
            System.arraycopy(this.dateArray, 0, _buffer, _pos, 39);
            _pos += 39;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (request.headerLineLength != request.headerLineRealLength) {
                byte[] input = request.getInput();
                System.arraycopy(input, request.headerStartPos, _buffer, _pos, request.headerLineRealLength - 9);
                System.arraycopy(input, request.headerStartPos + request.headerLineLength - 9, _buffer, (_pos += request.headerLineRealLength) - 9, 9);
                if (_buffer[_pos - 1] < 16) {
                    _pos -= 2;
                }
            } else {
                int y = request.headerLineLength;
                byte[] input = request.getInput();
                if (request.method != "GET" && request.method != "POST" && request.method != "DELETE" && request.method != "CONNECT" && request.method != "HEAD" && request.method != "OPTIONS" && request.method != "PUT" && request.method != "TRACE") {
                    int n = y = request.headerLineLength <= 80 ? request.headerLineLength : 80;
                }
                if (_pos + y > 496) {
                    byte[] _newBuffer = new byte[_pos + y + 16];
                    System.arraycopy(_buffer, 0, _newBuffer, 0, _pos);
                    System.arraycopy(input, request.headerStartPos, _newBuffer, _pos, y);
                    _pos += y;
                    _buffer = _newBuffer;
                } else {
                    System.arraycopy(input, request.headerStartPos, _buffer, _pos, y);
                    _pos += y;
                }
                if (_buffer[_pos - 1] < 16) {
                    _pos -= 2;
                }
            }
            if (response.status == 0 || response.status == 200) {
                System.arraycopy(DEFAULT_STATUS_LINE, 0, _buffer, _pos, DEFAULT_STATUS_LINE.length);
                _pos += DEFAULT_STATUS_LINE.length;
            } else if (response.status == 304) {
                System.arraycopy(NOT_MODIFIED_STATUS_LINE, 0, _buffer, _pos, NOT_MODIFIED_STATUS_LINE.length);
                _pos += NOT_MODIFIED_STATUS_LINE.length;
            } else {
                _buffer[_pos++] = 34;
                _buffer[_pos++] = 32;
                _pos = ArrayUtils.writeInt(_buffer, _pos, response.status);
                _buffer[_pos++] = 32;
            }
            _pos = ArrayUtils.writeInt(_buffer, _pos, response.out.bytesWritten);
            _buffer[_pos++] = 10;
            this.writeLog(_buffer, _pos);
            return;
        }
    }

    public synchronized void writeLog(byte[] buffer, int pos) throws IOException {
        System.arraycopy(buffer, 0, this.buffer, this.pos, pos);
        this.pos += pos;
        if (this.pos > 3800 || this.autoFlush) {
            this.out.write(this.buffer, 0, this.pos);
            this.pos = 0;
        }
    }

    public synchronized void flush() {
        if (this.pos > 0) {
            try {
                if (this.out != null) {
                    this.out.write(this.buffer, 0, this.pos);
                }
                this.pos = 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected final int appendIP(byte[] buffer, int pos, InetAddress address) {
        byte[] ip = address.getAddress();
        int ipPart = (char)ip[0] & 0xFF;
        if (ipPart >= 100) {
            buffer[pos++] = (byte)(ipPart / 100 + 48);
        }
        if (ipPart >= 10) {
            buffer[pos++] = (byte)(ipPart / 10 % 10 + 48);
        }
        buffer[pos++] = (byte)(ipPart % 10 + 48);
        buffer[pos++] = 46;
        ipPart = (char)ip[1] & 0xFF;
        if (ipPart >= 100) {
            buffer[pos++] = (byte)(ipPart / 100 + 48);
        }
        if (ipPart >= 10) {
            buffer[pos++] = (byte)(ipPart / 10 % 10 + 48);
        }
        buffer[pos++] = (byte)(ipPart % 10 + 48);
        buffer[pos++] = 46;
        ipPart = (char)ip[2] & 0xFF;
        if (ipPart >= 100) {
            buffer[pos++] = (byte)(ipPart / 100 + 48);
        }
        if (ipPart >= 10) {
            buffer[pos++] = (byte)(ipPart / 10 % 10 + 48);
        }
        buffer[pos++] = (byte)(ipPart % 10 + 48);
        buffer[pos++] = 46;
        ipPart = (char)ip[3] & 0xFF;
        if (ipPart >= 100) {
            buffer[pos++] = (byte)(ipPart / 100 + 48);
        }
        if (ipPart >= 10) {
            buffer[pos++] = (byte)(ipPart / 10 % 10 + 48);
        }
        buffer[pos++] = (byte)(ipPart % 10 + 48);
        return pos;
    }

    protected final long appendTime(byte[] dateArray, int pos, long time) {
        this.calendar.setTime(new Date(time));
        int day = this.calendar.get(5);
        dateArray[pos++] = (byte)(day / 10 + 48);
        dateArray[pos++] = (byte)(day % 10 + 48);
        dateArray[pos++] = 47;
        int month = this.calendar.get(2);
        dateArray[pos++] = (byte)MONTH_NAME[month].charAt(0);
        dateArray[pos++] = (byte)MONTH_NAME[month].charAt(1);
        dateArray[pos++] = (byte)MONTH_NAME[month].charAt(2);
        dateArray[pos++] = 47;
        int year = this.calendar.get(1);
        dateArray[pos++] = (byte)(year / 1000 % 10 + 48);
        dateArray[pos++] = (byte)(year / 100 % 10 + 48);
        dateArray[pos++] = (byte)(year / 10 % 10 + 48);
        dateArray[pos++] = (byte)(year % 10 + 48);
        dateArray[pos++] = 58;
        int hour = this.calendar.get(11);
        dateArray[pos++] = (byte)(hour / 10 + 48);
        dateArray[pos++] = (byte)(hour % 10 + 48);
        dateArray[pos++] = 58;
        int minutes = this.calendar.get(12);
        dateArray[pos++] = (byte)(minutes / 10 + 48);
        dateArray[pos++] = (byte)(minutes % 10 + 48);
        dateArray[pos++] = 58;
        int seconds = this.calendar.get(13);
        dateArray[pos++] = (byte)(seconds / 10 + 48);
        dateArray[pos++] = (byte)(seconds % 10 + 48);
        int milliseconds = this.calendar.get(14);
        dateArray[pos++] = 46;
        dateArray[pos++] = (byte)(milliseconds / 100 % 10 + 48);
        dateArray[pos++] = (byte)(milliseconds / 10 % 10 + 48);
        dateArray[pos++] = (byte)(milliseconds % 10 + 48);
        dateArray[pos++] = 32;
        int offset = this.timeZone.getRawOffset();
        if (offset >= 0) {
            dateArray[pos++] = 43;
        } else {
            offset = -offset;
            dateArray[pos++] = 45;
        }
        dateArray[pos++] = (byte)(offset / 36000000 % 10 + 48);
        dateArray[pos++] = (byte)(offset / 3600000 % 10 + 48);
        dateArray[pos++] = (byte)(offset / 600000 % 6 + 48);
        dateArray[pos++] = (byte)(offset / 60000 % 10 + 48);
        return time;
    }

    public void setErrorLogger(Logger logger) {
    }
}

