/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.EvermindServletOutputStream;
import com.evermind.server.http.NullWriter;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;

public class ServletWriter
extends PrintWriter {
    public static final String ISO_8859_1 = "ISO8859_1";
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final char[] EOL = ServletWriter.getChars(System.getProperty("line.separator"));
    private static final int EOL_LENGTH = EOL.length;
    private static final char[] NULL = ServletWriter.getChars("null");
    private static final char[] TRUE = ServletWriter.getChars("true");
    private static final char[] FALSE = ServletWriter.getChars("false");
    private static final char[] INTEGER_MIN = ServletWriter.getChars("-2147483648");
    private static final NullWriter NULL_WRITER = new NullWriter();
    private CharToByteConverter fISO8859_1;
    private CharToByteConverter fConverter;
    private OutputStream fOut;
    private boolean fTrouble;
    private int fBufferSize;
    private boolean fNeedsReset;
    private int fTotalWritten;
    private int fContentLength;
    private char[] fCharBuffer;
    private int fCharBufferOffset;
    private byte[] fByteBuffer;
    private int fNextByteIndex;
    private char[] fScalarBuffer = new char[65];
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    private static char[] getChars(String s) {
        int length = s.length();
        char[] result = new char[length];
        s.getChars(0, length, result, 0);
        return result;
    }

    public ServletWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
        super((Writer)NULL_WRITER, false);
        this.reset(out, encoding, 8192);
    }

    public ServletWriter(OutputStream out, String encoding, int bufferSize) throws UnsupportedEncodingException {
        super((Writer)NULL_WRITER, false);
        this.reset(out, encoding, bufferSize);
    }

    public void reset(OutputStream out, String encoding) throws UnsupportedEncodingException {
        this.reset(out, encoding, 8192);
    }

    public void reset(OutputStream out, String encoding, int bufferSize) throws UnsupportedEncodingException {
        if (out == null) {
            throw new NullPointerException("out is null");
        }
        this.fOut = out;
        this.fNeedsReset = false;
        if (encoding.equals(ISO_8859_1)) {
            if (this.fISO8859_1 == null) {
                this.fConverter = this.fISO8859_1 = CharToByteConverter.getConverter((String)ISO_8859_1);
            } else {
                this.fConverter = this.fISO8859_1;
                this.fConverter.reset();
            }
        } else if (this.fConverter != null && this.fConverter.getCharacterEncoding().equals(encoding)) {
            this.fConverter.reset();
        } else {
            this.fConverter = CharToByteConverter.getConverter((String)encoding);
        }
        this.resetBuffer(bufferSize);
    }

    protected void resetBuffer(int bufferSize) {
        if (this.fByteBuffer == null || this.fBufferSize != bufferSize) {
            this.fByteBuffer = new byte[bufferSize];
            this.fCharBuffer = new char[bufferSize];
        }
        this.fBufferSize = bufferSize;
        this.fContentLength = ((EvermindServletOutputStream)((Object)this.fOut)).response.getContentLength();
        this.fTotalWritten = 0;
        this.fCharBufferOffset = 0;
        this.fNextByteIndex = 0;
        this.fTrouble = false;
    }

    protected void resetBuffer() {
        this.resetBuffer(8192);
    }

    public String getEncoding() {
        return this.fOut != null ? this.fConverter.getCharacterEncoding() : null;
    }

    protected void setContentLength(int contentLength) {
        this.fContentLength = contentLength;
    }

    public void write(char[] cbuf) {
        this.write(cbuf, 0, cbuf.length);
    }

    private void convertAndWriteChars(char[] cbuf, int off, int len) {
        try {
            int ci = off;
            int end = off + len;
            boolean bufferFlushed = false;
            while (ci < end) {
                try {
                    this.fNextByteIndex += this.fConverter.convertAny(cbuf, ci, end, this.fByteBuffer, this.fNextByteIndex, this.fBufferSize);
                    ci = end;
                }
                catch (ConversionBufferFullException x) {
                    int nci = this.fConverter.nextCharIndex();
                    if (nci == ci && bufferFlushed) {
                        throw new CharConversionException("Output buffer too small");
                    }
                    ci = nci;
                    this.fNextByteIndex = this.fConverter.nextByteIndex();
                }
                if (this.fNextByteIndex <= 0) continue;
                if (this.fOut == null) {
                    throw new NullPointerException("out is null");
                }
                this.fOut.write(this.fByteBuffer, 0, this.fNextByteIndex);
                this.fNextByteIndex = 0;
                bufferFlushed = true;
            }
        }
        catch (IOException e) {
            this.fTrouble = true;
        }
    }

    private void flushBuffer() {
        if (this.fOut == null || this.fCharBufferOffset == 0) {
            return;
        }
        try {
            this.convertAndWriteChars(this.fCharBuffer, 0, this.fCharBufferOffset);
            this.fCharBufferOffset = 0;
            while (true) {
                try {
                    this.fNextByteIndex += this.fConverter.flushAny(this.fByteBuffer, this.fNextByteIndex, this.fBufferSize);
                }
                catch (ConversionBufferFullException x) {
                    this.fNextByteIndex = this.fConverter.nextByteIndex();
                }
                if (this.fNextByteIndex != 0) {
                    if (this.fNextByteIndex <= 0) continue;
                    this.fOut.write(this.fByteBuffer, 0, this.fNextByteIndex);
                    this.fNextByteIndex = 0;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.fTrouble = true;
        }
    }

    public void flush() {
        try {
            this.flushBuffer();
            if (this.fOut != null) {
                this.fOut.flush();
            }
        }
        catch (IOException e) {
            this.fTrouble = true;
        }
    }

    public void close() {
        if (this.fOut == null) {
            return;
        }
        this.flush();
        try {
            this.fOut.close();
        }
        catch (IOException e) {
            this.fTrouble = true;
        }
        this.fOut = null;
        this.fNeedsReset = true;
    }

    protected boolean needsReset() {
        return this.fNeedsReset;
    }

    protected void primeReset() {
        this.fNeedsReset = true;
    }

    public void write(int c) {
        if (this.fOut == null) {
            this.fTrouble = true;
            return;
        }
        if (this.checkBufferLength()) {
            return;
        }
        this.fCharBuffer[this.fCharBufferOffset] = (char)c;
        this.wroteBytes(1);
    }

    private int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    private int checkWriteLength(int len) {
        if (this.fTotalWritten + len > this.fContentLength && this.fContentLength > 0) {
            len = this.fContentLength - this.fTotalWritten;
        }
        return len;
    }

    private void wroteBytes(int numBytes) {
        this.fCharBufferOffset += numBytes;
        this.fTotalWritten += numBytes;
    }

    private boolean checkBufferLength() {
        if (this.fTotalWritten >= this.fContentLength && this.fContentLength > 0) {
            this.flushBuffer();
            return true;
        }
        if (this.fCharBufferOffset >= this.fBufferSize) {
            this.flushBuffer();
        }
        return false;
    }

    public void write(char[] cbuf, int off, int len) {
        int d;
        if (this.fOut == null) {
            this.fTrouble = true;
            return;
        }
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if ((len = this.checkWriteLength(len)) >= this.fBufferSize) {
            this.flushBuffer();
            this.convertAndWriteChars(cbuf, off, len);
            return;
        }
        int t = off + len;
        for (int b = off; b < t; b += d) {
            d = this.min(this.fBufferSize - this.fCharBufferOffset, t - b);
            System.arraycopy(cbuf, b, this.fCharBuffer, this.fCharBufferOffset, d);
            this.wroteBytes(d);
            if (!this.checkBufferLength()) continue;
            break;
        }
    }

    public void write(String str) {
        this.write(str, 0, str.length());
    }

    public void write(String s, int off, int len) {
        int d;
        if (this.fOut == null) {
            this.fTrouble = true;
            return;
        }
        len = this.checkWriteLength(len);
        int t = off + len;
        for (int b = off; b < t; b += d) {
            d = this.min(this.fBufferSize - this.fCharBufferOffset, t - b);
            s.getChars(b, b + d, this.fCharBuffer, this.fCharBufferOffset);
            this.wroteBytes(d);
            if (!this.checkBufferLength()) continue;
            break;
        }
    }

    public final void newLine() {
        int d;
        int len = this.checkWriteLength(EOL_LENGTH);
        for (int b = 0; b < len; b += d) {
            d = this.min(this.fBufferSize - this.fCharBufferOffset, len - b);
            System.arraycopy(EOL, b, this.fCharBuffer, this.fCharBufferOffset, d);
            this.wroteBytes(d);
            if (!this.checkBufferLength()) continue;
            break;
        }
    }

    public boolean checkError() {
        if (this.fOut != null) {
            this.flush();
        }
        return this.fTrouble;
    }

    public void print(boolean b) {
        if (b) {
            this.write(TRUE, 0, 4);
        } else {
            this.write(FALSE, 0, 5);
        }
    }

    public final void print(char c) {
        this.write(c);
    }

    public void print(int i) {
        int r;
        int q;
        int charPos = 12;
        int sign = 0;
        if (i == Integer.MIN_VALUE) {
            this.write(INTEGER_MIN, 0, INTEGER_MIN.length);
            return;
        }
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            this.fScalarBuffer[--charPos] = DigitOnes[r];
            this.fScalarBuffer[--charPos] = DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            this.fScalarBuffer[--charPos] = digits[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            this.fScalarBuffer[--charPos] = sign;
        }
        this.write(this.fScalarBuffer, charPos, 12 - charPos);
    }

    public void print(long l) {
        boolean negative;
        int charPos = 64;
        boolean bl = negative = l < 0L;
        if (!negative) {
            l = -l;
        }
        while (l <= -10L) {
            this.fScalarBuffer[charPos--] = digits[(int)(-(l % 10L))];
            l /= 10L;
        }
        this.fScalarBuffer[charPos] = digits[(int)(-l)];
        if (negative) {
            this.fScalarBuffer[--charPos] = 45;
        }
        this.write(this.fScalarBuffer, charPos, 65 - charPos);
    }

    public void print(float f) {
        String str = Float.toString(f);
        this.write(str, 0, str.length());
    }

    public void print(double d) {
        String str = Double.toString(d);
        this.write(str, 0, str.length());
    }

    public void print(char[] s) {
        if (s == null) {
            this.write(NULL, 0, 4);
        } else {
            this.write(s, 0, s.length);
        }
    }

    public void print(String s) {
        if (s == null) {
            this.write(NULL, 0, 4);
        } else {
            this.write(s, 0, s.length());
        }
    }

    public void print(Object obj) {
        if (obj == null) {
            this.write(NULL, 0, 4);
        } else {
            String str = obj.toString();
            this.write(str, 0, str.length());
        }
    }

    public void println() {
        this.newLine();
    }

    public void println(boolean x) {
        if (x) {
            this.write(TRUE, 0, 4);
        } else {
            this.write(FALSE, 0, 5);
        }
        this.newLine();
    }

    public void println(char x) {
        this.write(x);
        this.newLine();
    }

    public void println(int x) {
        this.print(x);
        this.newLine();
    }

    public void println(long x) {
        this.print(x);
        this.newLine();
    }

    public void println(float x) {
        String str = Float.toString(x);
        this.write(str, 0, str.length());
        this.newLine();
    }

    public void println(double x) {
        String str = Double.toString(x);
        this.write(str, 0, str.length());
        this.newLine();
    }

    public void println(char[] x) {
        if (x == null) {
            this.write(NULL, 0, 4);
        } else {
            this.write(x, 0, x.length);
        }
        this.newLine();
    }

    public void println(String x) {
        if (x == null) {
            this.write(NULL, 0, 4);
        } else {
            this.write(x, 0, x.length());
        }
        this.newLine();
    }

    public void println(Object x) {
        if (x == null) {
            this.write(NULL, 0, 4);
        } else {
            String str = x.toString();
            this.write(str, 0, str.length());
        }
        this.newLine();
    }
}

