/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.ejb.EJBInputStream;
import com.evermind.server.http.EvermindHttpSession;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.HttpApplicationConfig;
import com.evermind.server.http.HttpMessages;
import com.evermind.server.http.PersistenceHttpSession;
import com.evermind.server.http.SessionReplicationService;
import com.evermind.server.http.persistence.InternalHttpSessionInterface;
import com.evermind.server.http.persistence.InternalHttpSessionObject;
import com.evermind.server.http.persistence.InternalHttpSessionTableCreator;
import com.evermind.util.ByteString;
import com.evermind.util.HTTPProperties;
import com.oracle.bricks.j2ee.JGroupConfig;
import com.oracle.bricks.j2ee.ReplicationPolicy;
import com.oracle.bricks.j2ee.SessionManager;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import oracle.ias.container.persistence.InternalPM;
import oracle.ias.container.persistence.InternalPMManager;
import oracle.ias.container.persistence.InternalPersistenceException;
import oracle.j2ee.clustering.ClusteringMessages;
import oracle.j2ee.util.TraceLogger;
import org.jgroups.ChannelException;

public class PersistenceHttpService
implements SessionReplicationService {
    static Logger log = PersistenceHttpService.getClusterLogger(PersistenceHttpService.class.getName());
    static final String projectFileName = "InternalHttpSessionPersistenceMapping.xml";
    private static final String DELETE_SESSION = "delete from oc4j_http_session where ? - LAST_ACCESSED > MAX_INACTIVE_TIME * 1000";
    private HttpApplication application;
    private int promiseTimeout;
    private String dataSourceName;
    private ReplicationPolicy replicationPolicy = null;
    private SessionManager manager;
    private static Logger m_traceLogger = TraceLogger.getLogger(PersistenceHttpService.class);

    protected PersistenceHttpService(HttpApplication application, HttpApplicationConfig config) throws ChannelException {
        JGroupConfig jconfig = config.getClusterConfig();
        this.application = application;
        this.promiseTimeout = jconfig.getPromiseTimeout();
        this.dataSourceName = jconfig.getDataSourceName();
        this.replicationPolicy = jconfig.getReplicationPolicy();
        String appName = application.getName();
        String protocol = config.getClusterConfig().getProtocol();
        if (application.getConfig().isDistributable()) {
            ClusteringMessages.infoPersistenceSessionManagerStarted("HTTP Persistence ", appName, this.dataSourceName, protocol);
            if (m_traceLogger.isLoggable(Level.FINEST)) {
                m_traceLogger.log(Level.FINEST, "EJB Persistence Clustering Service started for Application " + appName + " - state replication enabled over data source name " + this.dataSourceName + " using " + protocol + " protocol");
            }
        }
    }

    public static Logger getClusterLogger(String name) {
        Logger someLogger = Logger.getLogger(name);
        if (HTTPProperties.getHttpClusterDebug()) {
            someLogger.setLevel(Level.ALL);
        } else {
            someLogger.setLevel(Level.SEVERE);
        }
        return someLogger;
    }

    protected HttpApplication getHttpApplication() {
        return this.application;
    }

    protected InternalPM getPersistenceManager() {
        return this.getPersistenceManager(true);
    }

    protected InternalPM getPersistenceManager(boolean forceInitialization) {
        try {
            String key = this.application.getName() + ":" + this.application.name;
            InternalPM aPM = InternalPMManager.getInstance().getNonTransactionalPM(this.application.getName(), key, this.application.getClassLoader());
            if (!forceInitialization && !aPM.isInitialized()) {
                return aPM;
            }
            if (!aPM.isInitialized()) {
                if (this.dataSourceName == null) {
                    throw new InternalPersistenceException("Data source has not been specified in the cluster configuration");
                }
                String aDataSourceName = this.dataSourceName;
                aPM.initSession(projectFileName, aDataSourceName, HTTPProperties.getHttpClusterDebug());
                try {
                    aPM.createTables(new InternalHttpSessionTableCreator());
                }
                catch (InternalPersistenceException e) {
                    m_traceLogger.log(Level.FINEST, "duplicate ignore table creation exception");
                }
                this.forcefullyCleanupExpiredObjects();
            }
            return aPM;
        }
        catch (Exception e) {
            m_traceLogger.log(Level.FINEST, "Exception: " + e.getMessage(), e);
            throw new InternalPersistenceException(e.getMessage());
        }
    }

    public boolean isReplicateServletContext() {
        return false;
    }

    public boolean isOnCall() {
        return this.replicationPolicy.isOnCall();
    }

    public boolean isOnChange() {
        return this.replicationPolicy.isOnChange();
    }

    public void setReplicateServletContext(boolean replicateServletContext) {
        if (!replicateServletContext) {
            throw new IllegalStateException("NYI");
        }
    }

    public void updateContextRMIValue(String name) {
        throw new IllegalStateException("NYI");
    }

    public void sendContextValueUpdate(String name, Serializable value) {
        throw new IllegalStateException("NYI");
    }

    public EvermindHttpSession createSession(HttpApplication app, ByteString id, int timeout, byte[] addr) {
        try {
            InternalHttpSessionObject s = new InternalHttpSessionObject(id.toString(), HttpApplication.getSessionIp(addr), System.currentTimeMillis());
            return this.createSession(app, id, timeout, s);
        }
        catch (Exception e) {
            throw (RuntimeException)new IllegalStateException("failed in createSession").initCause(e);
        }
    }

    public EvermindHttpSession createSession(HttpApplication app, ByteString id, int timeout, InternalHttpSessionInterface internalSession) {
        return new PersistenceHttpSession(this, internalSession, app, id, timeout);
    }

    public InternalHttpSessionInterface refreshSession(InternalHttpSessionInterface internalSession) {
        return internalSession.refresh();
    }

    public void checkSessionTimeouts() {
        this.getHttpApplication()._checkSessionTimeouts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void forcefullyCleanupExpiredObjects() {
        block21: {
            m_traceLogger.log(Level.FINER, "cleanup expired objects.");
            try {
                InitialContext ic = new InitialContext();
                DataSource ds = (DataSource)ic.lookup(this.dataSourceName);
                Connection conn = null;
                PreparedStatement deleteFromSession = null;
                conn = ds.getConnection();
                deleteFromSession = conn.prepareStatement(DELETE_SESSION);
                deleteFromSession.setLong(1, System.currentTimeMillis());
                int deleted = deleteFromSession.executeUpdate();
                m_traceLogger.log(Level.FINER, "number of deleted expired objects : " + deleted);
                Object var7_8 = null;
                try {
                    if (deleteFromSession != null) {
                        deleteFromSession.close();
                    }
                }
                catch (SQLException e2) {
                    HttpMessages.infoSqlExceptionInClosingStatementCleanupExpiredObjects(this.application.toString(), this.dataSourceName, e2);
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    break block21;
                }
                catch (SQLException e2) {
                    HttpMessages.infoSqlExceptionInClosingConnectionCleanupExpiredObjects(this.application.toString(), this.dataSourceName, e2);
                }
                break block21;
                {
                    catch (SQLException e) {
                        HttpMessages.infoSqlExceptionCleanupExpiredObjects(this.application.toString(), this.dataSourceName, e);
                        Object var7_9 = null;
                        try {
                            if (deleteFromSession != null) {
                                deleteFromSession.close();
                            }
                        }
                        catch (SQLException e2) {
                            HttpMessages.infoSqlExceptionInClosingStatementCleanupExpiredObjects(this.application.toString(), this.dataSourceName, e2);
                        }
                        try {
                            if (conn != null) {
                                conn.close();
                            }
                            break block21;
                        }
                        catch (SQLException e2) {
                            HttpMessages.infoSqlExceptionInClosingConnectionCleanupExpiredObjects(this.application.toString(), this.dataSourceName, e2);
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    try {
                        if (deleteFromSession != null) {
                            deleteFromSession.close();
                        }
                    }
                    catch (SQLException e2) {
                        HttpMessages.infoSqlExceptionInClosingStatementCleanupExpiredObjects(this.application.toString(), this.dataSourceName, e2);
                    }
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (SQLException e2) {
                        HttpMessages.infoSqlExceptionInClosingConnectionCleanupExpiredObjects(this.application.toString(), this.dataSourceName, e2);
                    }
                    throw throwable;
                }
            }
            catch (NamingException ne) {
                HttpMessages.infoNameNotFoundExceptionInLookingUpDatasourceCleanupExpiredObjects(this.application.toString(), this.dataSourceName, ne);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvermindHttpSession getExistingSession(ByteString id) {
        Map sessionMap;
        EvermindHttpSession session = null;
        InternalPM aPM = this.getPersistenceManager();
        Map map = sessionMap = this.getHttpApplication().sessions;
        synchronized (map) {
            PersistenceHttpSession tempSession = (PersistenceHttpSession)sessionMap.get(id);
            if (tempSession != null) {
                session = tempSession.refresh();
                return session;
            }
            InternalHttpSessionInterface internalSession = null;
            ByteString sessionId = (ByteString)id.clone();
            try {
                internalSession = (InternalHttpSessionInterface)aPM.selectById(InternalHttpSessionObject.class, sessionId.toString());
            }
            catch (Exception e) {
                log.info("failed get from manager");
                throw (RuntimeException)new IllegalStateException("failed getting existing session").initCause(e);
            }
            if (internalSession == null) {
                return null;
            }
            session = this.createSession(this.getHttpApplication(), sessionId, internalSession.getMaxInactiveTime(), internalSession);
            sessionMap.put(sessionId, session);
            ((PersistenceHttpSession)session).doActivate();
            ClusteringMessages.finePersistentSessionRetrieval(sessionId);
        }
        return session;
    }

    public EvermindHttpSession read(EJBInputStream in) throws IOException, ClassNotFoundException {
        log.log(Level.SEVERE, "This service should never perform this operation");
        throw new IllegalStateException("This service should never perform this operation");
    }

    public void invalidateSession(ByteString id) {
        InternalHttpSessionInterface internalSession = null;
        try {
            InternalPM aPM = this.getPersistenceManager();
            internalSession = (InternalHttpSessionInterface)aPM.selectById(InternalHttpSessionObject.class, id.toString());
            if (internalSession != null && internalSession.isExpired(aPM.getDatabaseTimeStamp())) {
                aPM.deleteObject(internalSession);
                ClusteringMessages.fineInvalidateHttpSession(id.toString());
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "invalidation interupted", e);
        }
    }

    public void destroy() {
        log.info("destroy");
        this.getHttpApplication().flushDBSessions();
    }

    public int getFlushPolicy() {
        return -1;
    }
}

