/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PerlServlet
extends HttpServlet {
    private ServletContext context;
    private String interpreter;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.context = config.getServletContext();
        String interpreter = config.getInitParameter("interpreter");
        this.interpreter = interpreter == null ? "perl" : interpreter;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int i;
        int length;
        Process process;
        try {
            process = Runtime.getRuntime().exec(this.interpreter);
        }
        catch (Exception e) {
            response.sendError(500, "Could not find/launch the perl interpreter, searched for \"" + this.interpreter + '\"');
            return;
        }
        String requestURI = request.getRequestURI();
        String realPath = this.context.getRealPath(requestURI);
        File file = new File(realPath);
        byte[] source = new byte[(int)file.length()];
        FileInputStream fileIn = null;
        try {
            fileIn = new FileInputStream(file);
            fileIn.read(source);
            fileIn.close();
        }
        catch (FileNotFoundException ex) {
            throw new FileNotFoundException(requestURI);
        }
        InputStream processIn = process.getInputStream();
        OutputStream processOut = process.getOutputStream();
        InputStream processErr = process.getErrorStream();
        Enumeration names = request.getHeaderNames();
        String userAgent = request.getHeader("User-Agent");
        String queryString = request.getQueryString();
        String pathInfo = request.getPathInfo();
        String remoteUser = request.getRemoteUser();
        String authType = request.getAuthType();
        String requestAccept = request.getHeader("Accept");
        String requestMethod = request.getMethod();
        String requestContentType = request.getContentType();
        if (userAgent != null) {
            processOut.write(("$ENV{'HTTP_USER_AGENT'} = '" + this.unescape(userAgent) + "';\n").getBytes());
        }
        if (requestAccept != null) {
            processOut.write(("$ENV{'HTTP_ACCEPT'} = '" + this.unescape(requestAccept) + "';\n").getBytes());
        }
        if (userAgent != null) {
            processOut.write(("$ENV{'HTTP_USER_AGENT'} = '" + this.unescape(userAgent) + "';\n").getBytes());
        }
        if (requestContentType != null) {
            processOut.write(("$ENV{'CONTENT_TYPE'} = '" + this.unescape(requestContentType) + "';\n").getBytes());
        }
        if (queryString != null) {
            processOut.write(("$ENV{'QUERY_STRING'} = '" + this.unescape(queryString) + "';\n").getBytes());
        }
        if (remoteUser != null) {
            processOut.write(("$ENV{'REMOTE_USER'} = '" + this.unescape(remoteUser) + "';\n").getBytes());
        }
        if (pathInfo != null) {
            processOut.write(("$ENV{'PATH_INFO'} = '" + this.unescape(pathInfo) + "';\n").getBytes());
            processOut.write(("$ENV{'PATH_TRANSLATED'} = '" + this.unescape(request.getPathTranslated()) + "';\n").getBytes());
        }
        processOut.write(("$ENV{'REQUEST_URI'} = '" + this.unescape(requestURI) + "';\n").getBytes());
        processOut.write(("$ENV{'SERVER_SOFTWARE'} = '" + this.unescape(this.context.getServerInfo()) + "';\n").getBytes());
        processOut.write(("$ENV{'SERVER_NAME'} = '" + request.getServerName() + "';\n").getBytes());
        processOut.write("$ENV{'GATEWAY_INTERFACE'} = 'CGI/1.0';\n".getBytes());
        processOut.write(("$ENV{'SERVER_PORT'} = '" + request.getServerPort() + "';\n").getBytes());
        processOut.write(("$ENV{'REQUEST_METHOD'} = '" + this.unescape(requestMethod) + "';\n").getBytes());
        processOut.write(("$ENV{'REMOTE_HOST'} = '" + this.unescape(request.getRemoteHost()) + "';\n").getBytes());
        processOut.write(("$ENV{'REMOTE_ADDR'} = '" + request.getRemoteAddr() + "';\n").getBytes());
        processOut.write(("$ENV{'SCRIPT_NAME'} = '" + this.unescape(requestURI) + "';\n").getBytes());
        processOut.write(("$ENV{'REQUEST_URI'} = '" + this.unescape(requestURI) + "';\n").getBytes());
        processOut.write(("$ENV{'CONTENT_LENGTH'} = '" + request.getContentLength() + "';\n").getBytes());
        processOut.write(source);
        byte[] buffer = new byte[1024];
        if (requestMethod.equals("POST") || requestMethod.equals("PUT")) {
            processOut.write("\n__END__\n".getBytes());
            ServletInputStream servletIn = request.getInputStream();
            while ((length = servletIn.read(buffer)) != -1) {
                processOut.write(buffer, 0, length);
            }
        }
        processOut.close();
        length = 0;
        response.setContentType("text/html");
        while ((i = processIn.read()) != -1) {
            if (i == 13) continue;
            if (i == 10) {
                if (length == 0) break;
                String line = new String(buffer, 0, length);
                length = 0;
                int colonPos = line.indexOf(58);
                if (colonPos < 0) continue;
                String name = line.substring(0, colonPos).trim();
                String value = line.substring(colonPos + 1, line.length()).trim();
                if (name.equalsIgnoreCase("Content-Type")) {
                    response.setContentType(value);
                    continue;
                }
                if (name.equalsIgnoreCase("Content-Length")) {
                    response.setContentLength(Integer.parseInt(value));
                    continue;
                }
                if (name.equalsIgnoreCase("Location")) {
                    response.sendRedirect(value);
                    processIn.close();
                    return;
                }
                response.setHeader(name, value);
                continue;
            }
            if (length >= 1024) continue;
            buffer[length++] = (byte)i;
        }
        ServletOutputStream out = response.getOutputStream();
        boolean errorOccured = false;
        while ((length = processIn.read(buffer)) != -1) {
            out.write(buffer, 0, length);
        }
        while ((length = processErr.read(buffer)) != -1) {
            out.write(buffer, 0, length);
        }
        out.flush();
    }

    public String unescape(String string) {
        if (string.indexOf("'") < 0) {
            return string;
        }
        StringBuffer buffer = new StringBuffer();
        int pos = 0;
        int foundPos = 0;
        while ((foundPos = string.indexOf("'", pos)) >= 0) {
            buffer.append(string.substring(pos, foundPos));
            buffer.append("\\'");
            pos = foundPos + 1;
        }
        buffer.append(string.substring(pos, string.length()));
        return buffer.toString();
    }
}

