/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.ApplicationServerThread;
import com.evermind.server.ContextContainer;
import com.evermind.server.ThreadState;
import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.EvermindHttpServletResponse;
import com.evermind.server.http.FileRequestDispatcher;
import com.evermind.server.http.HttpApplication;
import com.evermind.util.ByteString;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

class GenericFilterRequestDispatcher
implements RequestDispatcher,
Servlet {
    static final ByteString EMPTY_BYTESTRING = new ByteString("");
    ByteString requestURI;
    ByteString servletPath;
    ByteString pathInfo;
    private HttpApplication application;
    private FilterChain firstFilter;
    private RequestDispatcher wrappedDispatcher;

    public GenericFilterRequestDispatcher(HttpApplication application, FilterChain firstFilter, RequestDispatcher wrappedDispatcher, ByteString requestURI) {
        if (application == null) {
            throw new NullPointerException("application was null");
        }
        this.application = application;
        this.firstFilter = firstFilter;
        this.wrappedDispatcher = wrappedDispatcher;
        this.requestURI = requestURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpApplication previousApplication = this.application;
        byte previousInputFetchStatus = 0;
        byte previousFetchStatus = 0;
        EvermindHttpServletRequest req = request instanceof EvermindHttpServletRequest ? (EvermindHttpServletRequest)request : EvermindHttpServletRequest.getThreadRequest();
        EvermindHttpServletResponse res = response instanceof EvermindHttpServletResponse ? (EvermindHttpServletResponse)response : EvermindHttpServletResponse.getThreadResponse();
        previousApplication = req.originalApplication;
        req.originalApplication = req.application;
        req.application = this.application;
        previousInputFetchStatus = req.inputFetchStatus;
        previousFetchStatus = res.outputFetchStatus;
        byte previousOutputFetchStatus = res.outputFetchStatus;
        res.outputFetchStatus = 0;
        req.inputFetchStatus = 0;
        try {
            this.invoke(request, response);
            Object var10_9 = null;
            if (res.getCurrentWriter() != null) {
                res.writer.flush();
            }
            res.outputFetchStatus = previousOutputFetchStatus;
            req.inputFetchStatus = previousInputFetchStatus;
            res.outputFetchStatus = previousFetchStatus;
            req.application = req.originalApplication;
            req.originalApplication = previousApplication;
            if (res.getCurrentWriter() != null) {
                res.writer.flush();
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (res.getCurrentWriter() != null) {
                res.writer.flush();
            }
            res.outputFetchStatus = previousOutputFetchStatus;
            req.inputFetchStatus = previousInputFetchStatus;
            res.outputFetchStatus = previousFetchStatus;
            req.application = req.originalApplication;
            req.originalApplication = previousApplication;
            if (res.getCurrentWriter() != null) {
                res.writer.flush();
            }
            throw throwable;
        }
    }

    public void forward(ServletRequest request, ServletResponse genericResponse) throws ServletException, IOException {
        HttpServletResponse response;
        try {
            response = (HttpServletResponse)genericResponse;
        }
        catch (ClassCastException e) {
            throw new ServletException("This resource only accepts HttpServletResponse instances");
        }
        this.forwardInternal(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forwardInternal(ServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        EvermindHttpServletRequest req = request instanceof EvermindHttpServletRequest ? (EvermindHttpServletRequest)request : EvermindHttpServletRequest.getThreadRequest();
        EvermindHttpServletResponse res = response instanceof EvermindHttpServletResponse ? (EvermindHttpServletResponse)response : EvermindHttpServletResponse.getThreadResponse();
        ByteString includeRequestURI = req.requestURI;
        req.requestURI = this.requestURI;
        res.outputFetchStatus = 0;
        req.servletPath = this.servletPath;
        req.pathInfo = this.pathInfo;
        req.application = this.application;
        if (res.contentTypeHeader == null && res.contentType == null) {
            res.setContentType("text/plain");
        }
        try {
            this.invoke(request, (ServletResponse)response);
        }
        finally {
            if (includeRequestURI != null) {
                req.requestURI = includeRequestURI;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        ApplicationServerThread thread = ThreadState.getInheritableCurrentState().getApplicationServerThread();
        ContextContainer previousContainer = thread.state.contextContainer;
        thread.state.contextContainer = this.application;
        EvermindHttpServletRequest evermindRequest = EvermindHttpServletRequest.getThreadRequest();
        try {
            Servlet previousServlet = evermindRequest.currentPostFilterServlet;
            FileRequestDispatcher previousFile = evermindRequest.currentPostFilterFile;
            try {
                evermindRequest.currentPostFilterServlet = this;
                evermindRequest.currentPostFilterFile = null;
                this.firstFilter.doFilter(request, response);
            }
            finally {
                evermindRequest.currentPostFilterServlet = previousServlet;
                evermindRequest.currentPostFilterFile = previousFile;
            }
            return;
        }
        finally {
            thread.state.contextContainer = previousContainer;
        }
    }

    public String toString() {
        return "Filtered " + this.wrappedDispatcher;
    }

    public HttpApplication getApplication() {
        return this.application;
    }

    public void setApplication(HttpApplication application) {
        if (application == null) {
            throw new NullPointerException("application was null");
        }
        this.application = application;
    }

    public void init(ServletConfig config) {
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        EvermindHttpServletRequest threadRequest = EvermindHttpServletRequest.getThreadRequest();
        if (threadRequest.isIncluded()) {
            this.wrappedDispatcher.include(request, response);
        } else {
            this.wrappedDispatcher.forward(request, response);
        }
    }

    public String getServletInfo() {
        return "";
    }

    public void destroy() {
    }

    public ServletConfig getServletConfig() {
        return null;
    }

    public static RequestDispatcher getRequestDispatcher(HttpApplication application, EvermindHttpServletRequest request, ByteString requestURI, RequestDispatcher wrapped) throws ServletException {
        if (request == null) {
            throw new NullPointerException("request was null");
        }
        FilterChain first = request.getFilter(requestURI, null);
        if (first == null) {
            return wrapped;
        }
        return new GenericFilterRequestDispatcher(application, first, wrapped, requestURI);
    }
}

