/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.EvermindHttpServletResponse;
import com.evermind.server.http.HttpDateFormat;
import com.evermind.server.http.StandardRequestLogger;
import com.evermind.util.ArrayUtils;
import com.evermind.util.LogEvent;
import com.evermind.util.Logger;
import com.evermind.util.StringUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.Cookie;

public class FormattedRequestLogger
extends StandardRequestLogger {
    public static final int LOG_SPLIT_NONE = 0;
    public static final int LOG_SPLIT_HOUR = 1;
    public static final int LOG_SPLIT_DAY = 2;
    public static final int LOG_SPLIT_WEEK = 3;
    public static final int LOG_SPLIT_MONTH = 4;
    public static final long HOUR_MASK = -3600001L;
    public static final long DAY_MASK = 86400023L;
    public static final long WEEK_MASK = -604800162L;
    public static final int DIRECTIVE_PATH = 1;
    public static final int DIRECTIVE_SIZE = 2;
    public static final int DIRECTIVE_REQUEST = 3;
    public static final int DIRECTIVE_METHOD = 4;
    public static final int DIRECTIVE_PROTOCOL = 5;
    public static final int DIRECTIVE_IP = 6;
    public static final int DIRECTIVE_HOST = 7;
    public static final int DIRECTIVE_USER = 8;
    public static final int DIRECTIVE_STATUS = 9;
    public static final int DIRECTIVE_REFERER = 10;
    public static final int DIRECTIVE_TIME = 11;
    public static final int DIRECTIVE_AGENT = 12;
    public static final int DIRECTIVE_MIMETYPE = 13;
    public static final int DIRECTIVE_COOKIE = 14;
    public static final int DIRECTIVE_HEADER = 15;
    private Calendar calendar = Calendar.getInstance();
    private byte[] dateArray = new byte[30];
    private long currentTimeMillis;
    private String format;
    private int splitMode;
    private long lastTime;
    private String path;
    private String prefix;
    private String suffix;
    private int[] directives;
    private Object[] infos;
    private byte[][] padding;
    private String timeSuffix;
    private Logger errorLogger;

    public FormattedRequestLogger(String path, int splitMode, String format, boolean autoFlush, String timeSuffix) throws InstantiationException {
        super(null, autoFlush);
        this.path = path;
        int dotPos = this.path.lastIndexOf(46);
        if (dotPos == -1) {
            this.prefix = path;
            this.suffix = "";
        } else {
            this.prefix = path.substring(0, dotPos);
            this.suffix = path.substring(dotPos);
        }
        this.splitMode = splitMode;
        if (format != null) {
            this.setFormat(format);
        }
        this.timeSuffix = timeSuffix;
    }

    public void setFormat(String format) throws InstantiationException {
        this.format = format;
        int pos = 0;
        int found = 0;
        ArrayList<byte[]> paddings = new ArrayList<byte[]>();
        ArrayList<Integer> directives = new ArrayList<Integer>();
        while (pos < format.length()) {
            found = format.indexOf(36, pos);
            if (found < 0) {
                paddings.add(format.substring(pos).getBytes());
                pos = format.length();
                continue;
            }
            paddings.add(format.substring(pos, found).getBytes());
            boolean isCookieName = false;
            for (pos = found; pos < format.length(); ++pos) {
                if (Character.isJavaIdentifierPart(format.charAt(pos)) || isCookieName && format.charAt(pos) == '-') continue;
                if ((format.charAt(pos) != ':' || !format.substring(found + 1, pos).equals("cookie")) && (format.charAt(pos) != ':' || !format.substring(found + 1, pos).equals("header"))) break;
                isCookieName = true;
            }
            if (pos < ++found) {
                throw new InstantiationException("Standalone $ found in log format");
            }
            String var = format.substring(found, pos);
            if (var.equals("path")) {
                directives.add(new Integer(1));
                continue;
            }
            if (var.equals("size")) {
                directives.add(new Integer(2));
                continue;
            }
            if (var.equals("request")) {
                directives.add(new Integer(3));
                continue;
            }
            if (var.equals("method")) {
                directives.add(new Integer(4));
                continue;
            }
            if (var.equals("protocol")) {
                directives.add(new Integer(5));
                continue;
            }
            if (var.equals("ip")) {
                directives.add(new Integer(6));
                continue;
            }
            if (var.equals("host")) {
                directives.add(new Integer(7));
                continue;
            }
            if (var.equals("user")) {
                directives.add(new Integer(8));
                continue;
            }
            if (var.equals("status")) {
                directives.add(new Integer(9));
                continue;
            }
            if (var.equals("referer")) {
                directives.add(new Integer(10));
                continue;
            }
            if (var.equals("time")) {
                directives.add(new Integer(11));
                continue;
            }
            if (var.equals("agent")) {
                directives.add(new Integer(12));
                continue;
            }
            if (var.equals("mime")) {
                directives.add(new Integer(13));
                continue;
            }
            if (var.startsWith("cookie:")) {
                this.addInfo(directives.size(), var.substring("cookie:".length()));
                directives.add(new Integer(14));
                continue;
            }
            if (var.startsWith("header:")) {
                this.addInfo(directives.size(), var.substring("header:".length()));
                directives.add(new Integer(15));
                continue;
            }
            throw new InstantiationException("Unknown log directive: '" + var + "'");
        }
        while (paddings.size() <= directives.size()) {
            paddings.add(new byte[0]);
        }
        this.padding = (byte[][])paddings.toArray((T[])new byte[paddings.size()][]);
        this.directives = new int[directives.size()];
        for (int i = 0; i < this.directives.length; ++i) {
            this.directives[i] = ((Number)directives.get(i)).intValue();
        }
    }

    public synchronized void log(EvermindHttpServletRequest request, EvermindHttpServletResponse response) throws IOException {
        if (this.pos > 3800) {
            if (this.pos > this.buffer.length) {
                this.pos = this.buffer.length;
            }
            this.out.write(this.buffer, 0, this.pos);
            this.pos = 0;
        } else if (this.pos < 0) {
            this.pos = 0;
        }
        if (this.splitMode != 0) {
            long currentTime = HttpDateFormat.currentTimeLong;
            if (currentTime != this.lastTime) {
                switch (this.splitMode) {
                    case 2: {
                        if ((currentTime & 0x5265C17L) == (this.lastTime & 0x5265C17L)) break;
                        if (this.out != null) {
                            this.flush();
                            this.out.close();
                        }
                        SimpleDateFormat format = new SimpleDateFormat(this.timeSuffix == null ? "-yyyy-MM-dd" : this.timeSuffix);
                        try {
                            this.out = new FileOutputStream(this.prefix + format.format(new Date(currentTime)) + this.suffix, true);
                            break;
                        }
                        catch (IOException e) {
                            if (this.errorLogger != null) {
                                this.errorLogger.log(new LogEvent("Error logging HTTP request: " + e.getMessage(), e));
                            }
                            throw e;
                        }
                    }
                    case 1: {
                        if ((currentTime & 0xFFFFFFFFFFC9117FL) == (this.lastTime & 0xFFFFFFFFFFC9117FL)) break;
                        if (this.out != null) {
                            this.flush();
                            this.out.close();
                        }
                        SimpleDateFormat format = new SimpleDateFormat(this.timeSuffix == null ? "-yyyy-MM-dd - HH" : this.timeSuffix);
                        try {
                            this.out = new FileOutputStream(this.prefix + format.format(new Date(currentTime)) + this.suffix, true);
                            break;
                        }
                        catch (IOException e) {
                            if (this.errorLogger != null) {
                                this.errorLogger.log(new LogEvent("Error logging HTTP request: " + e.getMessage(), e));
                            }
                            throw e;
                        }
                    }
                    case 3: {
                        if ((currentTime & 0x5265C17L) == (this.lastTime & 0x5265C17L)) break;
                        Calendar lastCalendar = Calendar.getInstance();
                        Calendar currentCalendar = Calendar.getInstance();
                        lastCalendar.setTime(new Date(this.lastTime));
                        currentCalendar.setTime(new Date(currentTime));
                        if (lastCalendar.get(1) == currentCalendar.get(1) && lastCalendar.get(3) == currentCalendar.get(3)) break;
                        if (this.out != null) {
                            this.flush();
                            this.out.close();
                        }
                        SimpleDateFormat format = new SimpleDateFormat(this.timeSuffix == null ? "-yyyy-ww" : this.timeSuffix);
                        try {
                            this.out = new FileOutputStream(this.prefix + format.format(new Date(currentTime)) + this.suffix, true);
                            break;
                        }
                        catch (IOException e) {
                            if (this.errorLogger != null) {
                                this.errorLogger.log(new LogEvent("Error logging HTTP request: " + e.getMessage(), e));
                            }
                            throw e;
                        }
                    }
                    case 4: {
                        if ((currentTime & 0x5265C17L) == (this.lastTime & 0x5265C17L)) break;
                        Calendar lastCalendar = Calendar.getInstance();
                        Calendar currentCalendar = Calendar.getInstance();
                        lastCalendar.setTime(new Date(this.lastTime));
                        currentCalendar.setTime(new Date(currentTime));
                        if (lastCalendar.get(1) == currentCalendar.get(1) && lastCalendar.get(2) == currentCalendar.get(2)) break;
                        if (this.out != null) {
                            this.flush();
                            this.out.close();
                        }
                        SimpleDateFormat format = new SimpleDateFormat(this.timeSuffix == null ? "-yyyy-MM" : this.timeSuffix);
                        try {
                            this.out = new FileOutputStream(this.prefix + format.format(new Date(currentTime)) + this.suffix, true);
                            break;
                        }
                        catch (IOException e) {
                            if (this.errorLogger != null) {
                                this.errorLogger.log(new LogEvent("Error logging HTTP request: " + e.getMessage(), e));
                            }
                            throw e;
                        }
                    }
                }
                this.lastTime = currentTime;
            }
        } else if (this.out == null) {
            try {
                this.out = new FileOutputStream(this.path, true);
            }
            catch (IOException e) {
                if (this.errorLogger != null) {
                    this.errorLogger.log(new LogEvent("Error logging HTTP request: " + e.getMessage(), e));
                }
                throw e;
            }
        }
        if (this.directives == null) {
            super.log(request, response);
            return;
        }
        byte[][] padding = this.padding;
        block33: for (int i = 0; i < padding.length; ++i) {
            byte[] currentPadding = padding[i];
            System.arraycopy(currentPadding, 0, this.buffer, this.pos, currentPadding.length);
            this.pos += currentPadding.length;
            if (i == padding.length - 1) continue;
            switch (this.directives[i]) {
                case 1: {
                    if (request.application != null && request.application.root != null) {
                        System.arraycopy(request.application.root.data, request.application.root.offset, this.buffer, this.pos, request.application.root.length);
                        this.pos += request.application.root.length;
                    }
                    if (request.requestURI == null) continue block33;
                    System.arraycopy(request.requestURI.data, request.requestURI.offset, this.buffer, this.pos, request.requestURI.length);
                    this.pos += request.requestURI.length;
                    continue block33;
                }
                case 3: {
                    if (request.headerLineLength != request.headerLineRealLength) {
                        byte[] input = request.getInput();
                        System.arraycopy(input, request.headerStartPos, this.buffer, this.pos, request.headerLineRealLength - 9);
                        this.pos += request.headerLineRealLength;
                        System.arraycopy(input, request.headerStartPos + request.headerLineLength - 9, this.buffer, this.pos - 9, 9);
                        if (this.buffer[this.pos - 1] >= 16) continue block33;
                        this.pos -= 2;
                        continue block33;
                    }
                    int y = 0;
                    byte[] input = request.getInput();
                    for (y = 0; y < request.headerLineLength && input[request.headerStartPos + y] != 13 && input[request.headerStartPos + y] != 10; ++y) {
                    }
                    System.arraycopy(input, request.headerStartPos, this.buffer, this.pos, y);
                    this.pos += y;
                    if (this.buffer[this.pos - 1] >= 16) continue block33;
                    this.pos -= 2;
                    continue block33;
                }
                case 6: {
                    this.pos = this.appendIP(this.buffer, this.pos, request.socket.getInetAddress());
                    continue block33;
                }
                case 7: {
                    this.pos = this.appendString(this.buffer, this.pos, request.socket.getInetAddress().getHostName());
                    continue block33;
                }
                case 10: {
                    String referer = request.getHeader("referer");
                    if (referer == null) continue block33;
                    this.pos = this.appendString(this.buffer, this.pos, referer);
                    continue block33;
                }
                case 12: {
                    String agent = request.getHeader("user-agent");
                    if (agent == null) continue block33;
                    this.pos = this.appendString(this.buffer, this.pos, agent);
                    continue block33;
                }
                case 13: {
                    if (response.contentType == null) continue block33;
                    this.pos = this.appendString(this.buffer, this.pos, response.contentType);
                    continue block33;
                }
                case 11: {
                    this.pos = this.appendCurrentTime(this.buffer, this.pos);
                    continue block33;
                }
                case 9: {
                    this.pos = ArrayUtils.writeInt(this.buffer, this.pos, response.status == 0 ? 200 : response.status);
                    continue block33;
                }
                case 2: {
                    this.pos = ArrayUtils.writeInt(this.buffer, this.pos, response.out.bytesWritten);
                    continue block33;
                }
                case 8: {
                    String user = request.getRemoteUser();
                    if (user != null) {
                        this.buffer[this.pos++] = 39;
                        if (user.indexOf(39) >= 0) {
                            user = StringUtils.replace(user, '\'', "''");
                        }
                        this.pos = this.appendString(this.buffer, this.pos, user);
                        this.buffer[this.pos++] = 39;
                        continue block33;
                    }
                    this.buffer[this.pos++] = 45;
                    continue block33;
                }
                case 4: {
                    this.pos = this.appendString(this.buffer, this.pos, request.getMethod());
                    continue block33;
                }
                case 5: {
                    this.pos = this.appendString(this.buffer, this.pos, request.getProtocol());
                    continue block33;
                }
                case 14: {
                    Cookie[] cookies = request.getCookies();
                    if (cookies == null) continue block33;
                    for (int x = 0; x < cookies.length; ++x) {
                        if (!cookies[x].getName().equals(this.infos[i])) continue;
                        String value = cookies[x].getValue();
                        if (value == null) continue block33;
                        if (value.indexOf(39) >= 0) {
                            value = StringUtils.replace(value, '\'', "''");
                        }
                        this.pos = this.appendString(this.buffer, this.pos, value);
                        continue block33;
                    }
                    continue block33;
                }
                case 15: {
                    String header = request.getHeader((String)this.infos[i]);
                    if (header == null) continue block33;
                    if (header.indexOf(39) >= 0) {
                        header = StringUtils.replace(header, '\'', "''");
                    }
                    this.pos = this.appendString(this.buffer, this.pos, header);
                    continue block33;
                }
                default: {
                    throw new RuntimeException("Unsupported log directive: " + this.directives[i]);
                }
            }
        }
        this.buffer[this.pos++] = 10;
        if (this.pos > 3800) {
            if (this.pos > this.buffer.length) {
                this.pos = this.buffer.length;
            }
            this.out.write(this.buffer, 0, this.pos);
            this.pos = 0;
        }
        this.pos = this.pos;
    }

    protected final int appendString(byte[] buffer, int pos, String value) {
        byte[] valueBytes = value.getBytes();
        System.arraycopy(valueBytes, 0, buffer, pos, valueBytes.length);
        return pos + valueBytes.length;
    }

    protected final int appendCurrentTime(byte[] buffer, int pos) {
        if (this.currentTimeMillis != HttpDateFormat.currentTimeLong) {
            this.currentTimeMillis = HttpDateFormat.currentTimeLong;
            this.appendTime(this.dateArray, 0, this.currentTimeMillis);
        }
        System.arraycopy(this.dateArray, 0, buffer, pos, this.dateArray.length);
        return pos + this.dateArray.length;
    }

    public void addInfo(int pos, Object value) {
        if (this.infos == null) {
            this.infos = new Object[pos + 1];
            this.infos[pos] = value;
        } else if (this.infos.length > pos) {
            this.infos[pos] = value;
        } else {
            Object[] newInfos = new Object[pos + 1];
            System.arraycopy(this.infos, 0, newInfos, 0, this.infos.length);
            this.infos = newInfos;
            this.infos[pos] = value;
        }
    }

    public void setErrorLogger(Logger logger) {
        this.errorLogger = logger;
    }
}

