/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.ThreadState;
import com.evermind.server.http.ErrorRequestDispatcher;
import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.EvermindHttpSession;
import com.evermind.server.http.GenericFilterRequestDispatcher;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.HttpAuthenticator;
import com.evermind.util.ByteString;
import com.evermind.util.HTTPProperties;
import java.io.IOException;
import java.net.PasswordAuthentication;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FormHttpAuthenticator
implements HttpAuthenticator,
RequestDispatcher {
    protected ByteString loginPage;
    protected ByteString errorPage;

    public String getAuthType() {
        return "Form";
    }

    public FormHttpAuthenticator(String loginPage, String errorPage) {
        this.loginPage = new ByteString(loginPage);
        this.errorPage = new ByteString(errorPage);
    }

    public static PasswordAuthentication getDefaultAuthentication(HttpServletRequest request) {
        EvermindHttpServletRequest evermindRequest = request instanceof EvermindHttpServletRequest ? (EvermindHttpServletRequest)request : EvermindHttpServletRequest.getOriginalRequest();
        String username = evermindRequest.getInternalParameter("j_username");
        String password = evermindRequest.getInternalParameter("j_password");
        evermindRequest.inputFetchStatus = 0;
        return HttpApplication.getAuthentication(username, password, evermindRequest);
    }

    public PasswordAuthentication getAuthentication(HttpServletRequest request) {
        return FormHttpAuthenticator.getDefaultAuthentication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reject(HttpServletRequest request, HttpServletResponse response, int reason) throws IOException, ServletException {
        EvermindHttpServletRequest evermindRequest = request instanceof EvermindHttpServletRequest ? (EvermindHttpServletRequest)request : EvermindHttpServletRequest.getOriginalRequest();
        response.setHeader("Cache-Control", "no-cache");
        try {
            request.getInputStream();
        }
        catch (Throwable t) {
            // empty catch block
        }
        HttpSession session = request.getSession();
        if (session instanceof EvermindHttpSession) {
            FormHttpAuthenticator.initSession((EvermindHttpSession)session, request);
        }
        if ((((EvermindHttpSession)session).status & 2) == 0) {
            RequestDispatcher dispatcher = evermindRequest.application.getLocalDispatcher(this.loginPage, ThreadState.getInheritableCurrentState());
            if (dispatcher == null) {
                dispatcher = GenericFilterRequestDispatcher.getRequestDispatcher(evermindRequest.application, evermindRequest, evermindRequest.requestURI, new ErrorRequestDispatcher(404, "Could not find form-login page: '" + this.loginPage + "'"));
            }
            try {
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                Object var8_10 = null;
                if (evermindRequest == null) return;
                evermindRequest.originalApplication = null;
                return;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (evermindRequest == null) throw throwable;
                evermindRequest.originalApplication = null;
                throw throwable;
            }
        }
        if (reason == 1) {
            response.setStatus(200);
        } else {
            response.setStatus(403);
        }
        ((EvermindHttpSession)session).status &= 0xFFFFFFFD;
        if (reason == 1 && HTTPProperties.getFormAuthClientSideRedirect()) {
            String contextPath = evermindRequest.getContextPath();
            response.sendRedirect(contextPath + this.errorPage.toString());
            return;
        }
        RequestDispatcher dispatcher = evermindRequest.application.getLocalDispatcher(this.errorPage, ThreadState.getInheritableCurrentState());
        if (dispatcher == null) {
            dispatcher = GenericFilterRequestDispatcher.getRequestDispatcher(evermindRequest.application, evermindRequest, evermindRequest.requestURI, new ErrorRequestDispatcher(404, "Could not find form-login-error page: '" + this.errorPage + "'"));
        }
        if (evermindRequest != null) {
            evermindRequest.originalApplication = evermindRequest.application;
        }
        try {
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            Object var10_13 = null;
            if (evermindRequest == null) return;
            evermindRequest.originalApplication = null;
            return;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (evermindRequest == null) throw throwable;
            evermindRequest.originalApplication = null;
            throw throwable;
        }
    }

    public void include(ServletRequest genericRequest, ServletResponse genericResponse) throws ServletException, IOException {
        this.forward(genericRequest, genericResponse);
    }

    public void forward(ServletRequest genericRequest, ServletResponse genericResponse) throws ServletException, IOException {
        EvermindHttpServletRequest evermindRequest;
        HttpServletRequest request = (HttpServletRequest)genericRequest;
        HttpServletResponse response = (HttpServletResponse)genericResponse;
        HttpSession session = request.getSession();
        if (session instanceof EvermindHttpSession && request instanceof EvermindHttpServletRequest) {
            request.getParameter("");
            FormHttpAuthenticator.initSession((EvermindHttpSession)session, request);
        }
        try {
            request.getInputStream();
        }
        catch (Throwable t) {
            // empty catch block
        }
        EvermindHttpServletRequest evermindHttpServletRequest = evermindRequest = request instanceof EvermindHttpServletRequest ? (EvermindHttpServletRequest)request : EvermindHttpServletRequest.getOriginalRequest();
        if (evermindRequest.getInternalParameter("j_username") == null) {
            RequestDispatcher dispatcher = evermindRequest.application.getRequestDispatcher(this.loginPage, null, null);
            if (dispatcher == null) {
                dispatcher = GenericFilterRequestDispatcher.getRequestDispatcher(evermindRequest.application, evermindRequest, new ByteString(request.getRequestURI()), new ErrorRequestDispatcher(404, "Could not find form-login page: '" + this.loginPage + "'"));
            }
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            RequestDispatcher dispatcher = evermindRequest.application.getRequestDispatcher(this.errorPage, null, null);
            if (dispatcher == null) {
                dispatcher = GenericFilterRequestDispatcher.getRequestDispatcher(evermindRequest.application, evermindRequest, new ByteString(request.getRequestURI()), new ErrorRequestDispatcher(404, "Could not find form-login-error page: '" + this.errorPage + "'"));
            }
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected static void initSession(EvermindHttpSession session, HttpServletRequest request) {
        session.status |= 1;
        EvermindHttpServletRequest evermindRequest = request instanceof EvermindHttpServletRequest ? (EvermindHttpServletRequest)request : EvermindHttpServletRequest.getOriginalRequest();
        evermindRequest.saveFormAuthInfo();
    }
}

