/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.AJPHttpServletRequest;
import com.evermind.server.http.HttpApplication;
import com.evermind.util.ByteString;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class FixPathRequestDispatcher
implements RequestDispatcher {
    ByteString requestURI;
    HttpApplication application;
    RequestDispatcher nested;
    ByteString queryString;

    public FixPathRequestDispatcher(RequestDispatcher nested) {
        this.nested = nested;
    }

    public void forward(ServletRequest genericRequest, ServletResponse genericResponse) throws ServletException, IOException {
        ((HttpServletRequest)genericRequest).getSession(this.application.autoJoinSession);
        HttpServletRequest request = (HttpServletRequest)genericRequest;
        StringBuffer location = new StringBuffer();
        if (request instanceof AJPHttpServletRequest) {
            location.append(((AJPHttpServletRequest)request).isSecure() ? "https://" : "http://");
        } else {
            location.append(this.application.site.secure ? "https://" : "http://");
        }
        String host = request.getHeader("host");
        if (request instanceof AJPHttpServletRequest) {
            location.append(host);
        } else {
            if (host == null) {
                host = this.application.site.getHost();
            }
            if (host.indexOf(58) >= 0) {
                location.append(host);
            } else {
                location.append(host);
                if (this.application.site.secure && this.application.site.posingAsPort != 443 || !this.application.site.secure && this.application.site.posingAsPort != 80) {
                    location.append(':');
                    location.append(this.application.site.posingAsPort);
                }
            }
        }
        if (this.application.contextPath != null) {
            location.append(this.application.contextPath);
        }
        location.append(this.requestURI);
        location.append('/');
        if (this.queryString != null) {
            location.append('?');
            location.append(this.queryString);
        }
        HttpServletResponse response = (HttpServletResponse)genericResponse;
        response.setStatus(301);
        response.setHeader("Location", location.toString());
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.nested.include(request, response);
    }

    public static boolean is1_1OrAbove(String protocol) {
        if (protocol.length() < 3) {
            return false;
        }
        char first = protocol.charAt(protocol.length() - 3);
        char second = protocol.charAt(protocol.length() - 1);
        if (first < '0' || first > '9' || second < '0' || second > '9') {
            return false;
        }
        return (first - 48) * 10 + (second - 48) >= 11;
    }
}

